/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.mall.ability.api.UccMallCommodityListsAbilityService;
import com.tydic.commodity.mall.ability.api.UccSynchronizeCMSInfoService;
import com.tydic.commodity.mall.ability.bo.UccMallAddCmsArticelSkuBO;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceQryBusiReqBO;
import com.tydic.commodity.mall.ability.bo.UccSyncCmsInfoReqBo;
import com.tydic.commodity.mall.ability.bo.UccSyncCmsInfoRspBO;
import com.tydic.commodity.mall.atom.api.InterfaceAddMultiArticleService;
import com.tydic.commodity.mall.atom.api.InterfaceRemoveCmsSkuInfoService;
import com.tydic.commodity.mall.atom.bo.InterfaceAddCmsArticelSkuInfoBO;
import com.tydic.commodity.mall.atom.bo.InterfaceAddCmsArticelSkuInfoReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceAddCmsArticelSkuInfoRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceRemoveSkuInfoReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceRemoveSkuInfoRspBO;
import com.tydic.commodity.mall.busi.api.UccQrySkuCMSInfoService;
import com.tydic.commodity.mall.busi.bo.CMSSkuInfoBO;
import com.tydic.commodity.mall.busi.bo.QrySkuCMSInfoReqBO;
import com.tydic.commodity.mall.busi.bo.QrySkuCMSInfoRspBO;
import com.tydic.commodity.mall.config.CommdProPertiesVo;
import com.tydic.commodity.mall.constants.CmsSkuColumnNameEnum;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ListCloneUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccSynchronizeCMSInfoService"})
public class UccSynchronizeCMSInfoServiceImpl
implements UccSynchronizeCMSInfoService {
    private static final Logger log = LoggerFactory.getLogger(UccSynchronizeCMSInfoServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(UccSynchronizeCMSInfoServiceImpl.class);
    @Autowired
    private UccQrySkuCMSInfoService qrySkuCMSInfoService;
    @Autowired
    private InterfaceRemoveCmsSkuInfoService interfaceRemoveCmsSkuInfoService;
    @Autowired
    private CommdProPertiesVo commdProPertiesVo;
    @Autowired
    private UccMallCommodityMapper uccCommodityMapper;
    @Autowired
    private UccMallCommodityListsAbilityService commodityListsAbilityService;
    @Autowired
    private InterfaceAddMultiArticleService interfaceAddMultiArticleService;

    @PostMapping(value={"sync"})
    public UccSyncCmsInfoRspBO sync(@RequestBody UccSyncCmsInfoReqBo syncCmsInfoReqBo) {
        UccSyncCmsInfoRspBO uccSyncCmsInfoRspBO = new UccSyncCmsInfoRspBO();
        QrySkuCMSInfoReqBO qrySkuCMSInfoReqBO = new QrySkuCMSInfoReqBO();
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(CmsSkuColumnNameEnum.bgsb.code());
        arrayList.add(CmsSkuColumnNameEnum.bgyp.code());
        arrayList.add(CmsSkuColumnNameEnum.dnzj.code());
        arrayList.add(CmsSkuColumnNameEnum.ghyp.code());
        arrayList.add(CmsSkuColumnNameEnum.rzyp.code());
        InterfaceRemoveSkuInfoReqBO uccRemoveSkuInfoReqBO = new InterfaceRemoveSkuInfoReqBO();
        uccRemoveSkuInfoReqBO.setColumnCode(arrayList);
        uccRemoveSkuInfoReqBO.setUrl(this.commdProPertiesVo.getDelArticleByColumnCodeUrl());
        InterfaceRemoveSkuInfoRspBO uccRemoveSkuInfoRspBO = this.interfaceRemoveCmsSkuInfoService.removeCmsSkuInfo(uccRemoveSkuInfoReqBO);
        if (!uccRemoveSkuInfoRspBO.isSuccess()) {
            LOGGER.error("\u5220\u9664cms\u680f\u76ee\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a", (Object)uccRemoveSkuInfoRspBO.getRespDesc());
            uccSyncCmsInfoRspBO.setRespCode("8888");
            uccSyncCmsInfoRspBO.setRespDesc(uccRemoveSkuInfoRspBO.getRespDesc());
            return uccSyncCmsInfoRspBO;
        }
        qrySkuCMSInfoReqBO.setArrayList(arrayList);
        QrySkuCMSInfoRspBO qrySkuCMSInfoRspBO = null;
        try {
            qrySkuCMSInfoRspBO = this.qrySkuCMSInfoService.qrySkuCMSInfo(qrySkuCMSInfoReqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636ecms \u914d\u7f6e\u67e5\u8be2sku\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            uccSyncCmsInfoRspBO.setRespCode("8888");
            uccSyncCmsInfoRspBO.setRespDesc("\u6839\u636ecms \u914d\u7f6e\u67e5\u8be2sku\u4fe1\u606f\u5931\u8d25");
            return uccSyncCmsInfoRspBO;
        }
        try {
            this.sendAddMultiArticleAction(qrySkuCMSInfoRspBO);
        }
        catch (BusinessException e) {
            uccSyncCmsInfoRspBO.setRespCode(e.getMsgCode());
            uccSyncCmsInfoRspBO.setRespDesc(e.getMsgInfo());
            return uccSyncCmsInfoRspBO;
        }
        uccRemoveSkuInfoReqBO = new InterfaceRemoveSkuInfoReqBO();
        ArrayList stringArrayList = Lists.newArrayList();
        stringArrayList.add(CmsSkuColumnNameEnum.shop.code());
        uccRemoveSkuInfoReqBO.setColumnCode(stringArrayList);
        uccRemoveSkuInfoReqBO.setUrl(this.commdProPertiesVo.getDelArticleByColumnCodeUrl());
        InterfaceRemoveSkuInfoRspBO removeSkuInfoRspBO = this.interfaceRemoveCmsSkuInfoService.removeCmsSkuInfo(uccRemoveSkuInfoReqBO);
        if (!removeSkuInfoRspBO.isSuccess()) {
            LOGGER.error("\u5220\u9664cms\u7535\u5b50\u8d85\u5e02\u7236\u7ea7\u680f\u76ee\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a", (Object)uccRemoveSkuInfoRspBO.getRespDesc());
            uccSyncCmsInfoRspBO.setRespCode("8888");
            uccSyncCmsInfoRspBO.setRespDesc(uccRemoveSkuInfoRspBO.getRespDesc());
            return uccSyncCmsInfoRspBO;
        }
        uccSyncCmsInfoRspBO.setRespCode("0000");
        uccSyncCmsInfoRspBO.setRespDesc("\u6210\u529f");
        return uccSyncCmsInfoRspBO;
    }

    private void sendAddMultiArticleAction(QrySkuCMSInfoRspBO qrySkuCMSInfoRspBO) {
        if (CollectionUtils.isEmpty(qrySkuCMSInfoRspBO.getCmsSkuInfoBOS())) {
            LOGGER.error("CMS\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728");
            throw new BusinessException("8888", "CMS\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Map<String, List<CMSSkuInfoBO>> groupBy = qrySkuCMSInfoRspBO.getCmsSkuInfoBOS().stream().collect(Collectors.groupingBy(CMSSkuInfoBO::getColumnCode));
        try {
            for (Map.Entry<String, List<CMSSkuInfoBO>> stringListEntry : groupBy.entrySet()) {
                List<CMSSkuInfoBO> cmsSkuInfoBOS = stringListEntry.getValue();
                this.doSendAddMultiArticleAction(cmsSkuInfoBOS);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589ecms\u5546\u54c1\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u65b0\u589ecms\u5546\u54c1\u6570\u636e\u5931\u8d25", e);
        }
    }

    private void doSendAddMultiArticleAction(List<CMSSkuInfoBO> cmsSkuInfoBOS) {
        List<InterfaceAddCmsArticelSkuInfoBO> addCmsArticelSkuInfoBOS;
        List<UccMallAddCmsArticelSkuBO> addCmsArticelSkuBOS = this.getSkuInfo(cmsSkuInfoBOS);
        InterfaceAddCmsArticelSkuInfoReqBO uccAddCmsArticelSkuInfoReqBO = new InterfaceAddCmsArticelSkuInfoReqBO();
        uccAddCmsArticelSkuInfoReqBO.setUrl(this.commdProPertiesVo.getAddMultiArticleActionUrl());
        try {
            addCmsArticelSkuInfoBOS = ListCloneUtils.clonePOListToBOList(addCmsArticelSkuBOS, InterfaceAddCmsArticelSkuInfoBO.class);
            CMSSkuInfoBO cmsSkuInfoBO = cmsSkuInfoBOS.get(0);
            for (InterfaceAddCmsArticelSkuInfoBO addCmsArticelSkuInfoBO : addCmsArticelSkuInfoBOS) {
                addCmsArticelSkuInfoBO.setBasicTitle(cmsSkuInfoBO.getColumnName());
                addCmsArticelSkuInfoBO.setColumnCode(cmsSkuInfoBO.getColumnCode());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0cms \u6587\u7ae0\u6570\u636e\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u6dfb\u52a0cms \u6587\u7ae0\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
        }
        uccAddCmsArticelSkuInfoReqBO.setCmsArticelSkuInfoBOS(addCmsArticelSkuInfoBOS);
        InterfaceAddCmsArticelSkuInfoRspBO uccAddCmsArticelSkuInfoRspBO = this.interfaceAddMultiArticleService.AddSkuMultiArticle(uccAddCmsArticelSkuInfoReqBO);
        if (!uccAddCmsArticelSkuInfoRspBO.isSuccess()) {
            LOGGER.error("\u53d1\u9001http\u65b0\u589ecms\u5546\u54c1\u4fe1\u606f\u5931\u8d25,\u539f\u56e0:", (Object)uccAddCmsArticelSkuInfoRspBO.getRespDesc());
            throw new BusinessException(uccAddCmsArticelSkuInfoRspBO.getRespCode(), uccAddCmsArticelSkuInfoRspBO.getRespDesc());
        }
    }

    private List<UccMallAddCmsArticelSkuBO> getSkuInfo(List<CMSSkuInfoBO> cmsSkuInfoBOS) {
        ArrayList skuIds = Lists.newArrayList();
        for (CMSSkuInfoBO cmsSkuInfoBO : cmsSkuInfoBOS) {
            skuIds.add(Long.valueOf(cmsSkuInfoBO.getSkuId()));
        }
        UccMallCurrentPriceQryBusiReqBO uccCurrentPriceQryReqBO = null;
        List<UccMallAddCmsArticelSkuBO> commodityPos = this.uccCommodityMapper.batchQueryCommoBySkuId(skuIds);
        if (CollectionUtils.isEmpty(commodityPos)) {
            LOGGER.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5230cms\uff0c\u67e5\u8be2\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728,skuIDS:" + skuIds);
            return commodityPos;
        }
        for (UccMallAddCmsArticelSkuBO commodityPo : commodityPos) {
            uccCurrentPriceQryReqBO = new UccMallCurrentPriceQryBusiReqBO();
            if (StringUtils.isNotBlank((CharSequence)commodityPo.getSkuName())) {
                commodityPo.setSkuName(commodityPo.getSkuName().replaceAll("'", ""));
                commodityPo.setSkuName(commodityPo.getSkuName().replaceAll("<", ""));
                commodityPo.setSkuName(commodityPo.getSkuName().replaceAll(">", ""));
                commodityPo.setSkuName(commodityPo.getSkuName().replaceAll("\"", ""));
            }
            uccCurrentPriceQryReqBO.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{commodityPo.getSkuId()}));
            uccCurrentPriceQryReqBO.setSupplierShopId(commodityPo.getSupplierShopId());
            BigDecimal skuInfoPriceBos = null;
            try {
                skuInfoPriceBos = this.commodityListsAbilityService.dealCurrentPrice(uccCurrentPriceQryReqBO);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u540c\u6b65cms\u8c03\u7528\u67e5\u8be2\u4ef7\u683c\u5931\u8d25");
            }
            commodityPo.setSalePrice(skuInfoPriceBos);
        }
        return commodityPos;
    }
}

