/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallQuerySpecimenMerchantOnSaleService;
import com.tydic.commodity.mall.ability.bo.UccCombEsCommodityBo;
import com.tydic.commodity.mall.ability.bo.UccMallQuerySpecimenMerchantOnBO;
import com.tydic.commodity.mall.ability.bo.UccMallQuerySpecimenMerchantOnReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQuerySpecimenMerchantOnRspBO;
import com.tydic.commodity.mall.atom.api.UccMallCurrentStockQryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallSkuNumBO_Atom;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuStandardRelationMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.UccMallSimilarSkuPO;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQuerySpecimenMerchantOnSaleService"})
public class UccMallQuerySpecimenMerchantOnSaleServiceImpl
implements UccMallQuerySpecimenMerchantOnSaleService {
    private static final Logger log = LogManager.getLogger(UccMallQuerySpecimenMerchantOnSaleServiceImpl.class);
    @Autowired
    private UccMallSkuMapper skuMapper;
    @Autowired
    private UccMallSkuStandardRelationMapper uccMallSkuStandardRelationMapper;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private UccMallCurrentStockQryAtomService uccMallCurrentStockQryAtomService;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;

    @PostMapping(value={"getUccMallQuerySpecimenMerchantOnSaleService"})
    public UccMallQuerySpecimenMerchantOnRspBO getUccMallQuerySpecimenMerchantOnSaleService(@RequestBody UccMallQuerySpecimenMerchantOnReqBO reqBO) {
        UccMallQuerySpecimenMerchantOnRspBO rspBO = new UccMallQuerySpecimenMerchantOnRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getStdSkuId())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        List<Long> skuIds = this.uccMallSkuStandardRelationMapper.querySkuIdListByStdSkuId(reqBO.getStdSkuId());
        if (CollectionUtils.isEmpty(skuIds) || skuIds.size() == 0) {
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u51fa\u5173\u8054\u5355\u54c1");
            return rspBO;
        }
        List<UccMallSimilarSkuPO> similarSkuPoList = this.skuMapper.qrySimilarSkuList((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize(), skuIds, reqBO.getOrderByColumn(), reqBO.getOrderType());
        ArrayList<UccMallQuerySpecimenMerchantOnBO> uccMallQuerySpecimenMerchantOnBOList = new ArrayList<UccMallQuerySpecimenMerchantOnBO>();
        if (!CollectionUtils.isEmpty(similarSkuPoList)) {
            for (UccMallSimilarSkuPO similarSkuPo : similarSkuPoList) {
                if (!similarSkuPo.getSkuStatus().equals(3)) continue;
                UccMallQuerySpecimenMerchantOnBO uccMallQuerySpecimenMerchantOnBO = this.editSkuBo(similarSkuPo);
                uccMallQuerySpecimenMerchantOnBOList.add(uccMallQuerySpecimenMerchantOnBO);
            }
        }
        rspBO.setRows(uccMallQuerySpecimenMerchantOnBOList);
        Integer total = this.skuMapper.qrySimilarSkuCount(skuIds);
        rspBO.setTotal(total.intValue());
        rspBO.setRecordsTotal(total.intValue());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccMallQuerySpecimenMerchantOnBO editSkuBo(UccMallSimilarSkuPO similarSkuPo) {
        UccMallCurrentStockQryRspBO uccMallCurrentStockQryRspBO;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)similarSkuPo.getSkuId()));
        JSONObject queryJson = new JSONObject();
        String queryString = boolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String result = this.searchInfo(queryJson.toString());
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
        if (!listObject.isEmpty()) {
            JSONObject hitObj = listObject.getJSONObject(0);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
        }
        UccMallQuerySpecimenMerchantOnBO uccMallQuerySpecimenMerchantOnBO = new UccMallQuerySpecimenMerchantOnBO();
        uccMallQuerySpecimenMerchantOnBO = (UccMallQuerySpecimenMerchantOnBO)JSONObject.parseObject((String)JSON.toJSONString((Object)similarSkuPo), UccMallQuerySpecimenMerchantOnBO.class);
        uccMallQuerySpecimenMerchantOnBO.setOtherSkuCode(uccMallQuerySpecimenMerchantOnBO.getExtSkuId());
        if (!StringUtils.isEmpty((Object)commodity)) {
            uccMallQuerySpecimenMerchantOnBO.setChannelIds(commodity.getChannel_id());
        }
        UccMallCurrentStockQryReqBO uccMallCurrentStockQryReqBO = new UccMallCurrentStockQryReqBO();
        UccMallSkuNumBO_Atom uccMallSkuNumBO_atom = new UccMallSkuNumBO_Atom();
        uccMallSkuNumBO_atom.setSkuId(uccMallQuerySpecimenMerchantOnBO.getSkuId().toString());
        uccMallSkuNumBO_atom.setNum(new BigDecimal(String.valueOf(uccMallQuerySpecimenMerchantOnBO.getMoq())));
        ArrayList<UccMallSkuNumBO_Atom> skuNum = new ArrayList<UccMallSkuNumBO_Atom>();
        skuNum.add(uccMallSkuNumBO_atom);
        uccMallCurrentStockQryReqBO.setSkuNum(skuNum);
        uccMallCurrentStockQryReqBO.setSupplierId(uccMallQuerySpecimenMerchantOnBO.getSupplierShopId());
        SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(uccMallQuerySpecimenMerchantOnBO.getSupplierId());
        if (ObjectUtil.isNotEmpty((Object)supplierBusiPo)) {
            uccMallCurrentStockQryReqBO.setSupplierCode(supplierBusiPo.getSupplierCode());
        }
        if ("0000".equals((uccMallCurrentStockQryRspBO = this.uccMallCurrentStockQryAtomService.qryCommdCurrentStock(uccMallCurrentStockQryReqBO)).getRespCode())) {
            BigDecimal remainNum = uccMallCurrentStockQryRspBO.getCommdStockInfo().get(0).getRemainNum();
            uccMallQuerySpecimenMerchantOnBO.setUnsaleNum(Long.valueOf(remainNum.longValue()));
        }
        return uccMallQuerySpecimenMerchantOnBO;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.mallEsConfig.getIndexName() + "/" + this.mallEsConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }
}

