/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceFreightQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceFreightBO;
import com.tydic.commodity.mall.atom.bo.InterfaceFreightQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceFreightQryRspBO;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccFreightQryService")
public class InterfaceFreightQryServiceImpl
implements InterfaceFreightQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceFreightQryServiceImpl.class);

    @Override
    public InterfaceFreightQryRspBO qryFreight(InterfaceFreightQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_TRANS_FEE_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_TRANS_FEE_URL") + "]");
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            InterfaceFreightQryRspBO resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(InterfaceFreightQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sku", reqBO.getSku());
        jsonObject.put("supplierCode", (Object)reqBO.getSupplierCode());
        jsonObject.put("province", (Object)reqBO.getProvince());
        jsonObject.put("city", (Object)reqBO.getCity());
        jsonObject.put("county", (Object)reqBO.getCounty());
        jsonObject.put("town", (Object)reqBO.getTown());
        if ("jd".equals(reqBO.getSupplierCode())) {
            jsonObject.put("paymentType ", (Object)reqBO.getPaymentType());
        }
        return jsonObject.toString();
    }

    private InterfaceFreightQryRspBO resolveRsp(String returnString) {
        InterfaceFreightQryRspBO rspBO = new InterfaceFreightQryRspBO();
        try {
            JSONArray jsonArray;
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setRespDesc("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setRespDesc("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u8fd0\u8d39\u5b9e\u65f6\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef");
                }
                rspBO.setRespCode("8888");
                return rspBO;
            }
            JSONObject object = (JSONObject)rspJsonObject.get((Object)"result");
            String freight = JSONObject.toJSONString((Object)object);
            InterfaceFreightBO freightBO = (InterfaceFreightBO)JSONObject.parseObject((String)freight, InterfaceFreightBO.class);
            ArrayList<String> remoteSku = new ArrayList<String>();
            if (object != null && (jsonArray = object.getJSONArray("remoteSku")) != null && jsonArray.size() > 0) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    remoteSku.add((String)jsonArray.get(i));
                }
            }
            freightBO.setRemoteSku(remoteSku);
            rspBO.setFreightBO(freightBO);
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

