/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallChannelStatisticsAbilityService;
import com.tydic.commodity.mall.ability.bo.UccChannelBo;
import com.tydic.commodity.mall.ability.bo.UccMallChannelStatisticsAbilityBo;
import com.tydic.commodity.mall.ability.bo.UccMallChannelStatisticsAbilityReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallChannelStatisticsAbilityRspBo;
import com.tydic.commodity.mall.constants.SkuSourceEnum;
import com.tydic.commodity.mall.dao.UccMallCommodityExtMapper;
import com.tydic.commodity.mall.po.UccChannelStatisticsAbilityPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallChannelStatisticsAbilityService"})
public class UccMallChannelStatisticsAbilityServiceImpl
implements UccMallChannelStatisticsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallChannelStatisticsAbilityServiceImpl.class);
    @Autowired
    private UccMallCommodityExtMapper uccCommodityExtMapper;

    @PostMapping(value={"getChannelStatistics"})
    public UccMallChannelStatisticsAbilityRspBo getChannelStatistics(@RequestBody UccMallChannelStatisticsAbilityReqBo reqBo) {
        UccMallChannelStatisticsAbilityRspBo rspBo = new UccMallChannelStatisticsAbilityRspBo();
        List<UccChannelStatisticsAbilityPo> cnncChannelStatisticsAbilityPos = this.uccCommodityExtMapper.getChannel();
        ArrayList<UccMallChannelStatisticsAbilityBo> cnncChannelStatisticsAbilityBos = new ArrayList<UccMallChannelStatisticsAbilityBo>();
        if (!CollectionUtils.isEmpty(cnncChannelStatisticsAbilityPos)) {
            Map<Integer, List<UccChannelStatisticsAbilityPo>> group = cnncChannelStatisticsAbilityPos.stream().collect(Collectors.groupingBy(UccChannelStatisticsAbilityPo::getSkuSource));
            for (Map.Entry<Integer, List<UccChannelStatisticsAbilityPo>> each : group.entrySet()) {
                UccMallChannelStatisticsAbilityBo cnncChannelStatisticsAbilityBo = new UccMallChannelStatisticsAbilityBo();
                cnncChannelStatisticsAbilityBo.setSkuSource(each.getKey());
                cnncChannelStatisticsAbilityBo.setSkuSourceDesc(SkuSourceEnum.getSourceDesc(each.getKey()).getSourceDesc());
                ArrayList<UccChannelBo> cnncChannelBos = new ArrayList<UccChannelBo>();
                for (UccChannelStatisticsAbilityPo cnncChannelStatisticsAbilityPo : each.getValue()) {
                    UccChannelBo cnncChannelBo = new UccChannelBo();
                    cnncChannelBo.setChannelId(cnncChannelStatisticsAbilityPo.getChannelId());
                    cnncChannelBo.setChannelName(cnncChannelStatisticsAbilityPo.getChannelName());
                    cnncChannelBos.add(cnncChannelBo);
                }
                cnncChannelStatisticsAbilityBo.setChannelInfos(cnncChannelBos);
                cnncChannelStatisticsAbilityBos.add(cnncChannelStatisticsAbilityBo);
            }
        }
        rspBo.setData(cnncChannelStatisticsAbilityBos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

