/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.mall.busi.api.UccMallInsertPriceChangeLogBusiService;
import com.tydic.commodity.mall.busi.api.UccMallPriChangeBusiService;
import com.tydic.commodity.mall.busi.api.UccMallQueryDBDateBusiService;
import com.tydic.commodity.mall.busi.api.UccMallSkuAdjustPriceBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallInsertPriceChangeLogBusiReqBo;
import com.tydic.commodity.mall.busi.bo.UccMallInsertPriceChangeLogReqBo;
import com.tydic.commodity.mall.busi.bo.UccMallMqSyncCommdPriceBo;
import com.tydic.commodity.mall.busi.bo.UccMallPriChangeReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallPriChangeRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallSkuPriceChangeBO;
import com.tydic.commodity.mall.busi.bo.UccMallSkuPriceVO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallAddCoefficientMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallECommercePriceChangeLogMapper;
import com.tydic.commodity.mall.dao.UccMallECommercePriceChangeMapper;
import com.tydic.commodity.mall.dao.UccMallParamsConfigDetailMapper;
import com.tydic.commodity.mall.dao.UccMallParamsConfigMapper;
import com.tydic.commodity.mall.dao.UccMallSkuAddCoefficientMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceLogMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccAddCoefficientPO;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccMallParamsConfigDetailPO;
import com.tydic.commodity.mall.po.UccMallParamsConfigPO;
import com.tydic.commodity.mall.po.UccMallSkuAddCoefficientPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMallPriChangeBusiServiceImpl
implements UccMallPriChangeBusiService {
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Autowired
    private UccMallSkuPriceLogMapper uccMallSkuPriceLogMapper;
    @Autowired
    private UccMallAddCoefficientMapper uccMallAddCoefficientMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallPriChangeBusiServiceImpl.class);
    @Autowired
    private UccMallSkuAdjustPriceBusiService uccMallSkuAdjustPriceBusiService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallECommercePriceChangeMapper uccMallECommercePriceChangeMapper;
    @Autowired
    private UccMallECommercePriceChangeLogMapper uccMallECommercePriceChangeLogMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    private Sequence coefficientSequence = Sequence.getInstance();
    private static final BigDecimal yuanToMilli = new BigDecimal(10000);
    @Resource(name="uccMallchangePriceServiceProvider")
    private ProxyMessageProducer uccMallchangePriceServiceProvider;
    @Autowired
    private UccMallQueryDBDateBusiService uccMallQueryDBDateBusiService;
    @Autowired
    private UccMallInsertPriceChangeLogBusiService uccMallInsertPriceChangeLogBusiService;
    @Autowired
    private UccMallSkuAddCoefficientMapper uccMallSkuAddCoefficientMapper;
    @Autowired
    private UccMallParamsConfigMapper uccMallParamsConfigMapper;
    @Autowired
    private UccMallParamsConfigDetailMapper uccMallParamsConfigDetailMapper;

    @Override
    public UccMallPriChangeRspBO changePrice(UccMallPriChangeReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSkuPriceInfos() == null) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), "\u4ef7\u683c\u53d8\u66f4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierShopId() == null) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<UccMallInsertPriceChangeLogReqBo> uccMallInsertPriceChangeLogReqBos = new ArrayList<UccMallInsertPriceChangeLogReqBo>();
        ArrayList<UccMallSkuPriceVO> uccMallSkuPriceVOList = new ArrayList<UccMallSkuPriceVO>();
        ArrayList<UccMallMqSyncCommdPriceBo> uccMallMqSyncCommdPriceBoList = new ArrayList<UccMallMqSyncCommdPriceBo>();
        for (UccMallSkuPriceChangeBO uccMallSkuPriceChangeBO : reqBO.getSkuPriceInfos()) {
            UccCommodityTypePo uccCommodityTypePo;
            if (uccMallSkuPriceChangeBO.getSkuId() == null || uccMallSkuPriceChangeBO.getPrice() == null || uccMallSkuPriceChangeBO.getMarketPrice() == null) continue;
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setExtSkuId(uccMallSkuPriceChangeBO.getSkuId());
            uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
            List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
            if (uccSkuPoList == null || uccSkuPoList.size() != 1) continue;
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(uccSkuPoList.get(0).getSkuId());
            uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPricePo.setCurrencyType(null);
            if ((uccSkuPricePo = this.uccMallSkuPriceMapper.querySkuPrice(uccSkuPricePo)) == null || (uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(uccSkuPoList.get(0).getCommodityTypeId())) == null) continue;
            Long catalogId = uccCommodityTypePo.getCatalogId();
            BigDecimal addCoefficient = new BigDecimal(0);
            Integer allowMarketPrice = 0;
            UccMallSkuAddCoefficientPO uccSkuAddCoefficientPO = this.uccMallSkuAddCoefficientMapper.selectBySkuId(uccSkuPoList.get(0).getSkuId());
            if (uccSkuAddCoefficientPO != null) {
                if (uccSkuAddCoefficientPO.getAddCoefficient() != null) {
                    addCoefficient = uccSkuAddCoefficientPO.getAddCoefficient();
                    addCoefficient = addCoefficient.divide(new BigDecimal(100), 4, 5);
                }
                if (uccSkuAddCoefficientPO.getAllowMarketPrice() != null) {
                    allowMarketPrice = uccSkuAddCoefficientPO.getAllowMarketPrice();
                }
            } else {
                UccAddCoefficientPO uccAddCoefficientPO = this.uccMallAddCoefficientMapper.qryCoefficientByCatalogIdAndSupplierShopId(catalogId, reqBO.getSupplierShopId());
                if (uccAddCoefficientPO != null) {
                    if (uccAddCoefficientPO.getAddCoefficient() != null) {
                        addCoefficient = uccAddCoefficientPO.getAddCoefficient();
                        addCoefficient = addCoefficient.divide(new BigDecimal(100), 4, 5);
                    }
                    if (uccAddCoefficientPO.getAllowMarketPrice() != null) {
                        allowMarketPrice = uccAddCoefficientPO.getAllowMarketPrice();
                    }
                } else {
                    UccMallParamsConfigPO uccMallParamsConfigPO = new UccMallParamsConfigPO();
                    uccMallParamsConfigPO.setParamsCode("ESTORE_DEFAULT_COEFFICIENT");
                    UccMallParamsConfigPO modelBy = this.uccMallParamsConfigMapper.getModelBy(uccMallParamsConfigPO);
                    if (modelBy != null) {
                        UccMallParamsConfigDetailPO uccMallParamsConfigDetailPO = new UccMallParamsConfigDetailPO();
                        uccMallParamsConfigDetailPO.setParamsId(modelBy.getParamsId());
                        UccMallParamsConfigDetailPO detailPO = this.uccMallParamsConfigDetailMapper.getModelBy(uccMallParamsConfigDetailPO);
                        if (detailPO != null) {
                            if (!StringUtils.isEmpty((Object)detailPO.getRule())) {
                                addCoefficient = new BigDecimal(detailPO.getRule());
                                addCoefficient = addCoefficient.divide(new BigDecimal(100), 4, 5);
                            }
                            allowMarketPrice = 0;
                        }
                    }
                }
            }
            BigDecimal salePrice = uccMallSkuPriceChangeBO.getPrice().multiply(addCoefficient.add(new BigDecimal(1)));
            if (allowMarketPrice == 0 && salePrice.compareTo(uccMallSkuPriceChangeBO.getMarketPrice()) > 0) {
                salePrice = uccMallSkuPriceChangeBO.getMarketPrice();
            }
            salePrice = salePrice.setScale(2, 4);
            int result1 = MoneyUtils.yuanToHao(salePrice).compareTo(new BigDecimal(uccSkuPricePo.getSalePrice()));
            UccMallSkuPriceVO skuPriceVO = new UccMallSkuPriceVO();
            skuPriceVO.setAgreementPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getPrice()));
            skuPriceVO.setMarketPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getMarketPrice()));
            skuPriceVO.setSalePrice(MoneyUtils.yuanToHaoToLong(salePrice));
            skuPriceVO.setSkuId(uccSkuPoList.get(0).getSkuId());
            skuPriceVO.setExtSkuId(uccSkuPoList.get(0).getExtSkuId());
            skuPriceVO.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            uccMallSkuPriceVOList.add(skuPriceVO);
            int result = MoneyUtils.yuanToHao(uccMallSkuPriceChangeBO.getPrice()).compareTo(new BigDecimal(uccSkuPricePo.getAgreementPrice()));
            int result2 = MoneyUtils.yuanToHao(uccMallSkuPriceChangeBO.getMarketPrice()).compareTo(new BigDecimal(uccSkuPricePo.getMarketPrice()));
            if (result == 0 && result1 == 0 && result2 == 0) continue;
            UccMallMqSyncCommdPriceBo mqSyncCommdPriceBo = new UccMallMqSyncCommdPriceBo();
            mqSyncCommdPriceBo.setAgreementPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getPrice()));
            mqSyncCommdPriceBo.setOrgSalePrice(salePrice);
            mqSyncCommdPriceBo.setSalePrice(MoneyUtils.yuanToHaoToLong(salePrice));
            mqSyncCommdPriceBo.setMarketPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getMarketPrice()));
            mqSyncCommdPriceBo.setExtSkuId(uccSkuPo.getExtSkuId());
            mqSyncCommdPriceBo.setOnShelveTime(uccSkuPoList.get(0).getOnShelveTime());
            mqSyncCommdPriceBo.setSkuId(uccSkuPoList.get(0).getSkuId());
            mqSyncCommdPriceBo.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            mqSyncCommdPriceBo.setOldAgreementPrice(uccSkuPricePo.getAgreementPrice());
            mqSyncCommdPriceBo.setCommodityId(uccSkuPoList.get(0).getCommodityId());
            mqSyncCommdPriceBo.setSkuName(uccSkuPoList.get(0).getSkuName());
            mqSyncCommdPriceBo.setBrandId(uccSkuPoList.get(0).getBrandId());
            uccMallMqSyncCommdPriceBoList.add(mqSyncCommdPriceBo);
            UccMallInsertPriceChangeLogReqBo uccMallInsertPriceChangeLogReqBo = new UccMallInsertPriceChangeLogReqBo();
            uccMallInsertPriceChangeLogReqBo.setSkuId(uccSkuPoList.get(0).getSkuId());
            uccMallInsertPriceChangeLogReqBo.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            uccMallInsertPriceChangeLogReqBo.setCommodityId(uccSkuPoList.get(0).getCommodityId());
            uccMallInsertPriceChangeLogReqBo.setChangeTime(new Date());
            uccMallInsertPriceChangeLogReqBo.setOldPrice(new BigDecimal(uccSkuPricePo.getAgreementPrice().toString()));
            uccMallInsertPriceChangeLogReqBo.setCurrentPrice(MoneyUtils.yuanToHao(uccMallSkuPriceChangeBO.getPrice()));
            BigDecimal range = uccMallInsertPriceChangeLogReqBo.getCurrentPrice().subtract(uccMallInsertPriceChangeLogReqBo.getOldPrice()).divide(uccMallInsertPriceChangeLogReqBo.getOldPrice(), 2, 4);
            uccMallInsertPriceChangeLogReqBo.setChangeRange(range);
            uccMallInsertPriceChangeLogReqBos.add(uccMallInsertPriceChangeLogReqBo);
        }
        if (!CollectionUtils.isEmpty(uccMallMqSyncCommdPriceBoList)) {
            try {
                this.uccMallchangePriceServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("PRICE_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("PRICE_UCC_SYNC_TAG"), JSON.toJSONString(uccMallMqSyncCommdPriceBoList)));
            }
            catch (Exception e) {
                LOGGER.error("\u4ef7\u683c\u53d8\u52a8\u540c\u6b65\u6570\u636e\u5e93 mq \u751f\u4ea7\u8005\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString(uccMallMqSyncCommdPriceBoList));
            }
        }
        try {
            if (!CollectionUtils.isEmpty(uccMallInsertPriceChangeLogReqBos)) {
                this.dealPriceChangeLog(uccMallInsertPriceChangeLogReqBos);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u4ef7\u683c\u53d8\u52a8\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        UccMallPriChangeRspBO rspBO = new UccMallPriChangeRspBO();
        rspBO.setUccMallSkuPriceVOList(uccMallSkuPriceVOList);
        rspBO.setRespDesc("\u8c03\u4ef7\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void dealPriceChangeLog(List<UccMallInsertPriceChangeLogReqBo> bos) {
        if (!CollectionUtils.isEmpty(bos)) {
            UccMallInsertPriceChangeLogBusiReqBo uccMallInsertPriceChangeLogBusiReqBo = new UccMallInsertPriceChangeLogBusiReqBo();
            uccMallInsertPriceChangeLogBusiReqBo.setUccMallInsertPriceChangeLogReqBos(bos);
            LOGGER.info("\u6dfb\u52a0\u4ef7\u683c\u53d8\u52a8\u8bb0\u5f55\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uccMallInsertPriceChangeLogBusiReqBo));
            this.uccMallInsertPriceChangeLogBusiService.dealUccInsertPriceChangeLog(uccMallInsertPriceChangeLogBusiReqBo);
        }
    }
}

