/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMallQrySkuInfoAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuInfoReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuInfoRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuBo;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQrySkuInfoAbilityService"})
public class UccMallQrySkuInfoAbilityServiceImpl
implements UccMallQrySkuInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallQrySkuInfoAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @PostMapping(value={"querySkuInfoByCode"})
    public UccMallQrySkuInfoRspBO querySkuInfoByCode(@RequestBody UccMallQrySkuInfoReqBO reqBO) {
        UccMallQrySkuInfoRspBO rspBO = new UccMallQrySkuInfoRspBO();
        this.validateParam(reqBO);
        List<Object> uccSkuPos = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuCodes())) {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuCode(reqBO.getSkuCode());
            uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo);
        } else {
            uccSkuPos = this.uccMallSkuMapper.batchQryBySkuCodes(reqBO.getSkuCodes());
        }
        List uccMallSkuBos = JSON.parseArray((String)JSON.toJSONString(uccSkuPos), UccMallSkuBo.class);
        rspBO.setUccMallSkuBos(uccMallSkuBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParam(UccMallQrySkuInfoReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSkuCode()) && CollectionUtils.isEmpty((Collection)reqBO.getSkuCodes())) {
            throw new ZTBusinessException("\u5355\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

