/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.bo.UccMallSkuOrderQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryBO;
import com.tydic.commodity.mall.atom.api.UccMallOrderQrySpuDetailListAtomService;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccCommodityServiceReturnMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccCommodityServiceReturnPO;
import com.tydic.commodity.mall.po.UccMallSpuOrderListQueryPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallOrderQrySpuDetailListAtomServiceImpl
implements UccMallOrderQrySpuDetailListAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccMallOrderQrySpuDetailListAtomServiceImpl.class);
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccCommodityServiceReturnMapper uccCommodityServiceReturnMapper;

    @Override
    public UccMallSpuOrderListQueryAbilityRspBO qrySpuList(UccMallSpuOrderListQueryAbilityReqBO reqBO) {
        UccMallSpuOrderListQueryAbilityRspBO rspBO = new UccMallSpuOrderListQueryAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuOrderList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u67e5\u8be2\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        HashSet<Long> spuSet = new HashSet<Long>();
        for (UccMallSkuOrderQryReqBO each : reqBO.getSkuOrderList()) {
            spuSet.add(each.getCommodityId());
        }
        if (spuSet.isEmpty()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u67e5\u8be2\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        List<UccMallSpuOrderListQueryPO> orderListQueryPOS = this.uccMallCommodityMapper.qrySpuInfoList(new ArrayList<Long>(spuSet));
        if (CollectionUtils.isEmpty(orderListQueryPOS) || orderListQueryPOS.size() != spuSet.size()) {
            throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_EXIST.code(), UccMallConstantsEnums.SKU_NOT_ON_EXIST.message());
        }
        List orderSpuList = new ArrayList();
        orderSpuList = JSONObject.parseArray((String)JSONObject.toJSONString(orderListQueryPOS), UccMallSpuOrderListQueryBO.class);
        orderSpuList.forEach(e -> {
            UccCommodityServiceReturnPO serviceReturnPO = new UccCommodityServiceReturnPO();
            serviceReturnPO.setCommodityId(e.getCommodityId());
            serviceReturnPO.setSupplierShopId(e.getSupplierShopId());
            List<UccCommodityServiceReturnPO> serviceReturnPOS = this.uccCommodityServiceReturnMapper.selectByCondition(serviceReturnPO);
            if (!CollectionUtils.isEmpty(serviceReturnPOS)) {
                List serverTypeList = serviceReturnPOS.stream().map(UccCommodityServiceReturnPO::getReturnType).collect(Collectors.toList());
                e.setServerReturnTypeList(serverTypeList);
            }
        });
        rspBO.setOrderSpuList(orderSpuList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

