/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallESearchToCatalogAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallESearchToCatalogAbilityRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallCatalogToEsBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.mall.po.UccCatalogDealPO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallESearchToCatalogAbilityService"})
public class UccMallESearchToCatalogAbilityServiceImpl
implements UccMallESearchToCatalogAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallESearchToCatalogAbilityServiceImpl.class);
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;

    @PostMapping(value={"autoCatalogToEs"})
    public UccMallESearchToCatalogAbilityRspBO autoCatalogToEs() {
        UccMallESearchToCatalogAbilityRspBO rspBO = new UccMallESearchToCatalogAbilityRspBO();
        List<UccCatalogDealPO> uccCatalogDealPOS = this.uccMallCatalogDealMapper.queryAllyCatalog();
        if (CollectionUtils.isEmpty(uccCatalogDealPOS)) {
            rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBO.setRespDesc("\u7c7b\u76ee\u67e5\u8be2\u5931\u8d25");
            return rspBO;
        }
        ArrayList uccMallCatalogToEsBOList = new ArrayList();
        uccCatalogDealPOS.stream().sorted(Comparator.comparing(UccCatalogDealPO::getGuideCatalogId).reversed()).collect(Collectors.toList()).forEach(uccCatalogDeal -> {
            UccMallCatalogToEsBO uccMallCatalogToEsBO = new UccMallCatalogToEsBO();
            uccMallCatalogToEsBO.setCatalog_level(uccCatalogDeal.getCatalogLevel());
            uccMallCatalogToEsBO.setCatalog_name(uccCatalogDeal.getCatalogName());
            uccMallCatalogToEsBO.setCatalog_status(uccCatalogDeal.getCatalogStatus());
            uccMallCatalogToEsBO.setChannelId(uccCatalogDeal.getChannelId());
            uccMallCatalogToEsBO.setUpper_catalog_id(uccCatalogDeal.getUpperCatalogId());
            uccMallCatalogToEsBO.setShopCatalogType(uccCatalogDeal.getShopCatalogType());
            uccMallCatalogToEsBO.setGuide_catalog_id(uccCatalogDeal.getGuideCatalogId());
            uccMallCatalogToEsBOList.add(uccMallCatalogToEsBO);
        });
        ArrayList<Map<String, JSONObject>> list = new ArrayList<Map<String, JSONObject>>();
        uccMallCatalogToEsBOList.forEach(uccMallCatalogToEsBO -> {
            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>(16);
            map.put(String.valueOf(uccMallCatalogToEsBO.getGuide_catalog_id()), (JSONObject)JSONObject.toJSON((Object)uccMallCatalogToEsBO));
            list.add(map);
        });
        this.mallElasticsearchUtil.addBatch(this.mallEsConfig.getCatalogIndexName(), this.mallEsConfig.getCatalogSuggestIndexType(), list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

