/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccOtherStdSpuListQryAbilityService;
import com.tydic.commodity.mall.ability.bo.OnSaleSkuBO;
import com.tydic.commodity.mall.ability.bo.SkuInfoImageBo;
import com.tydic.commodity.mall.ability.bo.UccCombEsCommodityBo;
import com.tydic.commodity.mall.ability.bo.UccOtherStdSpuListQryBO;
import com.tydic.commodity.mall.ability.bo.UccSkuSpecPropsBo;
import com.tydic.commodity.mall.ability.bo.UccSpuDetailSkuListQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccSpuDetailSkuListQryAbilityRspBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.dao.UccMallCommodityLabelMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPicMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSkuStandardRelationMapper;
import com.tydic.commodity.mall.dao.UccMallSkuStockMapper;
import com.tydic.commodity.mall.dao.UccSkuSpecMapper;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.po.UccSkuStockPo;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccOtherStdSpuListQryAbilityService"})
public class UccOtherStdSpuListQryAbilityServiceImpl
implements UccOtherStdSpuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccOtherStdSpuListQryAbilityServiceImpl.class);
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private UccMallSkuStandardRelationMapper uccMallSkuStandardRelationMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccMallSkuPicMapper uccMallSkuPicMapper;
    @Autowired
    private UccMallCommodityLabelMapper uccMallCommodityLabelMapper;
    @Autowired
    private UccMallSkuStockMapper uccMallSkuStockMapper;
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;

    @PostMapping(value={"getOtherStdSpuList"})
    public UccSpuDetailSkuListQryAbilityRspBO getOtherStdSpuList(@RequestBody UccSpuDetailSkuListQryAbilityReqBO reqBO) {
        UccSpuDetailSkuListQryAbilityRspBO rspBO = new UccSpuDetailSkuListQryAbilityRspBO();
        if (reqBO == null || StringUtils.isEmpty((Object)reqBO.getStdSkuId())) {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List<Long> thisStdRelSkuIds = this.uccMallSkuStandardRelationMapper.querySkuIdListByStdSkuId(reqBO.getStdSkuId());
        if (null == thisStdRelSkuIds || thisStdRelSkuIds.size() == 0) {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u51fa\u5173\u8054\u5355\u54c1ID");
            return rspBO;
        }
        List<Long> commodityIds = this.uccMallSkuMapper.queryCommodityIdsBySkuIds(thisStdRelSkuIds);
        if (CollectionUtils.isEmpty(commodityIds = commodityIds.stream().distinct().collect(Collectors.toList())) || commodityIds.size() == 0) {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u51fa\u5173\u8054\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        List<Long> skuIds = this.uccMallSkuMapper.querySkuIdsByCommodityId(commodityIds);
        if (skuIds == null || skuIds.size() == 0) {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u672a\u67e5\u51fa\u5355\u54c1\u4fe1\u606f");
            return rspBO;
        }
        ArrayList<Long> stdSkuIds = new ArrayList<Long>();
        for (Long skuId : skuIds) {
            Long stdskuId = this.uccMallSkuStandardRelationMapper.queryStdSkuIdBySkuId(skuId);
            if (StringUtils.isEmpty((Object)stdskuId)) continue;
            stdSkuIds.add(stdskuId);
        }
        ArrayList<Long> otherStdSkuIds = new ArrayList<Long>();
        for (Long otherStdSkuId : stdSkuIds) {
            if (reqBO.getStdSkuId().equals(otherStdSkuId)) continue;
            otherStdSkuIds.add(otherStdSkuId);
        }
        if (CollectionUtils.isEmpty(otherStdSkuIds) || otherStdSkuIds.size() == 0) {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u51fa\u5176\u4ed6\u6807\u54c1ID");
            return rspBO;
        }
        otherStdSkuIds = otherStdSkuIds.stream().distinct().collect(Collectors.toList());
        return this.getUccSpuDetailSkuListQryAbilityRspBO(reqBO, rspBO, otherStdSkuIds);
    }

    private UccSpuDetailSkuListQryAbilityRspBO getUccSpuDetailSkuListQryAbilityRspBO(UccSpuDetailSkuListQryAbilityReqBO reqBO, UccSpuDetailSkuListQryAbilityRspBO rspBO, List<Long> otherStdSkuIds) {
        List<UccCombEsCommodityBo> commodityModels = this.queryEsVommodity(reqBO, otherStdSkuIds);
        ArrayList<UccOtherStdSpuListQryBO> otherSkuList = new ArrayList<UccOtherStdSpuListQryBO>();
        if (!CollectionUtils.isEmpty(commodityModels)) {
            for (UccCombEsCommodityBo uccCombEsCommodityBo : commodityModels) {
                UccOtherStdSpuListQryBO uccOtherStdSpuListQryBO = this.copyData(uccCombEsCommodityBo);
                this.editSaleUnitRate(uccOtherStdSpuListQryBO);
                if (uccOtherStdSpuListQryBO.getSkuStatus() == 22) {
                    this.editPrice(uccOtherStdSpuListQryBO);
                    this.editUnsaleNum(uccOtherStdSpuListQryBO);
                    this.editSpec(uccOtherStdSpuListQryBO);
                    this.editImags(uccOtherStdSpuListQryBO);
                    this.editCurrencyType(uccOtherStdSpuListQryBO);
                    otherSkuList.add(uccOtherStdSpuListQryBO);
                    continue;
                }
                log.error("\u6807\u54c1id\u4e3a" + uccOtherStdSpuListQryBO.getStdSkuId() + "\u672a\u53d1\u5e03");
            }
        }
        if (CollectionUtils.isEmpty(otherSkuList) || otherSkuList.size() == 0) {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u6ca1\u6709\u5bf9\u5e94\u7684\u6807\u51c6\u5355\u54c1\u4fe1\u606f");
            return rspBO;
        }
        rspBO.setRows(otherSkuList);
        int recordsTotal = otherSkuList.size();
        int size = reqBO.getPageSize();
        int total = recordsTotal / size;
        int add = 0;
        add = recordsTotal % size == 0 ? 0 : 1;
        rspBO.setTotal(total + add);
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccOtherStdSpuListQryBO copyData(UccCombEsCommodityBo uccCombEsCommodityBo) {
        UccOtherStdSpuListQryBO uccOtherStdSpuListQryBO = new UccOtherStdSpuListQryBO();
        uccOtherStdSpuListQryBO.setStdSkuId(Long.valueOf(uccCombEsCommodityBo.getSku_id()));
        uccOtherStdSpuListQryBO.setSkuId(Long.valueOf(uccCombEsCommodityBo.getSku_id()));
        uccOtherStdSpuListQryBO.setSupplierShopId(uccCombEsCommodityBo.getSupplier_id());
        uccOtherStdSpuListQryBO.setStdSkuCode(uccCombEsCommodityBo.getSku_code());
        uccOtherStdSpuListQryBO.setSkuName(uccCombEsCommodityBo.getSku_name());
        uccOtherStdSpuListQryBO.setBrandId(Long.valueOf(uccCombEsCommodityBo.getBrand_id()));
        uccOtherStdSpuListQryBO.setBrandName(uccCombEsCommodityBo.getBrand_name());
        uccOtherStdSpuListQryBO.setSalesUnitId(uccCombEsCommodityBo.getSales_unit_id());
        uccOtherStdSpuListQryBO.setSalesUnitName(uccCombEsCommodityBo.getSales_unit_name());
        uccOtherStdSpuListQryBO.setVendorId(uccCombEsCommodityBo.getVendor_id());
        uccOtherStdSpuListQryBO.setVendorName(uccCombEsCommodityBo.getVendor_name());
        uccOtherStdSpuListQryBO.setSpec(uccCombEsCommodityBo.getSpec());
        uccOtherStdSpuListQryBO.setModel(uccCombEsCommodityBo.getModel());
        uccOtherStdSpuListQryBO.setSettlementUnit(uccCombEsCommodityBo.getSettlement_unit());
        uccOtherStdSpuListQryBO.setMaterialId(uccCombEsCommodityBo.getMaterial_id());
        uccOtherStdSpuListQryBO.setExtSkuId(uccCombEsCommodityBo.getExt_sku_id());
        uccOtherStdSpuListQryBO.setMoq(uccCombEsCommodityBo.getMoq());
        uccOtherStdSpuListQryBO.setSkuSource(Integer.valueOf(uccCombEsCommodityBo.getSku_source()));
        uccOtherStdSpuListQryBO.setSalePrice(Long.valueOf(uccCombEsCommodityBo.getSale_price()));
        uccOtherStdSpuListQryBO.setPurchasePrice(Long.valueOf(uccCombEsCommodityBo.getAgreement_price()));
        uccOtherStdSpuListQryBO.setSkuStatus(Integer.valueOf(uccCombEsCommodityBo.getSku_status()));
        if (!CollectionUtils.isEmpty((Collection)uccCombEsCommodityBo.getShowLabelNames())) {
            uccOtherStdSpuListQryBO.setCommodityPoolLabelName(uccCombEsCommodityBo.getShowLabelNames());
        }
        return uccOtherStdSpuListQryBO;
    }

    private List<UccCombEsCommodityBo> queryEsVommodity(UccSpuDetailSkuListQryAbilityReqBO reqBO, List<Long> otherStdSkuIds) {
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        for (Long stdSkuId : otherStdSkuIds) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)stdSkuId));
            JSONObject queryJson = new JSONObject();
            String queryString = boolQueryBuilder.toString();
            queryJson.put("query", (Object)JSON.parseObject((String)queryString));
            String result = this.searchInfo(queryJson.toString());
            JSONObject resultObj = JSONObject.parseObject((String)result);
            JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
            JSONArray listObject = hitsObj.getJSONArray("hits");
            if (listObject.size() <= 0) continue;
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        return commodityModels;
    }

    private void editSaleUnitRate(UccOtherStdSpuListQryBO otherStdSku) {
        UccOtherStdSpuListQryBO uccOtherStdSpuListQryBO = this.uccMallSkuMapper.queryOtherStdSkuListByStdSkuIdTotal(otherStdSku.getStdSkuId());
        if (!StringUtils.isEmpty((Object)uccOtherStdSpuListQryBO)) {
            otherStdSku.setSalesUnitRate(uccOtherStdSpuListQryBO.getSalesUnitRate());
            otherStdSku.setCommodityTypeId(uccOtherStdSpuListQryBO.getCommodityTypeId());
            otherStdSku.setSalesUnitRate(uccOtherStdSpuListQryBO.getSalesUnitRate());
            otherStdSku.setSkuType(uccOtherStdSpuListQryBO.getSkuType());
            otherStdSku.setCommodityId(uccOtherStdSpuListQryBO.getCommodityId());
        } else {
            log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1id\u4e3a" + otherStdSku.getStdSkuId() + "\u7684\u76f8\u5173\u4fe1\u606f");
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(otherStdSku.getCommodityTypeId());
        if (uccCommodityTypePo != null) {
            otherStdSku.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
        } else {
            log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1ID\u4e3a" + otherStdSku.getStdSkuId() + "\u5546\u54c1\u76f8\u5173\u4fe1\u606f");
        }
    }

    private void editImags(UccOtherStdSpuListQryBO otherStdSku) {
        SkuInfoImageBo skuInfoImageBo = this.uccMallSkuPicMapper.queryPicBySkuId(otherStdSku.getStdSkuId());
        if (StringUtils.isEmpty((Object)skuInfoImageBo)) {
            log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1ID\u4e3a" + otherStdSku.getStdSkuId() + "\u56fe\u7247\u76f8\u5173\u4fe1\u606f");
        }
        otherStdSku.setSkuImags(skuInfoImageBo);
    }

    private void editSpec(UccOtherStdSpuListQryBO otherStdSku) {
        List<UccSkuSpecPropsBo> uccSkuSpecPropsBoList = this.uccSkuSpecMapper.querySpecBySkuId(otherStdSku.getStdSkuId());
        if (uccSkuSpecPropsBoList == null || uccSkuSpecPropsBoList.size() == 0) {
            log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1ID\u4e3a" + otherStdSku.getStdSkuId() + "\u5c5e\u6027\u76f8\u5173\u4fe1\u606f");
        }
        otherStdSku.setSkuSpec(uccSkuSpecPropsBoList);
    }

    private void editCurrencyType(UccOtherStdSpuListQryBO otherStdSku) {
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(otherStdSku.getStdSkuId());
        UccSkuPricePo uccSkuPricePoNow = this.uccMallSkuPriceMapper.querySkuPrice(uccSkuPricePo);
        if (!StringUtils.isEmpty((Object)uccSkuPricePoNow)) {
            otherStdSku.setCurrencyType(uccSkuPricePoNow.getCurrencyType());
        } else {
            log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1ID\u4e3a" + otherStdSku.getStdSkuId() + "\u4ef7\u683c\u76f8\u5173\u4fe1\u606f");
        }
    }

    private void editPrice(UccOtherStdSpuListQryBO otherStdSku) {
        List<Long> skuIds = this.uccMallSkuStandardRelationMapper.querySkuIdListByStdSkuId(otherStdSku.getStdSkuId());
        ArrayList<BigDecimal> marketPrice = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> salePrice = new ArrayList<BigDecimal>();
        if (!CollectionUtils.isEmpty(skuIds)) {
            for (Long skuId : skuIds) {
                List<UccSkuPricePo> uccSkuPricePos = this.uccMallSkuPriceMapper.getPricesBySkuId(skuId);
                if (!CollectionUtils.isEmpty(uccSkuPricePos)) {
                    for (UccSkuPricePo uccSkuPricePo : uccSkuPricePos) {
                        if (!ObjectUtil.isNotEmpty((Object)uccSkuPricePo.getMarketPrice())) continue;
                        marketPrice.add(BigDecimal.valueOf(uccSkuPricePo.getMarketPrice()));
                        salePrice.add(BigDecimal.valueOf(uccSkuPricePo.getSalePrice()));
                    }
                    continue;
                }
                log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1ID\u4e3a" + otherStdSku.getStdSkuId() + "\u4ef7\u683c\u76f8\u5173\u4fe1\u606f");
            }
        } else {
            log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1ID\u4e3a" + otherStdSku.getStdSkuId() + "\u5173\u8054\u5355\u54c1\u76f8\u5173\u4fe1\u606f\u4fe1\u606f");
        }
        if (!CollectionUtils.isEmpty(marketPrice)) {
            BigDecimal minMarketPrice = (BigDecimal)marketPrice.get(0);
            BigDecimal maxMarketPrice = (BigDecimal)marketPrice.get(0);
            for (int i = 0; i < marketPrice.size(); ++i) {
                if (minMarketPrice.compareTo((BigDecimal)marketPrice.get(i)) == 1) {
                    minMarketPrice = (BigDecimal)marketPrice.get(i);
                }
                if (maxMarketPrice.compareTo((BigDecimal)marketPrice.get(i)) != -1) continue;
                maxMarketPrice = (BigDecimal)marketPrice.get(i);
            }
            otherStdSku.setMinMarketPrice(minMarketPrice);
            otherStdSku.setMaxMarketPrice(maxMarketPrice);
        }
        if (!CollectionUtils.isEmpty(salePrice)) {
            BigDecimal minSalePrice = (BigDecimal)salePrice.get(0);
            BigDecimal maxSalePrice = (BigDecimal)salePrice.get(0);
            for (int i = 0; i < marketPrice.size(); ++i) {
                if (minSalePrice.compareTo((BigDecimal)salePrice.get(i)) == 1) {
                    minSalePrice = (BigDecimal)salePrice.get(i);
                }
                if (maxSalePrice.compareTo((BigDecimal)salePrice.get(i)) != -1) continue;
                maxSalePrice = (BigDecimal)salePrice.get(i);
            }
            otherStdSku.setMinSalePrice(minSalePrice);
            otherStdSku.setMaxSalePrice(maxSalePrice);
        }
    }

    private void editUnsaleNum(UccOtherStdSpuListQryBO otherStdSku) {
        List<Long> skuIds = this.uccMallSkuStandardRelationMapper.querySkuIdListByStdSkuId(otherStdSku.getStdSkuId());
        if (!CollectionUtils.isEmpty(skuIds)) {
            long allUnsaleNum = 1L;
            ArrayList<OnSaleSkuBO> onSaleSkus = new ArrayList<OnSaleSkuBO>();
            for (Long skuId : skuIds) {
                OnSaleSkuBO onSaleSku = this.getOnSaleSku(skuId);
                onSaleSkus.add(onSaleSku);
                UccSkuStockPo uccSkuStockPoNow = this.uccMallSkuStockMapper.querySkuValidStock(skuId);
                if (uccSkuStockPoNow != null) {
                    allUnsaleNum += uccSkuStockPoNow.getStockNum().longValue();
                } else {
                    log.error("\u672a\u67e5\u8be2\u5230\u5355\u54c1ID\u4e3a" + skuId + "\u7684\u6709\u6548\u5e93\u5b58\u76f8\u5173\u4fe1\u606f");
                }
                if (allUnsaleNum - 1L != 0L) continue;
                otherStdSku.setSaleStatusStr("\u65e0\u8d27");
            }
            otherStdSku.setUnsaleNum(Long.valueOf(allUnsaleNum - 1L));
            otherStdSku.setOnSales(onSaleSkus);
        } else {
            log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1ID\u4e3a" + otherStdSku.getStdSkuId() + "\u7684\u5173\u8054\u5355\u54c1");
        }
        UccSkuStockPo uccSkuStockPo1 = new UccSkuStockPo();
        uccSkuStockPo1.setSkuId(otherStdSku.getStdSkuId());
        UccSkuStockPo uccSkuStockPo = this.uccMallSkuStockMapper.querySkuStock(uccSkuStockPo1);
        if (!StringUtils.isEmpty((Object)uccSkuStockPo)) {
            if (uccSkuStockPo.getStockStatus() == 1) {
                otherStdSku.setSaleStatusStr("\u4e0d\u53ef\u552e");
            }
        } else {
            log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1\u54c1ID\u4e3a" + otherStdSku.getStdSkuId() + "\u7684\u6709\u6548\u5e93\u5b58\u76f8\u5173\u4fe1\u606f");
        }
    }

    private OnSaleSkuBO getOnSaleSku(Long skuId) {
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)skuId));
        JSONObject queryJson = new JSONObject();
        String queryString = boolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String result = this.searchInfo(queryJson.toString());
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                }
            }
        }
        UccCombEsCommodityBo uccCombEsCommodityBo = (UccCombEsCommodityBo)commodityModels.get(0);
        OnSaleSkuBO onSaleSku = new OnSaleSkuBO();
        onSaleSku.setSalePrice(Long.valueOf(uccCombEsCommodityBo.getSale_price()));
        onSaleSku.setVendorName(uccCombEsCommodityBo.getVendor_name());
        onSaleSku.setVendorId(uccCombEsCommodityBo.getVendor_id());
        onSaleSku.setSkuId(Long.valueOf(uccCombEsCommodityBo.getSku_id()));
        onSaleSku.setSupplierShopId(uccCombEsCommodityBo.getSupplier_shop_id());
        onSaleSku.setSupplierId(uccCombEsCommodityBo.getSupplier_id());
        onSaleSku.setMoq(uccCombEsCommodityBo.getMoq());
        onSaleSku.setSkuSource(Integer.valueOf(uccCombEsCommodityBo.getSku_source()));
        onSaleSku.setExtSkuId(uccCombEsCommodityBo.getExt_sku_id());
        onSaleSku.setChannellIds(uccCombEsCommodityBo.getChannel_id());
        return onSaleSku;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.mallEsConfig.getIndexName() + "/" + this.mallEsConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }
}

