/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceJDAddressFromAddressQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceJDAddressFromAddressQryBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJDAddressFromAddressQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJDAddressFromAddressQryRspBO;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InterfaceJDAddressFromAddressQryServiceImpl
implements InterfaceJDAddressFromAddressQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceJDAddressFromAddressQryServiceImpl.class);

    @Override
    public InterfaceJDAddressFromAddressQryRspBO getJDAddressFromAddress(InterfaceJDAddressFromAddressQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = "jd";
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_JD_ADDRESS_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_JD_ADDRESS_URL") + "]");
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            InterfaceJDAddressFromAddressQryRspBO resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(InterfaceJDAddressFromAddressQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("address", (Object)(reqBO.getProvinceName() + reqBO.getCityName() + reqBO.getTownName() + reqBO.getTownName()));
        jsonObject.put("hsn", (Object)"jd");
        return jsonObject.toString();
    }

    private InterfaceJDAddressFromAddressQryRspBO resolveRsp(String returnString) {
        InterfaceJDAddressFromAddressQryRspBO rspBO = new InterfaceJDAddressFromAddressQryRspBO();
        ArrayList list = new ArrayList();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setResultMessage("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u4eac\u4e1c\u5730\u5740\u7f16\u7801\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef");
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            JSONObject object = rspJsonObject.getJSONObject("result");
            log.info("\u5730\u533a\uff1a" + object);
            if (null != object) {
                InterfaceJDAddressFromAddressQryBO result = (InterfaceJDAddressFromAddressQryBO)JSON.parseObject((String)JSON.toJSONString((Object)object), InterfaceJDAddressFromAddressQryBO.class);
                rspBO.setResult(result);
            }
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

