/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.mall.ability.bo.UccMallSkuPriceBo;
import com.tydic.commodity.mall.busi.api.UccMallBatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.mall.busi.api.UccMallMqSyncCommdPriceBusiService;
import com.tydic.commodity.mall.busi.api.UccMallQueryDBDateBusiService;
import com.tydic.commodity.mall.busi.api.UccMallSkuAdjustPriceBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallBatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.mall.busi.bo.UccMallMqSyncCommdPriceBo;
import com.tydic.commodity.mall.busi.bo.UccMallMqSyncCommdPriceReqBo;
import com.tydic.commodity.mall.busi.bo.UccMallMqSyncCommdPriceRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSkuAdjustPriceReqBO;
import com.tydic.commodity.mall.constants.CommodityStatusEnum;
import com.tydic.commodity.mall.constants.SkuStatusEnum;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallECommercePriceChangeLogMapper;
import com.tydic.commodity.mall.dao.UccMallECommercePriceChangeMapper;
import com.tydic.commodity.mall.dao.UccMallIntervalPricePercentageMapper;
import com.tydic.commodity.mall.dao.UccMallPricePreventMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceLogMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.mall.po.ECommercePriceChangePO;
import com.tydic.commodity.mall.po.UccIntervalPricePercentagePO;
import com.tydic.commodity.mall.po.UccPriceBetweenPo;
import com.tydic.commodity.mall.po.UccPricePreventPO;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.utils.DateUtils;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallMqSyncCommdPriceBusiServiceImpl
implements UccMallMqSyncCommdPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallMqSyncCommdPriceBusiServiceImpl.class);
    private static final int weekNum = 12;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallECommercePriceChangeMapper uccMallECommercePriceChangeMapper;
    @Autowired
    private UccMallECommercePriceChangeLogMapper uccMallECommercePriceChangeLogMapper;
    @Autowired
    private UccMallSkuAdjustPriceBusiService uccMallSkuAdjustPriceBusiService;
    @Autowired
    private UccMallQueryDBDateBusiService uccMallQueryDBDateBusiService;
    @Autowired
    private UccMallIntervalPricePercentageMapper uccMallIntervalPricePercentageMapper;
    @Autowired
    private UccMallPricePreventMapper uccMallPricePreventMapper;
    @Autowired
    private UccMallBatchUpdateCommoStatusForMarketService statusForMarketService;
    @Autowired
    private UccMallSkuPriceLogMapper uccMallSkuPriceLogMapper;
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    private Sequence coefficientSequence = Sequence.getInstance();

    @Override
    public UccMallMqSyncCommdPriceRspBo dealSync(UccMallMqSyncCommdPriceReqBo uccMallMqSyncCommdPriceReqBo) {
        UccMallMqSyncCommdPriceRspBo rspBo = new UccMallMqSyncCommdPriceRspBo();
        ArrayList<ECommercePriceChangePO> eCommercePriceChangePOList = new ArrayList<ECommercePriceChangePO>();
        ArrayList<ECommercePriceChangeLogPO> eCommercePriceChangeLogPOS = new ArrayList<ECommercePriceChangeLogPO>();
        if (CollectionUtils.isEmpty(uccMallMqSyncCommdPriceReqBo.getUccMallMqSyncCommdPriceBoList())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        this.dealUpFloat(uccMallMqSyncCommdPriceReqBo.getUccMallMqSyncCommdPriceBoList());
        for (UccMallMqSyncCommdPriceBo each : uccMallMqSyncCommdPriceReqBo.getUccMallMqSyncCommdPriceBoList()) {
            UccMallSkuAdjustPriceReqBO uccMallSkuAdjustPriceReqBO = new UccMallSkuAdjustPriceReqBO();
            uccMallSkuAdjustPriceReqBO.setSkuId(each.getSkuId());
            uccMallSkuAdjustPriceReqBO.setSupplierShopId(each.getSupplierShopId());
            UccMallSkuPriceBo uccMallSkuPriceBo = new UccMallSkuPriceBo();
            uccMallSkuAdjustPriceReqBO.setUpdateSkuPriceInfo(uccMallSkuPriceBo);
            uccMallSkuPriceBo.setSalePrice(each.getSalePrice());
            uccMallSkuPriceBo.setAgreementPrice(each.getAgreementPrice());
            uccMallSkuPriceBo.setMarketPrice(each.getMarketPrice());
            try {
                this.uccMallSkuAdjustPriceBusiService.dealSkuAdjustPrice(uccMallSkuAdjustPriceReqBO);
            }
            catch (Exception e) {
                throw new BusinessException(UccMallConstantsEnums.ABNORMAL_PRICE_ADJUSTMENT.code(), UccMallConstantsEnums.ABNORMAL_PRICE_ADJUSTMENT.message());
            }
            ECommercePriceChangePO eCommercePriceChangePO = new ECommercePriceChangePO();
            eCommercePriceChangePO.setSkuId(each.getSkuId());
            eCommercePriceChangePO.setSupplierShopId(each.getSupplierShopId());
            List<ECommercePriceChangePO> eCommercePriceChangePOS = this.uccMallECommercePriceChangeMapper.qryECommercePriceChange(eCommercePriceChangePO);
            Date nowDate = this.uccMallQueryDBDateBusiService.getDBDate();
            Calendar time = Calendar.getInstance();
            time.setTime(each.getOnShelveTime());
            time.add(1, 1);
            Date onShelveTime = time.getTime();
            Date updateTime = null;
            if (nowDate.compareTo(onShelveTime) > 0) {
                time.setTime(nowDate);
                time.set(2, 4);
                time.set(5, 31);
                Date compareTime = time.getTime();
                time = Calendar.getInstance();
                time.setTime(nowDate);
                time.add(1, -1);
                if (nowDate.compareTo(compareTime) > 0) {
                    time.set(2, 5);
                    time.set(5, 1);
                } else {
                    time.set(2, 0);
                    time.set(5, 1);
                }
                updateTime = time.getTime();
            }
            ECommercePriceChangeLogPO eCommercePriceChangeLogHistory = new ECommercePriceChangeLogPO();
            eCommercePriceChangeLogHistory.setSkuId(each.getSkuId());
            eCommercePriceChangeLogHistory.setSupplierShopId(each.getSupplierShopId());
            eCommercePriceChangeLogHistory.setUpdateTime(updateTime);
            eCommercePriceChangeLogHistory = this.uccMallECommercePriceChangeLogMapper.queryCount(eCommercePriceChangeLogHistory);
            if (eCommercePriceChangeLogHistory == null) {
                return null;
            }
            eCommercePriceChangePO.setFrequency(eCommercePriceChangeLogHistory.getFrequency());
            eCommercePriceChangePO.setAveragePrice(eCommercePriceChangeLogHistory.getAveragePrice());
            eCommercePriceChangePO.setExtSkuId(each.getExtSkuId());
            eCommercePriceChangePO.setFrequency(eCommercePriceChangeLogHistory.getFrequency());
            eCommercePriceChangePO.setPrice(each.getOrgSalePrice());
            if (eCommercePriceChangePO.getAveragePrice() != null) {
                if (eCommercePriceChangePO.getAveragePrice().compareTo(new BigDecimal(0)) == 0) {
                    if (each.getOrgSalePrice().compareTo(eCommercePriceChangePO.getAveragePrice()) == 0) {
                        eCommercePriceChangePO.setFloatingRate(new BigDecimal(0.01));
                    } else {
                        eCommercePriceChangePO.setFloatingRate(new BigDecimal(0));
                    }
                } else {
                    eCommercePriceChangePO.setFloatingRate(each.getOrgSalePrice().divide(eCommercePriceChangePO.getAveragePrice(), 2, 4));
                }
            }
            try {
                eCommercePriceChangePO.setId(this.coefficientSequence.nextId());
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            if (eCommercePriceChangePOS == null || eCommercePriceChangePOS.size() == 0) {
                eCommercePriceChangePOList.add(eCommercePriceChangePO);
            } else {
                this.uccMallECommercePriceChangeMapper.modifyECommercePriceChange(eCommercePriceChangePO);
            }
            ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
            try {
                eCommercePriceChangeLogPO.setBatchId(this.coefficientSequence.nextId());
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            BeanUtils.copyProperties((Object)eCommercePriceChangePO, (Object)eCommercePriceChangeLogPO);
            eCommercePriceChangeLogPO.setOnShelveTime(each.getOnShelveTime());
            eCommercePriceChangeLogPOS.add(eCommercePriceChangeLogPO);
        }
        if (eCommercePriceChangePOList.size() > 0) {
            this.uccMallECommercePriceChangeMapper.insertPriceChange(eCommercePriceChangePOList);
        }
        if (eCommercePriceChangeLogPOS.size() > 0) {
            this.uccMallECommercePriceChangeLogMapper.insertECommercePriceChangeLogs(eCommercePriceChangeLogPOS);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealUpFloat(List<UccMallMqSyncCommdPriceBo> bos) {
        if (!CollectionUtils.isEmpty(bos)) {
            UccIntervalPricePercentagePO uccIntervalPricePercentagePO = new UccIntervalPricePercentagePO();
            Page page = new Page();
            page.setPageSize(999);
            List<UccIntervalPricePercentagePO> uccIntervalPricePercentagePOS = this.uccMallIntervalPricePercentageMapper.getListPage(uccIntervalPricePercentagePO, (Page<UccIntervalPricePercentagePO>)page);
            if (CollectionUtils.isEmpty(uccIntervalPricePercentagePOS)) {
                return;
            }
            ArrayList<Long> commoditys = new ArrayList<Long>();
            ArrayList<UccPricePreventPO> uccPricePreventPOS = new ArrayList<UccPricePreventPO>();
            Map<Integer, Date> map = this.getWeekInfo(12);
            Date beginWeekDate = map.get(1);
            Date stopWeekDate = map.get(2);
            Map<Long, List<UccMallMqSyncCommdPriceBo>> groupSup = bos.stream().collect(Collectors.groupingBy(UccMallMqSyncCommdPriceBo::getSupplierShopId));
            Map<Long, Map<Integer, BigDecimal>> resultMap = this.getPirceInfo(groupSup, beginWeekDate, stopWeekDate);
            for (UccMallMqSyncCommdPriceBo uccMallMqSyncCommdPriceBo : bos) {
                BigDecimal agreementPrice = MoneyUtils.haoToYuan(uccMallMqSyncCommdPriceBo.getAgreementPrice());
                BigDecimal oldAgreementPrice = MoneyUtils.haoToYuan(uccMallMqSyncCommdPriceBo.getOldAgreementPrice());
                for (UccIntervalPricePercentagePO uccIntervalPricePercentagePO1 : uccIntervalPricePercentagePOS) {
                    BigDecimal downPrencent;
                    BigDecimal upPrencent;
                    if (agreementPrice.compareTo(uccIntervalPricePercentagePO1.getNumStart()) == -1 || agreementPrice.compareTo(uccIntervalPricePercentagePO1.getNumEnd()) == 1) continue;
                    BigDecimal maxPrice = new BigDecimal(-1);
                    BigDecimal minPrice = new BigDecimal(-1);
                    if (resultMap != null && resultMap.size() > 0) {
                        maxPrice = resultMap.get(uccMallMqSyncCommdPriceBo.getSkuId()).get(1);
                        minPrice = resultMap.get(uccMallMqSyncCommdPriceBo.getSkuId()).get(2);
                    }
                    UccPricePreventPO uccPricePreventPO = new UccPricePreventPO();
                    uccPricePreventPO.setBeforePrice(new BigDecimal(uccMallMqSyncCommdPriceBo.getOldAgreementPrice().toString()));
                    uccPricePreventPO.setPrice(new BigDecimal(uccMallMqSyncCommdPriceBo.getAgreementPrice().toString()));
                    uccPricePreventPO.setSupplierShopId(uccMallMqSyncCommdPriceBo.getSupplierShopId());
                    uccPricePreventPO.setUpdateTime(new Date());
                    uccPricePreventPO.setMaxPrice(MoneyUtils.yuanToHao(maxPrice));
                    uccPricePreventPO.setMinPrice(MoneyUtils.yuanToHao(minPrice));
                    boolean judge = false;
                    boolean judge1 = false;
                    if (maxPrice.compareTo(new BigDecimal(-1)) != 0) {
                        if (agreementPrice.compareTo(maxPrice) == 1) {
                            BigDecimal sownShefPrencent;
                            upPrencent = agreementPrice.subtract(maxPrice).divide(maxPrice);
                            if (upPrencent.compareTo(uccIntervalPricePercentagePO1.getUpperPercentage()) == 1) {
                                uccPricePreventPO.setPercentage(upPrencent);
                                uccPricePreventPOS.add(uccPricePreventPO);
                                judge = true;
                            }
                            if ((sownShefPrencent = agreementPrice.subtract(minPrice).divide(minPrice)).compareTo(uccIntervalPricePercentagePO1.getOffShelfPercentage()) == 1) {
                                commoditys.add(uccMallMqSyncCommdPriceBo.getCommodityId());
                                judge1 = true;
                            }
                        } else if (agreementPrice.compareTo(minPrice) == -1 && (downPrencent = minPrice.subtract(agreementPrice).divide(minPrice)).compareTo(uccIntervalPricePercentagePO1.getDownPercentage()) == -1) {
                            uccPricePreventPO.setPercentage(downPrencent);
                            uccPricePreventPOS.add(uccPricePreventPO);
                            judge = true;
                        }
                    }
                    if (agreementPrice.compareTo(oldAgreementPrice) == 1) {
                        upPrencent = agreementPrice.subtract(oldAgreementPrice).divide(oldAgreementPrice);
                        if (upPrencent.compareTo(uccIntervalPricePercentagePO1.getUpperPercentage()) == 1) {
                            uccPricePreventPO.setPercentage(upPrencent);
                            if (!judge) {
                                uccPricePreventPOS.add(uccPricePreventPO);
                            }
                        }
                        if (upPrencent.compareTo(uccIntervalPricePercentagePO1.getOffShelfPercentage()) != 1 || judge1) continue;
                        commoditys.add(uccMallMqSyncCommdPriceBo.getCommodityId());
                        continue;
                    }
                    if (agreementPrice.compareTo(oldAgreementPrice) != -1 || (downPrencent = oldAgreementPrice.subtract(agreementPrice).divide(oldAgreementPrice)).compareTo(uccIntervalPricePercentagePO1.getDownPercentage()) != 1) continue;
                    uccPricePreventPO.setPercentage(downPrencent);
                    if (judge) continue;
                    uccPricePreventPOS.add(uccPricePreventPO);
                }
            }
            try {
                if (!CollectionUtils.isEmpty(commoditys)) {
                    UccMallBatchUpdateCommoStatusForMarketBO uccMallBatchUpdateCommoStatusForMarketBO = new UccMallBatchUpdateCommoStatusForMarketBO();
                    uccMallBatchUpdateCommoStatusForMarketBO.setBusinessId((Long[])commoditys.toArray());
                    this.statusForMarketService.batchUpdateCommoStatusForMarket(uccMallBatchUpdateCommoStatusForMarketBO, CommodityStatusEnum.EFFECTIVE_STATUS, SkuStatusEnum.DOWN_FRAME_STATUS);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u5546\u54c1\u4e0b\u67b6\u5931\u8d25");
            }
            try {
                if (!CollectionUtils.isEmpty(uccPricePreventPOS)) {
                    this.uccMallPricePreventMapper.insertBatch(uccPricePreventPOS);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u6dfb\u52a0\u4e0a\u6d6e\u9884\u8b66\u8bb0\u5f55\u5931\u8d25");
            }
        }
    }

    private Map<Integer, Date> getWeekInfo(int n) {
        HashMap<Integer, Date> timeMap = new HashMap<Integer, Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        int dayOfWeek = calendar1.get(7) - 1;
        int offset1 = 1 - dayOfWeek;
        calendar1.add(5, offset1 - 7 * n);
        calendar2.add(5, offset1);
        String lastBeginDate = sdf.format(calendar1.getTime());
        String nowDate = sdf.format(calendar2.getTime());
        timeMap.put(1, DateUtils.strToDate(lastBeginDate));
        timeMap.put(2, new Date());
        return timeMap;
    }

    private Map<Long, Map<Integer, BigDecimal>> getPirceInfo(Map<Long, List<UccMallMqSyncCommdPriceBo>> map, Date beginTime, Date endTime) {
        HashMap<Long, Map<Integer, BigDecimal>> resultMap = new HashMap<Long, Map<Integer, BigDecimal>>();
        if (null != map) {
            for (Map.Entry<Long, List<UccMallMqSyncCommdPriceBo>> each : map.entrySet()) {
                List<Long> skuIds = each.getValue().stream().map(UccMallMqSyncCommdPriceBo::getSkuId).collect(Collectors.toList());
                List<UccSkuPricePo> uccSkuPricePos = this.uccMallSkuPriceMapper.batchQryPriBySkuIds(skuIds, each.getKey());
                if (CollectionUtils.isEmpty(uccSkuPricePos)) {
                    return null;
                }
                ArrayList<Long> skuIdList = new ArrayList<Long>();
                for (UccSkuPricePo uccSkuPricePo : uccSkuPricePos) {
                    HashMap<Integer, BigDecimal> priceMap;
                    if (uccSkuPricePo.getUpdateTime() == null) {
                        priceMap = new HashMap<Integer, BigDecimal>();
                        priceMap.put(1, MoneyUtils.haoToYuan(uccSkuPricePo.getAgreementPrice()));
                        priceMap.put(2, MoneyUtils.haoToYuan(uccSkuPricePo.getAgreementPrice()));
                        resultMap.put(uccSkuPricePo.getSkuId(), priceMap);
                        continue;
                    }
                    if (uccSkuPricePo.getUpdateTime().before(beginTime)) {
                        priceMap = new HashMap();
                        priceMap.put(1, MoneyUtils.haoToYuan(uccSkuPricePo.getAgreementPrice()));
                        priceMap.put(2, MoneyUtils.haoToYuan(uccSkuPricePo.getAgreementPrice()));
                        resultMap.put(uccSkuPricePo.getSkuId(), priceMap);
                        continue;
                    }
                    if (!uccSkuPricePo.getUpdateTime().after(beginTime) || !uccSkuPricePo.getUpdateTime().before(endTime)) continue;
                    skuIdList.add(uccSkuPricePo.getSkuId());
                }
                if (CollectionUtils.isEmpty(skuIdList)) continue;
                List<UccPriceBetweenPo> uccPriceBetweenPos = this.uccMallSkuPriceLogMapper.getNeedList(skuIdList, each.getKey(), beginTime, endTime);
                if (CollectionUtils.isEmpty(uccPriceBetweenPos)) {
                    log.error("\u5728\u65f6\u95f4\u533a\u95f4\u5185\u4fee\u6539\u8fc7\u4ef7\u683c\uff0c\u65e5\u5fd7\u8868\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u8868\u662f\u5426\u6b63\u5e38\u5199\u5165");
                    log.error("\u672a\u6b63\u5e38\u5199\u5165\u4ef7\u683c\u4e0a\u6d6e\u9884\u8b66\u5546\u54c1\uff1a" + JSONObject.toJSONString(skuIdList));
                    continue;
                }
                for (UccPriceBetweenPo uccPriceBetweenPo : uccPriceBetweenPos) {
                    HashMap<Integer, BigDecimal> priceMap = new HashMap<Integer, BigDecimal>();
                    priceMap.put(1, MoneyUtils.haoToYuan(uccPriceBetweenPo.getMaxAgreementPrice()));
                    priceMap.put(2, MoneyUtils.haoToYuan(uccPriceBetweenPo.getMinAgreementPrice()));
                    resultMap.put(uccPriceBetweenPo.getSkuId(), priceMap);
                }
            }
        }
        return resultMap;
    }
}

