/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccBatchCurrentPriceQryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallSalesVolumeAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallStdSkuDetailShowAbilityService;
import com.tydic.commodity.mall.ability.bo.StdSkuDetail;
import com.tydic.commodity.mall.ability.bo.UccBatchCurrentPriceQryAbilityBo;
import com.tydic.commodity.mall.ability.bo.UccBatchCurrentPriceQryAbilityReqBo;
import com.tydic.commodity.mall.ability.bo.UccBatchCurrentPriceQryAbilityRspBo;
import com.tydic.commodity.mall.ability.bo.UccCombEsCommodityBo;
import com.tydic.commodity.mall.ability.bo.UccMallJdPriceBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallNotJdPriceBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallQrySalesVolumeBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySalesVolumeReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySalesVolumeRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySalesVolumeRspDetailBO;
import com.tydic.commodity.mall.ability.bo.UccMallStdSkuDetailShowReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallStdSkuDetailShowRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallStdSkuInfoImageBo;
import com.tydic.commodity.mall.ability.bo.UccMallStdSkuSpecPropsBo;
import com.tydic.commodity.mall.ability.bo.UccSkuSpecPropsBo;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallCommodityLabelMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPicMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSkuStandardRelationMapper;
import com.tydic.commodity.mall.dao.UccMallVendorMapper;
import com.tydic.commodity.mall.dao.UccSkuSpecMapper;
import com.tydic.commodity.mall.po.UccMallSkuVendorPO;
import com.tydic.commodity.mall.po.UccSkuPicPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallStdSkuDetailShowAbilityService"})
public class UccMallStdSkuDetailShowAbilityServiceImpl
implements UccMallStdSkuDetailShowAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallStdSkuDetailShowAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuStandardRelationMapper uccMallSkuStandardRelationMapper;
    @Autowired
    private UccBatchCurrentPriceQryAbilityService uccBatchCurrentPriceQryAbilityService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private UccMallSalesVolumeAbilityService uccMallSalesVolumeAbilityService;
    @Autowired
    private UccMallVendorMapper uccMallVendorMapper;
    @Autowired
    private UccMallSkuPicMapper uccMallSkuPicMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Autowired
    private UccMallCommodityLabelMapper uccMallCommodityLabelMapper;
    @Value(value="${mock_call_out_elc_interface:false}")
    private boolean mockCallOutElcInterface;

    @PostMapping(value={"stdSkuDetailShow"})
    public UccMallStdSkuDetailShowRspBO stdSkuDetailShow(@RequestBody UccMallStdSkuDetailShowReqBO reqBO) {
        UccMallStdSkuDetailShowRspBO rspBO = new UccMallStdSkuDetailShowRspBO();
        Long stdSkuId = reqBO.getStdSkuId();
        if (StringUtils.isEmpty((Object)stdSkuId)) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc(UccMallConstantsEnums.REQUIRED_NON_EMPTY.message());
            return rspBO;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)stdSkuId));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_type", (int)1));
        JSONObject queryJson = new JSONObject();
        String queryString = boolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String result = this.searchInfo(queryJson.toString());
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        StdSkuDetail stdSkuDetail = new StdSkuDetail();
        if (!CollectionUtils.isEmpty((Collection)listObject)) {
            List<UccSkuPo> uccSkuPos;
            List<Long> skuIds;
            JSONObject hitObj = listObject.getJSONObject(0);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            UccCombEsCommodityBo commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
            stdSkuDetail.setStdSkuId(stdSkuId);
            if (!StringUtils.isEmpty((Object)commodity.getSku_name())) {
                stdSkuDetail.setStdSkuName(commodity.getSku_name());
            }
            if (!StringUtils.isEmpty((Object)commodity.getSku_code())) {
                stdSkuDetail.setStdSkuCode(commodity.getSku_code());
            }
            if (!StringUtils.isEmpty((Object)commodity.getMaterial_id())) {
                stdSkuDetail.setMaterialId(commodity.getMaterial_id().toString());
            }
            if (!StringUtils.isEmpty((Object)commodity.getMaterial_code())) {
                stdSkuDetail.setMaterialCode(commodity.getMaterial_code());
            }
            if (!StringUtils.isEmpty((Object)commodity.getBrand_id())) {
                stdSkuDetail.setBrandId(Long.valueOf(commodity.getBrand_id()));
            }
            if (!StringUtils.isEmpty((Object)commodity.getBrand_name())) {
                stdSkuDetail.setBrandName(commodity.getBrand_name());
            }
            if (!StringUtils.isEmpty((Object)commodity.getSpec())) {
                stdSkuDetail.setSpec(commodity.getSpec());
            }
            if (!StringUtils.isEmpty((Object)commodity.getModel())) {
                stdSkuDetail.setModel(commodity.getModel());
            }
            if (!StringUtils.isEmpty((Object)commodity.getExt_sku_id())) {
                stdSkuDetail.setExtSkuId(commodity.getExt_sku_id());
            }
            if (!StringUtils.isEmpty((Object)commodity.getSku_source())) {
                stdSkuDetail.setSkuSource(Integer.valueOf(commodity.getSku_source()));
            }
            if (!CollectionUtils.isEmpty((Collection)commodity.getSkuPoolIds())) {
                this.editCommodityPoolLabelName(commodity.getSkuPoolIds(), stdSkuDetail);
            }
            if (!CollectionUtils.isEmpty(skuIds = this.uccMallSkuStandardRelationMapper.querySkuIdListByStdSkuId(stdSkuId)) && !CollectionUtils.isEmpty(uccSkuPos = this.uccMallSkuMapper.qeryBatchSkus(skuIds))) {
                this.editTotalSaleNum(stdSkuDetail, uccSkuPos);
                this.editPrice(stdSkuDetail, uccSkuPos);
                this.editImags(stdSkuDetail, skuIds);
                this.editSkuSpec(stdSkuId, stdSkuDetail);
            }
        } else {
            rspBO.setRespCode(UccMallConstantsEnums.SYSTEM_EXCEPTION.code());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6807\u54c1\u8be6\u7ec6\u4fe1\u606f");
            return rspBO;
        }
        rspBO.setStdSkuDetail(stdSkuDetail);
        rspBO.setRespCode(UccMallConstantsEnums.SUCCESS.code());
        rspBO.setRespDesc(UccMallConstantsEnums.SUCCESS.message());
        return rspBO;
    }

    private void editSkuSpec(Long stdSkuId, StdSkuDetail stdSkuDetail) {
        List<UccSkuSpecPropsBo> uccSkuSpecPropsBos = this.uccSkuSpecMapper.querySpecBySkuId(stdSkuId);
        if (!CollectionUtils.isEmpty(uccSkuSpecPropsBos)) {
            ArrayList<UccMallStdSkuSpecPropsBo> skuSpec = new ArrayList<UccMallStdSkuSpecPropsBo>();
            for (UccSkuSpecPropsBo uccSkuSpecPropsBo : uccSkuSpecPropsBos) {
                UccMallStdSkuSpecPropsBo uccMallStdSkuSpecPropsBo = new UccMallStdSkuSpecPropsBo();
                BeanUtils.copyProperties((Object)uccSkuSpecPropsBo, (Object)uccMallStdSkuSpecPropsBo);
                skuSpec.add(uccMallStdSkuSpecPropsBo);
            }
            stdSkuDetail.setSkuSpec(skuSpec);
        }
    }

    private void editImags(StdSkuDetail stdSkuDetail, List<Long> skuIds) {
        List<UccMallSkuVendorPO> uccMallSkuVendorPOS = this.uccMallVendorMapper.batchSelectBySkuIds(skuIds);
        ArrayList<Long> stdSkuImagsIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(uccMallSkuVendorPOS)) {
            for (UccMallSkuVendorPO uccMallSkuVendorPO : uccMallSkuVendorPOS) {
                if (uccMallSkuVendorPO.getVendorName().equals("\u4eac\u4e1c")) continue;
                stdSkuImagsIds.add(uccMallSkuVendorPO.getSkuId());
            }
        }
        List<UccSkuPicPo> uccSkuPicPos = null;
        uccSkuPicPos = CollectionUtils.isEmpty(stdSkuImagsIds) ? this.uccMallSkuPicMapper.qeurySkuPicBySkuId(skuIds) : this.uccMallSkuPicMapper.qeurySkuPicBySkuId(stdSkuImagsIds);
        if (!CollectionUtils.isEmpty(uccSkuPicPos)) {
            List collect = uccSkuPicPos.stream().sorted(Comparator.comparing(UccSkuPicPo::getCreateTime).reversed()).collect(Collectors.toList());
            ArrayList<UccMallStdSkuInfoImageBo> stdSkuImags = new ArrayList<UccMallStdSkuInfoImageBo>();
            for (UccSkuPicPo uccSkuPicPo : collect) {
                UccMallStdSkuInfoImageBo uccMallStdSkuInfoImageBo = new UccMallStdSkuInfoImageBo();
                BeanUtils.copyProperties((Object)uccSkuPicPo, (Object)uccMallStdSkuInfoImageBo);
                stdSkuImags.add(uccMallStdSkuInfoImageBo);
            }
            stdSkuDetail.setStdSkuImags(stdSkuImags);
        }
    }

    private void editTotalSaleNum(StdSkuDetail stdSkuDetail, List<UccSkuPo> uccSkuPos) {
        BigDecimal totalSaleNum = new BigDecimal(1);
        Map<Long, List<UccSkuPo>> shopIdSkuPoMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        Iterator<Long> iteratorSku = shopIdSkuPoMap.keySet().iterator();
        ArrayList<UccMallQrySalesVolumeBO> qrySalesVolumeBOS = new ArrayList<UccMallQrySalesVolumeBO>();
        while (iteratorSku.hasNext()) {
            Long supplierShopId = iteratorSku.next();
            UccMallQrySalesVolumeBO uccMallQrySalesVolumeBO = new UccMallQrySalesVolumeBO();
            uccMallQrySalesVolumeBO.setSupplierShopId(supplierShopId);
            List groupSkuId = shopIdSkuPoMap.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            uccMallQrySalesVolumeBO.setSkuIds(groupSkuId);
            qrySalesVolumeBOS.add(uccMallQrySalesVolumeBO);
        }
        UccMallQrySalesVolumeReqBO uccMallQrySalesVolumeReqBO = new UccMallQrySalesVolumeReqBO();
        uccMallQrySalesVolumeReqBO.setQrySalesVolumeBOS(qrySalesVolumeBOS);
        UccMallQrySalesVolumeRspBO uccMallQrySalesVolumeRspBO = this.uccMallSalesVolumeAbilityService.querySalesVolume(uccMallQrySalesVolumeReqBO);
        if (UccMallConstantsEnums.SUCCESS.code().equals(uccMallQrySalesVolumeRspBO.getRespCode())) {
            List rspDetailBOS = uccMallQrySalesVolumeRspBO.getRspDetailBOS();
            List collect = rspDetailBOS.stream().map(UccMallQrySalesVolumeRspDetailBO::getSkuSale).collect(Collectors.toList());
            for (Map longBigDecimalMap : collect) {
                Collection values = longBigDecimalMap.values();
                for (BigDecimal saleNum : values) {
                    totalSaleNum = totalSaleNum.add(saleNum);
                }
            }
            totalSaleNum = totalSaleNum.subtract(new BigDecimal(1));
            stdSkuDetail.setTotalSaleNum(totalSaleNum);
        }
    }

    private void editPrice(StdSkuDetail stdSkuDetail, List<UccSkuPo> uccSkuPos) {
        ArrayList<BigDecimal> marketPrice = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> salePrice = new ArrayList<BigDecimal>();
        if (!this.mockCallOutElcInterface) {
            ArrayList<UccBatchCurrentPriceQryAbilityBo> skuInfo = new ArrayList<UccBatchCurrentPriceQryAbilityBo>();
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                UccBatchCurrentPriceQryAbilityBo uccBatchCurrentPriceQryAbilityBo = new UccBatchCurrentPriceQryAbilityBo();
                uccBatchCurrentPriceQryAbilityBo.setSkuId(uccSkuPo.getSkuId());
                uccBatchCurrentPriceQryAbilityBo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                skuInfo.add(uccBatchCurrentPriceQryAbilityBo);
            }
            UccBatchCurrentPriceQryAbilityReqBo uccBatchCurrentPriceQryAbilityReqBo = new UccBatchCurrentPriceQryAbilityReqBo();
            uccBatchCurrentPriceQryAbilityReqBo.setSkuInfo(skuInfo);
            UccBatchCurrentPriceQryAbilityRspBo uccBatchCurrentPriceQryAbilityRspBo = this.uccBatchCurrentPriceQryAbilityService.dealPrice(uccBatchCurrentPriceQryAbilityReqBo);
            if (UccMallConstantsEnums.SUCCESS.code().equals(uccBatchCurrentPriceQryAbilityRspBo.getRespCode())) {
                for (UccMallJdPriceBO_busi jdPriceBoBusi : uccBatchCurrentPriceQryAbilityRspBo.getCommdPriceInfo().getJdPriceInfos()) {
                    marketPrice.add(jdPriceBoBusi.getMarketPrice());
                    salePrice.add(jdPriceBoBusi.getNewSalePrice());
                }
                for (UccMallNotJdPriceBO_busi notJdPriceBoBusi : uccBatchCurrentPriceQryAbilityRspBo.getCommdPriceInfo().getNotJdPriceInfo()) {
                    marketPrice.add(notJdPriceBoBusi.getMarketPrice());
                    salePrice.add(notJdPriceBoBusi.getNewSalePrice());
                }
            }
        } else {
            Map<Long, List<UccSkuPo>> collect = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : collect.keySet()) {
                List<UccSkuPo> uccSkuPos1 = collect.get(supplierShopId);
                List<Long> collect1 = uccSkuPos1.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                List<UccSkuPricePo> uccSkuPricePos = this.uccMallSkuPriceMapper.batchQryPriBySkuIds(collect1, supplierShopId);
                for (UccSkuPricePo uccSkuPricePo : uccSkuPricePos) {
                    marketPrice.add(new BigDecimal(uccSkuPricePo.getMarketPrice()));
                    salePrice.add(new BigDecimal(uccSkuPricePo.getSalePrice()));
                }
            }
        }
        if (!CollectionUtils.isEmpty(marketPrice)) {
            BigDecimal minMarketPrice = (BigDecimal)marketPrice.get(0);
            BigDecimal maxMarketPrice = (BigDecimal)marketPrice.get(0);
            for (int i = 0; i < marketPrice.size(); ++i) {
                if (minMarketPrice.compareTo((BigDecimal)marketPrice.get(i)) == 1) {
                    minMarketPrice = (BigDecimal)marketPrice.get(i);
                }
                if (maxMarketPrice.compareTo((BigDecimal)marketPrice.get(i)) != -1) continue;
                maxMarketPrice = (BigDecimal)marketPrice.get(i);
            }
            stdSkuDetail.setMinMarketPrice(minMarketPrice);
            stdSkuDetail.setMaxMarketPrice(maxMarketPrice);
        }
        if (!CollectionUtils.isEmpty(salePrice)) {
            BigDecimal minSalePrice = (BigDecimal)salePrice.get(0);
            BigDecimal maxSalePrice = (BigDecimal)salePrice.get(0);
            for (int i = 0; i < marketPrice.size(); ++i) {
                if (minSalePrice.compareTo((BigDecimal)salePrice.get(i)) == 1) {
                    minSalePrice = (BigDecimal)salePrice.get(i);
                }
                if (maxSalePrice.compareTo((BigDecimal)salePrice.get(i)) != -1) continue;
                maxSalePrice = (BigDecimal)salePrice.get(i);
            }
            stdSkuDetail.setMinSalePrice(minSalePrice);
            stdSkuDetail.setMaxSalePrice(maxSalePrice);
        }
    }

    private void editCommodityPoolLabelName(List<String> skuPoolIds, StdSkuDetail stdSkuDetail) {
        ArrayList<String> poolLabelNames = new ArrayList<String>();
        for (String skuPoolId : skuPoolIds) {
            Long poolId = Long.valueOf(skuPoolId);
            String LabelName = this.uccMallCommodityLabelMapper.queryLabelName(poolId);
            if (!StringUtils.isEmpty((Object)LabelName)) {
                poolLabelNames.add(LabelName);
                continue;
            }
            log.warn("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u6c60ID\u4e3a" + skuPoolId + "\u7684\u5546\u54c1\u6c60\u6807\u7b7e\u4fe1\u606f");
        }
        stdSkuDetail.setTabList(poolLabelNames);
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.mallEsConfig.getIndexName() + "/" + this.mallEsConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }
}

