/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceRemoveCmsSkuInfoService;
import com.tydic.commodity.mall.atom.bo.InterfaceRemoveSkuInfoReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceRemoveSkuInfoRspBO;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="uccRemoveCmsSkuInfoService")
public class InterfaceRemoveCmsSkuInfoServiceImpl
implements InterfaceRemoveCmsSkuInfoService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceRemoveCmsSkuInfoServiceImpl.class);

    @Override
    public InterfaceRemoveSkuInfoRspBO removeCmsSkuInfo(InterfaceRemoveSkuInfoReqBO reqBO) {
        InterfaceRemoveSkuInfoRspBO uccRemoveSkuInfoRspBO = new InterfaceRemoveSkuInfoRspBO();
        try {
            for (String columeCode : reqBO.getColumnCode()) {
                String reqStr = this.initReqStr(columeCode);
                String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, null, "BUSINESS_COMMODITY");
                HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(reqBO.getUrl()), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
                if (httpRetBean.getStatus() != 200) {
                    log.error("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25,[http_status=" + httpRetBean.getStatus() + "], [http_url=" + reqBO.getUrl() + "]");
                    throw new RuntimeException("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1\u4e1a\u52a1\u5931\u8d25");
                }
                log.info("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
                String returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((CharSequence)returnString)) {
                    throw new RuntimeException("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                InterfaceRemoveSkuInfoRspBO removeSkuInfoRspBO = this.resolveRsp(returnString);
                if (removeSkuInfoRspBO.isSuccess()) continue;
                throw new BusinessException(removeSkuInfoRspBO.getCode(), removeSkuInfoRspBO.getMessage());
            }
        }
        catch (BusinessException e) {
            log.error("\u53d1\u9001http,\u5220\u9664cms\uff0csku\u4fe1\u606f\u5931\u8d25");
            uccRemoveSkuInfoRspBO.setRespCode("8888");
            uccRemoveSkuInfoRspBO.setRespDesc(e.getMsgInfo());
            return uccRemoveSkuInfoRspBO;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001http,\u5220\u9664cms\uff0csku\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            uccRemoveSkuInfoRspBO.setRespCode("8888");
            uccRemoveSkuInfoRspBO.setRespDesc("\u5220\u9664cms\u7684sku\u4fe1\u606f\u5931\u8d25");
            return uccRemoveSkuInfoRspBO;
        }
        uccRemoveSkuInfoRspBO.setRespCode("0000");
        uccRemoveSkuInfoRspBO.setRespDesc("\u6210\u529f");
        uccRemoveSkuInfoRspBO.setSuccess(true);
        return uccRemoveSkuInfoRspBO;
    }

    private String initReqStr(String columeCode) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)columeCode);
        return jsonObject.toString();
    }

    private InterfaceRemoveSkuInfoRspBO resolveRsp(String returnString) {
        InterfaceRemoveSkuInfoRspBO removeSkuInfoRspBO = new InterfaceRemoveSkuInfoRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            removeSkuInfoRspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            removeSkuInfoRspBO.setCode(String.valueOf(rspJsonObject.get((Object)"code")));
            removeSkuInfoRspBO.setMessage((String)rspJsonObject.get((Object)"message"));
            return removeSkuInfoRspBO;
        }
        catch (Exception var10) {
            log.error("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

