/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.commodity.mall.ability.api.UccMallQuerySkuDecimalLimitAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallQuerySkuDecimalLimitDataBo;
import com.tydic.commodity.mall.ability.bo.UccMallQuerySkuDecimalLimitReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallQuerySkuDecimalLimitRspBo;
import com.tydic.commodity.mall.dao.UccMallCommodityMeasureMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccCommodityMeasurePo;
import com.tydic.commodity.mall.po.UccMallSkuSupplierPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQuerySkuDecimalLimitAbilityService"})
public class UccMallQuerySkuDecimalLimitAbilityServiceImpl
implements UccMallQuerySkuDecimalLimitAbilityService {
    @Autowired
    private UccMallCommodityMeasureMapper uccMallCommodityMeasureMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @PostMapping(value={"querySkuLimit"})
    public UccMallQuerySkuDecimalLimitRspBo querySkuLimit(@RequestBody UccMallQuerySkuDecimalLimitReqBo reqBo) {
        this.validateArg(reqBo);
        UccMallQuerySkuDecimalLimitRspBo rspBo = new UccMallQuerySkuDecimalLimitRspBo();
        List<UccMallSkuSupplierPO> skuPoList = this.uccMallSkuMapper.batchQryBySkuIds(reqBo.getSkuList());
        ArrayList<UccMallQuerySkuDecimalLimitDataBo> retDataList = new ArrayList<UccMallQuerySkuDecimalLimitDataBo>();
        if (ObjectUtil.isNotEmpty(skuPoList)) {
            List<Long> measureIdList = skuPoList.stream().map(UccMallSkuSupplierPO::getMeasureId).collect(Collectors.toList());
            List<UccCommodityMeasurePo> uccCommodityMeasurePos = this.uccMallCommodityMeasureMapper.batchQueryMeasureById(measureIdList);
            Map<Long, UccCommodityMeasurePo> measurePoMap = uccCommodityMeasurePos.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureId, item -> item));
            for (UccMallSkuSupplierPO sku : skuPoList) {
                UccMallQuerySkuDecimalLimitDataBo dataBo = new UccMallQuerySkuDecimalLimitDataBo();
                if (!ObjectUtil.isNotEmpty((Object)measurePoMap.get(sku.getMeasureId()))) continue;
                dataBo.setDecimalLimit(Integer.valueOf(measurePoMap.get(sku.getMeasureId()).getDecimalLimit() == null ? 0 : measurePoMap.get(sku.getMeasureId()).getDecimalLimit()));
                dataBo.setSkuId(sku.getSkuId());
                retDataList.add(dataBo);
            }
        }
        rspBo.setDataList(retDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateArg(UccMallQuerySkuDecimalLimitReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSkuList())) {
            throw new BusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027skuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

