/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.commodity.mall.atom.api.InterfaceQryFscRuleAbilitySerive;
import com.tydic.commodity.mall.atom.bo.InterfaceMerchantConfBatchQueryReqDataBO;
import com.tydic.commodity.mall.atom.bo.InterfaceQryFscRuleAbilityBo;
import com.tydic.commodity.mall.atom.bo.InterfaceQryFscRuleAbilityReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceQryFscRuleAbilityRspBO;
import com.tydic.commodity.mall.busi.api.UccMallReplacementPriceBusiService;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.constants.SkuSourceEnum;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallVendorMapper;
import com.tydic.commodity.mall.po.UccCommodityPo;
import com.tydic.commodity.mall.po.UccMallSkuVendorPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMallReplacementPriceBusiServiceImpl
implements UccMallReplacementPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallReplacementPriceBusiServiceImpl.class);
    @Autowired
    private UccMallVendorMapper uccMallVendorMapper;
    @Autowired
    private InterfaceQryFscRuleAbilitySerive interfaceQryFscRuleAbilitySerive;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;

    @Override
    public UccMallReplacementPriceRspBo replacePrice(UccMallReplacementPriceReqBo reqBO) {
        UccMallReplacementPriceRspBo rspBO = new UccMallReplacementPriceRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBO.getReplacePriceInfo())) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        if ("2".equals(reqBO.getIsprofess()) && !StringUtils.isEmpty((Object)reqBO.getCompanyId())) {
            this.completeReplaceInfo(reqBO);
            this.replaceSalePrice(reqBO);
            this.replaceByPsDisount(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(reqBO.getReplacePriceInfo());
            return rspBO;
        }
        if ("0".equals(reqBO.getIsprofess()) || StringUtils.isEmpty((Object)reqBO.getCompanyId())) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(reqBO.getReplacePriceInfo());
            return rspBO;
        }
        if ("1".equals(reqBO.getIsprofess())) {
            this.completeReplaceInfo(reqBO);
            this.purQryReplace(reqBO);
        }
        this.replaceByPsDisount(reqBO);
        rspBO.setRows(reqBO.getReplacePriceInfo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void purQryReplace(UccMallReplacementPriceReqBo reqBO) {
        InterfaceQryFscRuleAbilityRspBO cnncQryFscRuleAbilityRspBO = this.getFscSettleModeConfig(reqBO);
        if (null != cnncQryFscRuleAbilityRspBO && "0000".equals(cnncQryFscRuleAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty(cnncQryFscRuleAbilityRspBO.getResult())) {
            this.replaceBySettleMode(reqBO, cnncQryFscRuleAbilityRspBO);
        }
    }

    private InterfaceQryFscRuleAbilityRspBO getFscSettleModeConfig(UccMallReplacementPriceReqBo reqBO) {
        Map<Integer, List<ReplacePriceInfoBO>> groupBySource = reqBO.getReplacePriceInfo().stream().collect(Collectors.groupingBy(ReplacePriceInfoBO::getSkuSource));
        if (groupBySource.isEmpty()) {
            return null;
        }
        ArrayList<InterfaceMerchantConfBatchQueryReqDataBO> qryInfo = new ArrayList<InterfaceMerchantConfBatchQueryReqDataBO>();
        InterfaceMerchantConfBatchQueryReqDataBO fscMerchantConfBatchQueryReqDataBO = null;
        for (Map.Entry<Integer, List<ReplacePriceInfoBO>> entry : groupBySource.entrySet()) {
            if (ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION.equals(entry.getKey())) {
                for (ReplacePriceInfoBO bo : entry.getValue()) {
                    fscMerchantConfBatchQueryReqDataBO = new InterfaceMerchantConfBatchQueryReqDataBO();
                    fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                    fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                    fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                    qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
                }
            }
            if (ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT.equals(entry.getKey())) {
                for (ReplacePriceInfoBO bo : entry.getValue()) {
                    fscMerchantConfBatchQueryReqDataBO = new InterfaceMerchantConfBatchQueryReqDataBO();
                    fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                    fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                    fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                    qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
                }
            }
            if (!ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT.equals(entry.getKey())) continue;
            for (ReplacePriceInfoBO bo : entry.getValue()) {
                fscMerchantConfBatchQueryReqDataBO = new InterfaceMerchantConfBatchQueryReqDataBO();
                fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                UccCommodityPo uccCommodityPo = this.uccMallCommodityMapper.getCommodityById(bo.getCommodityId());
                fscMerchantConfBatchQueryReqDataBO.setModelContractId(uccCommodityPo.getOtherSourceId());
                qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
            }
        }
        if (CollectionUtils.isEmpty(qryInfo)) {
            return null;
        }
        InterfaceQryFscRuleAbilityReqBO CnncQryFscRuleAbilityReqBO = new InterfaceQryFscRuleAbilityReqBO();
        CnncQryFscRuleAbilityReqBO.setQryInfo(qryInfo);
        return this.interfaceQryFscRuleAbilitySerive.qryRule(CnncQryFscRuleAbilityReqBO);
    }

    private void replaceBySettleMode(UccMallReplacementPriceReqBo reqBO, InterfaceQryFscRuleAbilityRspBO cnncQryFscRuleAbilityRspBO) {
        for (ReplacePriceInfoBO eachprice : reqBO.getReplacePriceInfo()) {
            for (InterfaceQryFscRuleAbilityBo fsc : cnncQryFscRuleAbilityRspBO.getResult()) {
                if (!fsc.getVendorId().equals(eachprice.getVendorId()) || !fsc.getCommodityTypeId().equals(eachprice.getCommodityTypeId())) continue;
                if (eachprice.getContractId() != null) {
                    if (!fsc.getContractId().equals(eachprice.getOtherSourceId()) || fsc.getBusiMode() == null || fsc.getBusiMode() != 2) continue;
                    eachprice.setSalePrice(eachprice.getAgreementPrice());
                    eachprice.setLadderPrice(null);
                    eachprice.setReplace(Integer.valueOf(1));
                    continue;
                }
                if (fsc.getBusiMode() == null || fsc.getBusiMode() != 2 || SkuSourceEnum.AGREEMENT_SOURCE.getSource().equals(eachprice.getSkuSource())) continue;
                eachprice.setSalePrice(eachprice.getAgreementPrice());
                eachprice.setLadderPrice(null);
                eachprice.setReplace(Integer.valueOf(1));
            }
        }
    }

    private void completeReplaceInfo(UccMallReplacementPriceReqBo reqBO) {
        List<UccMallSkuVendorPO> uccMallSkuVendorPOS;
        List<Long> skuIds = reqBO.getReplacePriceInfo().stream().map(ReplacePriceInfoBO::getSkuId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(skuIds) && !CollectionUtils.isEmpty(uccMallSkuVendorPOS = this.uccMallVendorMapper.batchSelectBySkuIds(skuIds))) {
            Map<Long, UccMallSkuVendorPO> uccMallSkuVendorPOMap = uccMallSkuVendorPOS.stream().collect(Collectors.toMap(UccMallSkuVendorPO::getSkuId, o -> o, (old, cur) -> cur));
            for (ReplacePriceInfoBO replacePriceInfoBO : reqBO.getReplacePriceInfo()) {
                UccMallSkuVendorPO uccMallSkuVendorPO = uccMallSkuVendorPOMap.get(replacePriceInfoBO.getSkuId());
                if (null == uccMallSkuVendorPO) continue;
                replacePriceInfoBO.setCommodityTypeId(uccMallSkuVendorPO.getCommodityTypeId());
                replacePriceInfoBO.setVendorId(uccMallSkuVendorPO.getVendorId());
                replacePriceInfoBO.setSkuSource(uccMallSkuVendorPO.getSkuSource());
            }
        }
    }

    private void replaceSalePrice(UccMallReplacementPriceReqBo reqBO) {
        reqBO.getReplacePriceInfo().forEach(replacePriceInfoBO -> {
            if (reqBO.getCompanyId().equals(replacePriceInfoBO.getVendorId())) {
                replacePriceInfoBO.setSalePrice(replacePriceInfoBO.getAgreementPrice());
            }
        });
    }

    private void replaceByPsDisount(UccMallReplacementPriceReqBo reqBO) {
        if (reqBO.getPsDiscountRate() != null && reqBO.getPsDiscountRate().compareTo(BigDecimal.ZERO) != 0) {
            for (ReplacePriceInfoBO replacePriceInfoBO : reqBO.getReplacePriceInfo()) {
                if (replacePriceInfoBO.getReplace() == 1) continue;
                replacePriceInfoBO.setLadderPrice(null);
                if (replacePriceInfoBO.getSalePrice().equals(replacePriceInfoBO.getAgreementPrice())) continue;
                Long difValue = replacePriceInfoBO.getSalePrice() - replacePriceInfoBO.getAgreementPrice();
                Long salePirce = new BigDecimal(difValue.toString()).multiply(reqBO.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, 4)).longValue() + replacePriceInfoBO.getAgreementPrice();
                replacePriceInfoBO.setSalePrice(salePirce);
            }
        }
    }
}

