/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.self.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSpuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCommodityExtMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.self.ability.api.UccDeleteCommodityAbilityService;
import com.tydic.commodity.self.ability.bo.UccDeleteCommodityAbilityReqBO;
import com.tydic.commodity.self.ability.bo.UccDeleteCommodityAbilityRspBO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccDeleteCommodityAbilityService.class)
public class UccDeleteCommodityAbilityServiceImpl
implements UccDeleteCommodityAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccDeleteCommodityAbilityServiceImpl.class);
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccExtSkuMapper;
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    public UccDeleteCommodityAbilityRspBO dealDeleteCommodity(UccDeleteCommodityAbilityReqBO reqBO) {
        UccDeleteCommodityAbilityRspBO rspBO = new UccDeleteCommodityAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSpuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5220\u9664\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List reqCmmds = reqBO.getBatchSpuList().stream().map(UccBatchSpuBO::getCommodityId).collect(Collectors.toList());
        List poList = this.uccCommodityMapper.qeryBatchCommdity(reqCmmds);
        if (CollectionUtils.isEmpty((Collection)poList) || poList.size() != reqCmmds.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5220\u9664\u5546\u54c1\u4e0d\u5b58\u5728");
            return rspBO;
        }
        for (UccCommodityPo each : poList) {
            if (each.getCommodityStatus() != ModelRuleConstant.COMMD_STATUS_DRAFT) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(each.getCommodityId() + "\u5546\u54c1\u4e0d\u662f\u8349\u7a3f\u72b6\u6001");
                return rspBO;
            }
            if (each.getApprovalStatus() != ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(each.getCommodityId() + "\u5546\u54c1\u6b63\u5728\u5ba1\u6279\u4e2d");
            return rspBO;
        }
        Map<Long, List<UccBatchSpuBO>> group = reqBO.getBatchSpuList().stream().collect(Collectors.groupingBy(UccBatchSpuBO::getCommodityId));
        for (Long shopId : group.keySet()) {
            List cmmds = group.get(shopId).stream().map(UccBatchSpuBO::getCommodityId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(cmmds);
            syncSceneCommodityToEsReqBO.setSupplierId(shopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        this.uccExtSkuMapper.batchDeleteSku(reqCmmds);
        this.uccCommodityExtMapper.batchDeleteCommodity(reqCmmds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

