/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.self.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityLogPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuLogPo;
import com.tydic.commodity.self.busi.api.UccSelfDeleteCommodityBusiService;
import com.tydic.commodity.self.busi.bo.UccSelfDeleteCommodityBusiReqBO;
import com.tydic.commodity.self.busi.bo.UccSelfDeleteCommodityBusiRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccSelfDeleteCommodityBusiServiceImpl
implements UccSelfDeleteCommodityBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSelfDeleteCommodityBusiServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    @Autowired
    private UccCommodityLogMapper uccCommodityLogMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccSelfDeleteCommodityBusiRspBO batchDeleteCommodity(UccSelfDeleteCommodityBusiReqBO reqBO) {
        UccSelfDeleteCommodityBusiRspBO rspBO = new UccSelfDeleteCommodityBusiRspBO();
        Map<Long, List<UccCommodityPo>> uccCommodityPoMap = reqBO.getUccCommodityPos().stream().collect(Collectors.groupingBy(UccCommodityPo::getSupplierShopId));
        for (Long supplierShopId : uccCommodityPoMap.keySet()) {
            List<UccCommodityPo> uccCommodityPos = uccCommodityPoMap.get(supplierShopId);
            List commodityIds = uccCommodityPos.stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
            List skuPos = this.uccSkuMapper.qrySkuByCommoditys(commodityIds, supplierShopId);
            if (!CollectionUtil.isEmpty((Collection)skuPos)) {
                List uccSkuLogPos = skuPos.stream().map(e -> {
                    UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
                    Long batchId = this.sequence.nextId();
                    BeanUtils.copyProperties((Object)e, (Object)uccSkuLogPo);
                    uccSkuLogPo.setBatchId(batchId);
                    return uccSkuLogPo;
                }).collect(Collectors.toList());
                this.uccSkuLogMapper.addSkuLog(uccSkuLogPos);
                this.uccSkuMapper.batchDeleteSku(commodityIds);
            } else {
                log.warn("\u5546\u54c1\u4e0b\u4e0d\u5b58\u5728\u5355\u54c1");
            }
            List uccCommodityLogPOS = uccCommodityPos.stream().map(e -> {
                UccCommodityLogPO uccCommodityLogPO = new UccCommodityLogPO();
                Long batchId = this.sequence.nextId();
                BeanUtils.copyProperties((Object)e, (Object)uccCommodityLogPO);
                uccCommodityLogPO.setBatchId(batchId);
                return uccCommodityLogPO;
            }).collect(Collectors.toList());
            this.uccCommodityLogMapper.batchInsert(uccCommodityLogPOS);
            this.uccCommodityMapper.batchDeleteCommodity(commodityIds);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

