/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.comb.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.base.bo.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.bo.UccAgrSkuMinimalismInfoBo;
import com.tydic.commodity.busibase.busi.api.UccSkuBatchAddRecordBusiService;
import com.tydic.commodity.busibase.busi.bo.UccSkuBatchAddRecordBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSkuBatchAddRecordBusiRspBO;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.busi.api.UccAgrMinimalismCreateSkuImportBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrMinimalismCreateSkuImportBusiReqBo;
import com.tydic.commodity.zone.busi.bo.UccAgrMinimalismCreateSkuImportBusiRspBo;
import com.tydic.commodity.zone.comb.api.UccAgrMinimalismCreateSkuImportCombRspBo;
import com.tydic.commodity.zone.comb.bo.UccAgrMinimalismCreateSkuImportCombReqBo;
import com.tydic.commodity.zone.comb.bo.UccAgrMinimalismCreateSkuImportCombService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccAgrMinimalismCreateSkuImportCombServiceImpl
implements UccAgrMinimalismCreateSkuImportCombService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrMinimalismCreateSkuImportCombServiceImpl.class);
    @Autowired
    private UccAgrMinimalismCreateSkuImportBusiService uccAgrMinimalismCreateSkuImportBusiService;
    @Autowired
    private UccSkuBatchAddRecordBusiService uccSkuBatchAddRecordBusiService;
    @Value(value="${minimalism.create.increment:20000}")
    private Integer INCREMENT;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;

    @Override
    public UccAgrMinimalismCreateSkuImportCombRspBo minimalismImportSku(UccAgrMinimalismCreateSkuImportCombReqBo reqBo) {
        List<UccAgrSkuMinimalismInfoBo> skuMinimalismInfoBoList = reqBo.getSkuMinimalismInfoBoList();
        UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo = this.minimalismCreateSku(skuMinimalismInfoBoList, reqBo);
        if (reqBo.isSubmitEnable()) {
            this.addRecord(reqBo, busiRspBo);
        }
        this.syncAgrSenter(reqBo);
        UccAgrMinimalismCreateSkuImportCombRspBo combRspBo = new UccAgrMinimalismCreateSkuImportCombRspBo();
        combRspBo.setRespCode("0000");
        combRspBo.setRespDesc("\u6210\u529f");
        return combRspBo;
    }

    private void syncAgrSenter(UccAgrMinimalismCreateSkuImportCombReqBo reqBo) {
        if (UccConstants.MinimalismCreateType.HAVE_DETAILS.equals(reqBo.getCreateType())) {
            UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
            try {
                notifyMessageBO.setAuditStatus("0");
                notifyMessageBO.setStationCode("0");
                notifyMessageBO.setAgreementId(Convert.toStr((Object)reqBo.getAgreementId()));
                notifyMessageBO.setAgreementSkuIds(reqBo.getSkuMinimalismInfoBoList().stream().map(e -> Convert.toStr((Object)e.getAgreementDetailsId())).collect(Collectors.toList()));
                notifyMessageBO.setAgreementSkuStatus("0");
                notifyMessageBO.setMemIdIn(reqBo.getUserId());
                notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_UP_SHELF.code());
                log.info("\u521b\u5efa\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
                this.zoneGoodsAuditMQ.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TOPIC"), PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
            }
            catch (Exception var16) {
                log.error("\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
            }
        }
    }

    private void addRecord(UccAgrMinimalismCreateSkuImportCombReqBo reqBo, UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo) {
        UccSkuBatchAddRecordBusiReqBO uccSkuBatchAddRecordBusiReqBO = new UccSkuBatchAddRecordBusiReqBO();
        uccSkuBatchAddRecordBusiReqBO.setObjType(UccConstants.BatchObjType.COMMODITY);
        uccSkuBatchAddRecordBusiReqBO.setDealType(UccConstants.BatchDealType.COMM_EDIT_SUBMIT);
        uccSkuBatchAddRecordBusiReqBO.setSource(UccConstants.Source.AGR);
        uccSkuBatchAddRecordBusiReqBO.setUserId(reqBo.getUserId());
        uccSkuBatchAddRecordBusiReqBO.setName(reqBo.getName());
        uccSkuBatchAddRecordBusiReqBO.setOrgId(reqBo.getOrgId());
        uccSkuBatchAddRecordBusiReqBO.setOrgName(reqBo.getOrgName());
        uccSkuBatchAddRecordBusiReqBO.setCompanyId(reqBo.getCompanyId());
        uccSkuBatchAddRecordBusiReqBO.setCompanyName(reqBo.getCompanyName());
        uccSkuBatchAddRecordBusiReqBO.setBatchObjList(busiRspBo.getCommodityIdList().stream().map(commodityId -> {
            UccSkuBatchAddRecordBO uccSkuBatchAddRecordBO = new UccSkuBatchAddRecordBO();
            uccSkuBatchAddRecordBO.setObjId(commodityId);
            return uccSkuBatchAddRecordBO;
        }).collect(Collectors.toList()));
        UccSkuBatchAddRecordBusiRspBO uccSkuBatchAddRecordBusiRspBO = this.uccSkuBatchAddRecordBusiService.addRecrod(uccSkuBatchAddRecordBusiReqBO);
        if (!"0000".equals(uccSkuBatchAddRecordBusiRspBO.getRespCode())) {
            throw new BusinessException("8888", uccSkuBatchAddRecordBusiRspBO.getRespDesc());
        }
    }

    private UccAgrMinimalismCreateSkuImportBusiRspBo minimalismCreateSku(List<UccAgrSkuMinimalismInfoBo> subList, UccAgrMinimalismCreateSkuImportCombReqBo reqBo) {
        UccAgrMinimalismCreateSkuImportBusiReqBo busiReqBo = new UccAgrMinimalismCreateSkuImportBusiReqBo();
        busiReqBo.setUsername(reqBo.getUsername());
        busiReqBo.setUserId(reqBo.getUserId());
        busiReqBo.setName(reqBo.getName());
        busiReqBo.setOperLogEnable(reqBo.isOperLogEnable());
        busiReqBo.setSkuMinimalismInfoBoList(subList);
        UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo = this.uccAgrMinimalismCreateSkuImportBusiService.minimalismImportSku(busiReqBo);
        if (!"0000".equals(busiRspBo.getRespCode())) {
            throw new BusinessException("8888", busiRspBo.getRespDesc());
        }
        return busiRspBo;
    }
}

