/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.FileUpLoad;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.YesNoEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityServiceMapper;
import com.tydic.commodity.dao.UccCommodityServiceReturnMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccCommodityPackagePo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityServicePO;
import com.tydic.commodity.po.UccCommodityServiceReturnPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.api.UccAgrMinimalismCreateSkuTemplateExportAbilityService;
import com.tydic.commodity.zone.ability.api.UccAgrMinimalismEditSkuTemplateExportAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrMinimalismCreateSkuTemplateExportAbilityReqBo;
import com.tydic.commodity.zone.ability.bo.UccAgrMinimalismCreateSkuTemplateExportAbilityRspBo;
import com.tydic.commodity.zone.ability.bo.UccAgrSpuEditTemplateExportReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSpuEditTemplateExportRspBO;
import com.tydic.commodity.zone.ability.bo.UccMiniTemplateInfoBo;
import com.tydic.commodity.zone.ability.impl.UccAgrSpuSupplierEditTemplateExportAbilityServiceImpl;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrMinimalismEditSkuTemplateExportAbilityService"})
public class UccAgrMinimalismEditSkuTemplateExportAbilityServiceImpl
implements UccAgrMinimalismEditSkuTemplateExportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrMinimalismEditSkuTemplateExportAbilityServiceImpl.class);
    @Value(value="${miniEdit.template.sup:}")
    private String miniEditSup;
    @Value(value="${miniEdit.template.pro:}")
    private String miniEditPro;
    @Value(value="${miniEdit.template.noDetail.pur:}")
    private String miniEditPur;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private AgrGetAgrItemListService agrGetAgrItemListService;
    @Autowired
    private UccCommodityServiceMapper uccCommodityServiceMapper;
    @Autowired
    private UccCommodityPackageMapper uccCommodityPackageMapper;
    @Autowired
    private UccCommodityServiceReturnMapper uccCommodityServiceReturnMapper;
    @Autowired
    private UccAgrSpuSupplierEditTemplateExportAbilityServiceImpl uccAgrSpuSupplierEditTemplateExportAbilityService;
    @Autowired
    private UccAgrMinimalismCreateSkuTemplateExportAbilityService uccAgrMinimalismCreateSkuTemplateExportAbilityService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private FileUpLoad fileUpLoad;

    @PostMapping(value={"miniEditTemplateExport"})
    public UccAgrSpuEditTemplateExportRspBO miniEditTemplateExport(@RequestBody UccAgrSpuEditTemplateExportReqBO reqBO) {
        UccAgrSpuEditTemplateExportRspBO rspBO = new UccAgrSpuEditTemplateExportRspBO();
        if (reqBO.getCommodityTypeId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u9009\u62e9\u5546\u54c1\u7c7b\u578b\uff01");
            return rspBO;
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId());
        if (uccCommodityTypePo == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5546\u54c1\u7c7b\u578b\uff01");
            return rspBO;
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u52fe\u9009\u5bf9\u5e94\u7684\u5355\u54c1\u8fdb\u884c\u6279\u91cf\u7f16\u8f91\uff01");
            return rspBO;
        }
        List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
        List uccCommodityPoList = this.uccCommodityMapper.queryByCommodityIdLists(uccSkuPoList.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList()));
        List commodityIdList = uccCommodityPoList.stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
        ArrayList agrItemDetailBoList = new ArrayList();
        for (UccSkuPo each : uccSkuPoList) {
            if (!ObjectUtil.isNotNull((Object)each.getAgreementId()) || !ObjectUtil.isNotNull((Object)each.getAgreementDetailsId())) continue;
            AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
            agrGetAgrItemListReqBO.setAgrItemId(each.getAgreementDetailsId());
            agrGetAgrItemListReqBO.setAgrId(each.getAgreementId());
            agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
            log.info("\u6781\u7b80\u6a21\u5f0f\u67e5\u8be2\u534f\u8bae\u660e\u7ec6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)agrGetAgrItemListReqBO));
            AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
            log.info("\u6781\u7b80\u6a21\u5f0f\u67e5\u8be2\u534f\u8bae\u660e\u7ec6\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)agrGetAgrItemListRspBO));
            if (!"0000".equals(agrGetAgrItemListRspBO.getRespCode())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6781\u7b80\u6a21\u5f0f\u67e5\u8be2\u534f\u8bae\u660e\u7ec6\u5931\u8d25\uff1a" + agrGetAgrItemListRspBO.getRespDesc());
                return rspBO;
            }
            agrItemDetailBoList.addAll(agrGetAgrItemListRspBO.getRows());
        }
        Map<Long, AgrItemDetailBo> agrItemIdAgrItemMap = agrItemDetailBoList.stream().collect(Collectors.toMap(AgrItemDetailBo::getAgrItemId, Function.identity(), (a, b) -> a));
        List matIdList = uccSkuPoList.stream().map(UccSkuPo::getMaterialId).filter(StrUtil::isNotEmpty).distinct().map(Long::valueOf).collect(Collectors.toList());
        List materialPOList = this.uccEMdmMaterialMapper.exportSearchMaterial(new UccEMdmMaterialPO(), matIdList);
        Map<Long, UccEMdmMaterialPO> matIdMatMap = materialPOList.stream().collect(Collectors.toMap(UccEMdmMaterialPO::getMaterialId, Function.identity(), (a, b) -> a));
        List spuList = this.uccCommodityMapper.queryByCommodityIdLists(commodityIdList);
        Map<Long, UccCommodityPo> spuIdSpuMap = spuList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, Function.identity(), (a, b) -> a));
        Map<Long, Long> skuIdStockMap = this.uccAgrSpuSupplierEditTemplateExportAbilityService.batchGetStock(reqBO.getSkuIds());
        List skuPricePoList = this.uccSkuPriceMapper.qryPriceBySkuIds(reqBO.getSkuIds());
        Map<Long, UccSkuPricePo> skuIdPriceMap = skuPricePoList.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, Function.identity(), (a, b) -> a));
        List ladderPricePOList = this.uccLadderPriceMapper.selectListBySku(reqBO.getSkuIds());
        Map<Long, List<UccLadderPricePO>> skuIdLadderListMap = ladderPricePOList.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
        List commodityPackagePoList = this.uccCommodityPackageMapper.queryCommdPackageByCommdityIds(commodityIdList);
        Map spuIdPackMap = commodityPackagePoList.stream().collect(Collectors.toMap(UccCommodityPackagePo::getCommodityId, Function.identity(), (a, b) -> a));
        List commodityServicePOList = this.uccCommodityServiceMapper.queryCommodityServiceByCommodityId(commodityIdList);
        Map<Long, UccCommodityServicePO> spuIdServiceMap = commodityServicePOList.stream().collect(Collectors.toMap(UccCommodityServicePO::getCommodityId, Function.identity(), (a, b) -> a));
        List commodityServiceReturnPOList = this.uccCommodityServiceReturnMapper.getListByCommodityIds(commodityIdList);
        Map<Long, UccCommodityServiceReturnPO> spuIdReturnMap = commodityServiceReturnPOList.stream().collect(Collectors.toMap(UccCommodityServiceReturnPO::getCommodityId, Function.identity(), (a, b) -> a));
        String fileUrl = "";
        String suffix = "";
        switch (reqBO.getIsProfessionalOrgExt()) {
            case "0": {
                fileUrl = this.miniEditPro;
                suffix = "\u8fd0\u8425\u5355\u4f4d";
                break;
            }
            case "1": {
                fileUrl = this.miniEditPur;
                suffix = "\u91c7\u8d2d\u5355\u4f4d";
                break;
            }
            case "2": {
                fileUrl = this.miniEditSup;
                suffix = "\u4f9b\u5e94\u5546";
                break;
            }
        }
        if (StrUtil.isEmpty((CharSequence)fileUrl) || StrUtil.isEmpty((CharSequence)suffix)) {
            log.info("\u5339\u914d\u5546\u54c1\u6279\u91cf\u7f16\u8f91\u5bfc\u5165\u6a21\u7248\u51fa\u9519, fileUrl={}, suffix={}", (Object)fileUrl, (Object)suffix);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        HSSFWorkbook workbook = this.createExcel(rspBO, fileUrl, suffix);
        List onShelveWayList = this.uccDictionaryAtomService.queryBypCodeBackPo("SKU_ON_SHELVE_WAY");
        Map<String, String> onShelveWayMap = onShelveWayList.stream().collect(Collectors.toMap(DicDictionaryPo::getCode, DicDictionaryPo::getTitle));
        this.createFixDate(workbook);
        this.writeExcel(workbook, matIdMatMap, spuIdServiceMap, spuIdSpuMap, uccSkuPoList, skuIdStockMap, agrItemIdAgrItemMap, spuIdReturnMap, skuIdPriceMap, skuIdLadderListMap, reqBO, onShelveWayMap);
        workbook.setActiveSheet(0);
        String rspUrl = this.upload((Workbook)workbook, suffix);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setUrl(rspUrl);
        return rspBO;
    }

    private void createFixDate(HSSFWorkbook workbook) {
        HSSFSheet sheet2 = workbook.getSheetAt(1);
        UccAgrMinimalismCreateSkuTemplateExportAbilityReqBo reqBo = new UccAgrMinimalismCreateSkuTemplateExportAbilityReqBo();
        reqBo.setCreateType(UccConstants.MinimalismCreateType.NO_DETAILS);
        UccAgrMinimalismCreateSkuTemplateExportAbilityRspBo rspBo = this.uccAgrMinimalismCreateSkuTemplateExportAbilityService.miniCreateTemplateExport(reqBo);
        List uccMiniTemplateInfoBos = rspBo.getUccMiniTemplateInfoBos();
        CellStyle cellStyle = this.getCellStyle(workbook);
        cellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont((Font)font);
        if (CollectionUtil.isNotEmpty((Collection)uccMiniTemplateInfoBos)) {
            for (int i = 0; i < uccMiniTemplateInfoBos.size(); ++i) {
                UccMiniTemplateInfoBo templateInfoBo = (UccMiniTemplateInfoBo)uccMiniTemplateInfoBos.get(i);
                HSSFRow row = sheet2.createRow(i + 1);
                if (StrUtil.isNotEmpty((CharSequence)templateInfoBo.getMeasureName())) {
                    HSSFCell cell0 = row.createCell(0);
                    cell0.setCellValue(templateInfoBo.getMeasureName());
                    cell0.setCellStyle(cellStyle);
                    cell0.getCellStyle().setLocked(true);
                }
                if (StrUtil.isNotEmpty((CharSequence)templateInfoBo.getAfterDate())) {
                    HSSFCell cell1 = row.createCell(1);
                    cell1.setCellValue("-1".equals(templateInfoBo.getAfterDate()) ? "\u957f\u671f\u6709\u6548" : templateInfoBo.getAfterDate());
                    cell1.setCellStyle(cellStyle);
                    cell1.getCellStyle().setLocked(true);
                }
                if (StrUtil.isNotEmpty((CharSequence)templateInfoBo.getOnShelveWay())) {
                    HSSFCell cell2 = row.createCell(2);
                    cell2.setCellValue(templateInfoBo.getOnShelveWay());
                    cell2.setCellStyle(cellStyle);
                    cell2.getCellStyle().setLocked(true);
                }
                if (StrUtil.isNotEmpty((CharSequence)templateInfoBo.getAfterReturn())) {
                    HSSFCell cell3 = row.createCell(3);
                    cell3.setCellValue(templateInfoBo.getAfterReturn());
                    cell3.setCellStyle(cellStyle);
                    cell3.getCellStyle().setLocked(true);
                }
                if (StrUtil.isNotEmpty((CharSequence)templateInfoBo.getRejectAllow())) {
                    HSSFCell cell4 = row.createCell(4);
                    cell4.setCellValue(templateInfoBo.getRejectAllow());
                    cell4.setCellStyle(cellStyle);
                    cell4.getCellStyle().setLocked(true);
                }
                if (StrUtil.isNotEmpty((CharSequence)templateInfoBo.getExchangeAllow())) {
                    HSSFCell cell5 = row.createCell(5);
                    cell5.setCellValue(templateInfoBo.getExchangeAllow());
                    cell5.setCellStyle(cellStyle);
                    cell5.getCellStyle().setLocked(true);
                }
                if (!StrUtil.isNotEmpty((CharSequence)templateInfoBo.getMaintainAllow())) continue;
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(templateInfoBo.getMaintainAllow());
                cell6.setCellStyle(cellStyle);
                cell6.getCellStyle().setLocked(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HSSFWorkbook createExcel(UccAgrSpuEditTemplateExportRspBO rspBo, String fileUrl, String suffix) {
        HttpURLConnection urlConnection = null;
        ByteArrayOutputStream dstStream = null;
        ByteArrayInputStream inputStream = null;
        InputStream is = null;
        HSSFWorkbook workbook = null;
        try {
            URL url = new URL(fileUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            is = urlConnection.getInputStream();
            workbook = new HSSFWorkbook(is);
            dstStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)dstStream);
            byte[] bytes = dstStream.toByteArray();
            inputStream = new ByteArrayInputStream(bytes);
            String returnUrl = this.upload((Workbook)workbook, suffix);
            rspBo.setUrl(returnUrl);
        }
        catch (Exception e) {
            log.info("\u521b\u5efa\u6781\u7b80\u6a21\u5f0f\u5546\u54c1\u7f16\u8f91excel\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.info(e.getMessage());
            }
            try {
                if (dstStream != null) {
                    dstStream.close();
                }
            }
            catch (IOException e) {
                log.info(e.getMessage());
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.info(e.getMessage());
            }
        }
        return workbook;
    }

    private String upload(Workbook wb, String suffix) {
        String fileUrl = "";
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outputStream);
            byte[] b = outputStream.toByteArray();
            fileUrl = this.fileUpLoad.upload("\u5546\u54c1\u6279\u91cf\u7f16\u8f91\u5bfc\u5165\u6a21\u7248-" + suffix, b, ".xls");
            outputStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u5bfc\u51faExcel\u51fa\u73b0\u4e25\u91cd\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex.getMessage());
        }
        return fileUrl;
    }

    private void writeExcel(HSSFWorkbook workbook, Map<Long, UccEMdmMaterialPO> matIdMatMap, Map<Long, UccCommodityServicePO> spuIdServiceMap, Map<Long, UccCommodityPo> spuIdSpuMap, List<UccSkuPo> uccSkuPoList, Map<Long, Long> skuIdStockMap, Map<Long, AgrItemDetailBo> agrItemIdAgrItemMap, Map<Long, UccCommodityServiceReturnPO> spuIdReturnMap, Map<Long, UccSkuPricePo> skuIdPriceMap, Map<Long, List<UccLadderPricePO>> skuIdLadderListMap, UccAgrSpuEditTemplateExportReqBO reqBO, Map<String, String> onShelveWayMap) {
        HSSFSheet sheet0 = workbook.getSheetAt(0);
        CellStyle backGroundcellStyle = this.getCellStyle(workbook);
        CellStyle white = this.getCellStyle(workbook);
        white.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        for (int i = 0; i < uccSkuPoList.size(); ++i) {
            UccCommodityServiceReturnPO uccCommodityServiceReturnPO;
            UccCommodityServicePO uccCommodityServicePO;
            UccSkuPo skuPo = uccSkuPoList.get(i);
            HSSFRow row = sheet0.createRow(i + 2);
            HSSFCell cell0 = row.createCell(0);
            cell0.setCellStyle(backGroundcellStyle);
            cell0.setCellValue(spuIdSpuMap.get(skuPo.getCommodityId()).getOtherSourceCode());
            if (StrUtil.isNotEmpty((CharSequence)skuPo.getMaterialId())) {
                UccEMdmMaterialPO materialPO = matIdMatMap.get(Long.valueOf(skuPo.getMaterialId()));
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellStyle(backGroundcellStyle);
                cell1.setCellValue(materialPO.getMaterialCode());
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(materialPO.getMaterialName());
                cell2.setCellStyle(backGroundcellStyle);
            }
            HSSFCell cell3 = row.createCell(3);
            cell3.setCellValue(spuIdSpuMap.get(skuPo.getCommodityId()).getCommodityName());
            cell3.setCellStyle(white);
            HSSFCell cell4 = row.createCell(4);
            Long skuStock = skuIdStockMap.get(skuPo.getSkuId());
            cell4.setCellValue(ObjectUtil.isNull((Object)skuStock) ? "" : MoneyUtils.haoToYuan((Long)skuStock).toPlainString());
            cell4.setCellStyle(white);
            AgrItemDetailBo agrItemDetailBo = null;
            if (MapUtil.isNotEmpty(agrItemIdAgrItemMap)) {
                agrItemDetailBo = agrItemIdAgrItemMap.get(skuPo.getAgreementDetailsId());
            }
            int offset = 0;
            switch (reqBO.getIsProfessionalOrgExt()) {
                case "0": {
                    HSSFCell cell5;
                    if (MapUtil.isNotEmpty(skuIdPriceMap) && ObjectUtil.isNotNull((Object)skuIdPriceMap.get(skuPo.getSkuId()))) {
                        cell5 = row.createCell(5);
                        cell5.setCellStyle(white);
                        cell5.setCellValue(ObjectUtil.isNull((Object)skuIdPriceMap.get(skuPo.getSkuId()).getMarketPrice()) ? "" : MoneyUtils.haoToYuan((Long)skuIdPriceMap.get(skuPo.getSkuId()).getMarketPrice()).toString());
                    }
                    if (!ObjectUtil.isNotNull((Object)agrItemDetailBo)) break;
                    HSSFCell cell6 = row.createCell(6);
                    cell6.setCellStyle(backGroundcellStyle);
                    cell6.setCellValue(ObjectUtil.isNull((Object)agrItemDetailBo.getBuyPrice()) ? "" : agrItemDetailBo.getBuyPrice().toString());
                    HSSFCell cell7 = row.createCell(7);
                    cell7.setCellStyle(backGroundcellStyle);
                    cell7.setCellValue(ObjectUtil.isNull((Object)agrItemDetailBo.getSalePrice()) ? "" : agrItemDetailBo.getSalePrice().toString());
                    break;
                }
                case "1": {
                    HSSFCell cell5;
                    offset = -1;
                    if (MapUtil.isNotEmpty(skuIdPriceMap) && ObjectUtil.isNotNull((Object)skuIdPriceMap.get(skuPo.getSkuId()))) {
                        cell5 = row.createCell(5);
                        cell5.setCellStyle(white);
                        cell5.setCellValue(ObjectUtil.isNull((Object)skuIdPriceMap.get(skuPo.getSkuId()).getMarketPrice()) ? "" : MoneyUtils.haoToYuan((Long)skuIdPriceMap.get(skuPo.getSkuId()).getMarketPrice()).toString());
                    }
                    if (!ObjectUtil.isNotNull((Object)agrItemDetailBo)) break;
                    HSSFCell cell7 = row.createCell(7);
                    cell7.setCellStyle(backGroundcellStyle);
                    cell7.setCellValue(ObjectUtil.isNull((Object)agrItemDetailBo.getSalePrice()) ? "" : agrItemDetailBo.getSalePrice().toString());
                    break;
                }
                case "2": {
                    HSSFCell cell5;
                    offset = -1;
                    if (MapUtil.isNotEmpty(skuIdPriceMap) && ObjectUtil.isNotNull((Object)skuIdPriceMap.get(skuPo.getSkuId()))) {
                        cell5 = row.createCell(5);
                        cell5.setCellStyle(white);
                        cell5.setCellValue(ObjectUtil.isNull((Object)skuIdPriceMap.get(skuPo.getSkuId()).getMarketPrice()) ? "" : MoneyUtils.haoToYuan((Long)skuIdPriceMap.get(skuPo.getSkuId()).getMarketPrice()).toString());
                    }
                    if (!ObjectUtil.isNotNull((Object)agrItemDetailBo)) break;
                    HSSFCell cell6 = row.createCell(6);
                    cell6.setCellStyle(backGroundcellStyle);
                    cell6.setCellValue(ObjectUtil.isNull((Object)agrItemDetailBo.getBuyPrice()) ? "" : agrItemDetailBo.getBuyPrice().toString());
                    break;
                }
            }
            UccSkuPricePo uccSkuPricePo = skuIdPriceMap.get(skuPo.getSkuId());
            HSSFCell cell8 = row.createCell(8 + offset);
            cell8.setCellStyle(white);
            cell8.setCellValue(ObjectUtil.isNull((Object)uccSkuPricePo) ? "" : YesNoEnum.getTypeDesc((Integer)uccSkuPricePo.getSwitchOn()));
            List<UccLadderPricePO> ladderPricePOList = skuIdLadderListMap.get(skuPo.getSkuId());
            if (CollectionUtil.isNotEmpty(ladderPricePOList)) {
                HSSFCell cell9 = row.createCell(9 + offset);
                cell9.setCellStyle(white);
                String ladPriceStr = ladderPricePOList.stream().map(e -> MoneyUtils.haoToYuan((Long)e.getStart()) + "-" + (ObjectUtil.isNull((Object)e.getStop()) || e.getStop() < 0L ? "\u221e" : MoneyUtils.haoToYuan((Long)e.getStop()).toString())).collect(Collectors.joining(";"));
                cell9.setCellValue(ladPriceStr);
            }
            if (ObjectUtil.isNotNull((Object)uccSkuPricePo)) {
                HSSFCell cell10 = row.createCell(10 + offset);
                cell10.setCellStyle(white);
                if (ObjectUtil.isNotNull((Object)uccSkuPricePo.getSalePrice())) {
                    cell10.setCellValue(MoneyUtils.haoToYuan((Long)uccSkuPricePo.getSalePrice()).toString());
                }
            }
            if (ObjectUtil.isNotNull((Object)skuPo.getMoq())) {
                HSSFCell cell11 = row.createCell(11 + offset);
                cell11.setCellStyle(white);
                cell11.setCellValue(skuPo.getMoq().setScale(BigDecimal.ZERO.intValue(), RoundingMode.HALF_UP).toString());
            }
            if (StrUtil.isNotEmpty((CharSequence)skuPo.getSettlementUnit())) {
                HSSFCell cell12 = row.createCell(12 + offset);
                cell12.setCellStyle(backGroundcellStyle);
                cell12.setCellValue(skuPo.getSettlementUnit());
            }
            if (StrUtil.isNotEmpty((CharSequence)skuPo.getSalesUnitName())) {
                HSSFCell cell13 = row.createCell(13 + offset);
                cell13.setCellStyle(white);
                cell13.setCellValue(skuPo.getSalesUnitName());
            }
            HSSFCell cell14 = row.createCell(14 + offset);
            cell14.setCellStyle(white);
            cell14.setCellValue(ObjectUtil.isNull((Object)skuPo.getSalesUnitRate()) ? "" : skuPo.getSalesUnitRate().setScale(BigDecimal.ZERO.intValue(), RoundingMode.HALF_UP).toString());
            HSSFCell cell15 = row.createCell(15 + offset);
            cell15.setCellStyle(white);
            cell15.setCellValue(onShelveWayMap.get(skuPo.getOnShelveWay()));
            if (ObjectUtil.isNotNull((Object)skuPo.getOnShelveTime())) {
                HSSFCell cell16 = row.createCell(16 + offset);
                cell16.setCellStyle(white);
                cell16.setCellValue(DateUtil.formatDateTime((Date)skuPo.getOnShelveTime()));
            }
            if (ObjectUtil.isNotNull((Object)(uccCommodityServicePO = spuIdServiceMap.get(skuPo.getCommodityId())).getRejectAllow())) {
                HSSFCell cell17 = row.createCell(17 + offset);
                cell17.setCellStyle(white);
                cell17.setCellValue(RejectAllowEnum.valueOfCode((Integer)uccCommodityServicePO.getRejectAllow()).value);
            }
            if (ObjectUtil.isNotNull((Object)uccCommodityServicePO.getRejectAllowDate())) {
                HSSFCell cell18 = row.createCell(18 + offset);
                cell18.setCellStyle(white);
                cell18.setCellValue((double)uccCommodityServicePO.getRejectAllowDate().intValue());
            }
            if (ObjectUtil.isNotNull((Object)uccCommodityServicePO.getExchangeAllow())) {
                HSSFCell cell19 = row.createCell(19 + offset);
                cell19.setCellStyle(white);
                cell19.setCellValue(RejectAllowEnum.valueOfCode(uccCommodityServicePO.getExchangeAllow()).getValue());
            }
            if (ObjectUtil.isNotNull((Object)uccCommodityServicePO.getExchangeAllowDate())) {
                HSSFCell cell20 = row.createCell(20 + offset);
                cell20.setCellStyle(white);
                cell20.setCellValue((double)uccCommodityServicePO.getExchangeAllowDate().intValue());
            }
            if (ObjectUtil.isNotNull((Object)uccCommodityServicePO.getMaintainAllow())) {
                HSSFCell cell21 = row.createCell(21 + offset);
                cell21.setCellStyle(white);
                cell21.setCellValue(RejectAllowEnum.valueOfCode(uccCommodityServicePO.getMaintainAllow()).getValue());
            }
            if (ObjectUtil.isNotNull((Object)uccCommodityServicePO.getMaintainAllowDate())) {
                HSSFCell cell22 = row.createCell(22 + offset);
                cell22.setCellStyle(white);
                cell22.setCellValue((double)uccCommodityServicePO.getMaintainAllowDate().intValue());
            }
            if (!ObjectUtil.isNotNull((Object)(uccCommodityServiceReturnPO = spuIdReturnMap.get(skuPo.getCommodityId())))) continue;
            HSSFCell cell23 = row.createCell(23 + offset);
            cell23.setCellStyle(white);
            cell23.setCellValue(ReturnTypeEnum.valueOfCode(uccCommodityServiceReturnPO.getReturnType()).getValue());
        }
    }

    private CellStyle getCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle backGroundcellStyle = workbook.createCellStyle();
        backGroundcellStyle.setLocked(true);
        backGroundcellStyle.setWrapText(true);
        backGroundcellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        backGroundcellStyle.setAlignment(HorizontalAlignment.CENTER);
        HSSFColor customColor = workbook.getCustomPalette().findSimilarColor(255, 204, 0);
        short colorIndex = customColor.getIndex();
        backGroundcellStyle.setFillForegroundColor(colorIndex);
        backGroundcellStyle.setBorderTop(BorderStyle.THIN);
        backGroundcellStyle.setBorderBottom(BorderStyle.THIN);
        backGroundcellStyle.setBorderLeft(BorderStyle.THIN);
        backGroundcellStyle.setBorderRight(BorderStyle.THIN);
        backGroundcellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)11);
        backGroundcellStyle.setFont((Font)font);
        return backGroundcellStyle;
    }

    public static enum ReturnTypeEnum {
        HOME(1, "\u4e0a\u95e8\u53d6\u4ef6"),
        SEND(2, "\u5ba2\u6237\u5bc4\u56de");

        final Integer code;
        final String value;

        private ReturnTypeEnum(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public static ReturnTypeEnum valueOfCode(Integer code) {
            return Arrays.stream(ReturnTypeEnum.values()).filter(e -> e.code.equals(code)).findAny().orElse(null);
        }

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum RejectAllowEnum {
        NO(0, "\u5426"),
        YES(1, "\u662f");

        final Integer code;
        final String value;

        private RejectAllowEnum(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public static RejectAllowEnum valueOfCode(Integer code) {
            return Arrays.stream(RejectAllowEnum.values()).filter(e -> e.code.equals(code)).findAny().orElse(null);
        }

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }
    }
}

