/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBrandAddReqBO;
import com.tydic.commodity.base.bo.UccBrandAddRspBO;
import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.base.bo.UccSkuCreateNewInfoBO;
import com.tydic.commodity.base.bo.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.UccOnthecommoditypoolsAbilityService;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuInfoBO;
import com.tydic.commodity.busibase.atom.bo.UccOnthecommoditypoolsAbilityReqBO;
import com.tydic.commodity.busibase.atom.bo.UccOnthecommoditypoolsAbilityRspBO;
import com.tydic.commodity.busibase.busi.api.UccAgrSpuCreateaBusiService;
import com.tydic.commodity.busibase.busi.api.UccBrandAddBusiService;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.busibase.busi.api.UccSpuCacheCreateBusiService;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiReqBo;
import com.tydic.commodity.busibase.busi.bo.UccSpuCreateaBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSpuCreateaBusiRspBO;
import com.tydic.commodity.busibase.comb.api.UccSkuBatchAddRecordCombService;
import com.tydic.commodity.busibase.comb.bo.UccSkuBatchAddRecordCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuBatchAddRecordCombRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccMallBrandDetaillListPO;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrSpuCreateaNewAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSpuCreateaNewAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSpuCreateaNewAbilityRspBO;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrSpuCreateaNewAbilityService"})
public class UccAgrSpuCreateaNewAbilityServiceImpl
implements UccAgrSpuCreateaNewAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrSpuCreateaNewAbilityServiceImpl.class);
    @Autowired
    private UccAgrSpuCreateaBusiService uccAgrSpuCreateaBusiService;
    @Autowired
    private UccOnthecommoditypoolsAbilityService uccOnthecommoditypoolsAbilityService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private UccBrandAddBusiService uccBrandAddBusiService;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccOrgAgrWhiteRestrictionBusiService uccOrgAgrWhiteRestrictionBusiService;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccSpuCacheCreateBusiService uccSpuCacheCreateBusiService;
    @Autowired
    private UccSkuBatchAddRecordCombService uccSkuBatchAddRecordCombService;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    public static final Integer CREATE_TYPE_NO_AGR_ITEM = 2;

    @PostMapping(value={"dealAgrSpuCreate"})
    public UccAgrSpuCreateaNewAbilityRspBO dealAgrSpuCreate(@RequestBody UccAgrSpuCreateaNewAbilityReqBO reqBO) {
        log.info("\u534f\u8bae\u521b\u5efa\u5546\u54c1\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)reqBO));
        this.val(reqBO);
        this.dealBrand(reqBO);
        this.dealStock(reqBO);
        UccSpuCreateaBusiReqBO spuCreateBusiReqBO = this.getUccSpuCreateaBusiReqBO(reqBO);
        UccSpuCreateaBusiRspBO uccSpuCreateaBusiRspBO = this.createCommodity(reqBO, spuCreateBusiReqBO);
        this.insertAgrWhiteList(reqBO, uccSpuCreateaBusiRspBO);
        this.linkCommodityPool(reqBO, uccSpuCreateaBusiRspBO);
        this.sendAgr(reqBO);
        this.syncEs(reqBO, spuCreateBusiReqBO, uccSpuCreateaBusiRspBO);
        this.createApproveTask(reqBO, spuCreateBusiReqBO, uccSpuCreateaBusiRspBO);
        return (UccAgrSpuCreateaNewAbilityRspBO)JUtil.js((Object)uccSpuCreateaBusiRspBO, UccAgrSpuCreateaNewAbilityRspBO.class);
    }

    private void createApproveTask(UccAgrSpuCreateaNewAbilityReqBO reqBO, UccSpuCreateaBusiReqBO spuCreateBusiReqBO, UccSpuCreateaBusiRspBO uccSpuCreateaBusiRspBO) {
        if (reqBO.getOperType() == 1) {
            this.syncEs(uccSpuCreateaBusiRspBO);
            UccSkuBatchAddRecordCombReqBO uccSkuBatchAddRecordCombReqBO = (UccSkuBatchAddRecordCombReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UccSkuBatchAddRecordCombReqBO.class);
            ArrayList<UccSkuBatchAddRecordBO> batchObjList = new ArrayList<UccSkuBatchAddRecordBO>();
            UccSkuBatchAddRecordBO bo = new UccSkuBatchAddRecordBO();
            bo.setObjId(uccSpuCreateaBusiRspBO.getCommodityId());
            bo.setSupplierShopId(spuCreateBusiReqBO.getSupplierShopId());
            batchObjList.add(bo);
            uccSkuBatchAddRecordCombReqBO.setBatchObjList(batchObjList);
            uccSkuBatchAddRecordCombReqBO.setObjType(UccConstants.BatchObjType.COMMODITY);
            uccSkuBatchAddRecordCombReqBO.setDealType(UccConstants.BatchDealType.COMM_EDIT_SUBMIT);
            uccSkuBatchAddRecordCombReqBO.setSource(spuCreateBusiReqBO.getCommoditySource());
            UccSkuBatchAddRecordCombRspBO uccSkuBatchAddRecordCombRspBO = this.uccSkuBatchAddRecordCombService.addRecrod(uccSkuBatchAddRecordCombReqBO);
            if (!"0000".equals(uccSkuBatchAddRecordCombRspBO.getRespCode())) {
                throw new BusinessException(uccSkuBatchAddRecordCombRspBO.getRespCode(), uccSkuBatchAddRecordCombRspBO.getRespDesc());
            }
        }
    }

    private void syncEs(UccAgrSpuCreateaNewAbilityReqBO reqBO, UccSpuCreateaBusiReqBO spuCreateBusiReqBO, UccSpuCreateaBusiRspBO uccSpuCreateaBusiRspBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSpuInfo().getSkuCreateInfo())) {
            if (!reqBO.getOperType().equals(1)) {
                String esId = "cache" + uccSpuCreateaBusiRspBO.getCommodityId();
                this.elasticsearchUtil.deleteData(this.esConfig.getIndexName(), esId);
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(Collections.singletonList(uccSpuCreateaBusiRspBO.getCommodityId()));
                syncSceneCommodityToEsReqBO.setSupplierId(uccSpuCreateaBusiRspBO.getSupplierShopId());
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        } else {
            this.syncCommodityInfoToEs(spuCreateBusiReqBO, uccSpuCreateaBusiRspBO.getCommodityId());
        }
    }

    private void linkCommodityPool(UccAgrSpuCreateaNewAbilityReqBO reqBO, UccSpuCreateaBusiRspBO uccSpuCreateaBusiRspBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSpuInfo().getPools())) {
            UccOnthecommoditypoolsAbilityReqBO uccOnthecommoditypoolsAbilityReqBO = new UccOnthecommoditypoolsAbilityReqBO();
            ArrayList<Long> commodityIDs = new ArrayList<Long>();
            commodityIDs.add(uccSpuCreateaBusiRspBO.getCommodityId());
            uccOnthecommoditypoolsAbilityReqBO.setSourceList(commodityIDs);
            uccOnthecommoditypoolsAbilityReqBO.setPoolRelated(Integer.valueOf(5));
            uccOnthecommoditypoolsAbilityReqBO.setPools(reqBO.getSpuInfo().getPools());
            UccOnthecommoditypoolsAbilityRspBO uccOnthecommoditypoolsAbilityRspBO = this.uccOnthecommoditypoolsAbilityService.dealUccOnthecommoditypools(uccOnthecommoditypoolsAbilityReqBO);
            if (!uccOnthecommoditypoolsAbilityRspBO.getRespCode().equals("0000")) {
                log.debug("\u5173\u8054\u5546\u54c1\u6c60\u51fa\u9519\uff1a" + uccOnthecommoditypoolsAbilityRspBO.getRespDesc());
            }
        }
    }

    private void sendAgr(UccAgrSpuCreateaNewAbilityReqBO reqBO) {
        try {
            UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
            notifyMessageBO.setAuditStatus("0");
            notifyMessageBO.setStationCode("0");
            notifyMessageBO.setAgreementId(reqBO.getSpuInfo().getAgreementId().toString());
            if (!CREATE_TYPE_NO_AGR_ITEM.equals(reqBO.getCreateType())) {
                notifyMessageBO.setAgreementSkuIds((List)Lists.newArrayList((Object[])new String[]{reqBO.getSpuInfo().getAgreementDetailsId().toString()}));
            }
            notifyMessageBO.setAgreementSkuStatus("0");
            notifyMessageBO.setMemIdIn(reqBO.getUserId());
            notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_UP_SHELF.code());
            log.info("\u521b\u5efa\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
            this.zoneGoodsAuditMQ.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TOPIC"), PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
        }
        catch (Exception var16) {
            log.error("\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
            throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
        }
    }

    private UccSpuCreateaBusiRspBO createCommodity(UccAgrSpuCreateaNewAbilityReqBO reqBO, UccSpuCreateaBusiReqBO spuCreateBusiReqBO) {
        UccSpuCreateaBusiRspBO uccSpuCreateaBusiRspBO;
        if (reqBO.getOperType() != 2) {
            if (reqBO.getOperType() == 1) {
                spuCreateBusiReqBO.setSubmitTime(new Date());
            }
            uccSpuCreateaBusiRspBO = this.uccAgrSpuCreateaBusiService.dealAgrSpuCreate(spuCreateBusiReqBO);
        } else {
            uccSpuCreateaBusiRspBO = this.uccSpuCacheCreateBusiService.dealAgrSpuCreate(spuCreateBusiReqBO);
        }
        if (!"0000".equals(uccSpuCreateaBusiRspBO.getRespCode())) {
            throw new BusinessException(uccSpuCreateaBusiRspBO.getRespCode(), uccSpuCreateaBusiRspBO.getRespDesc());
        }
        return uccSpuCreateaBusiRspBO;
    }

    private void dealStock(UccAgrSpuCreateaNewAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getSpuInfo().getStoreGetType())) {
            reqBO.getSpuInfo().setStoreGetType("1");
        }
    }

    private void dealBrand(UccAgrSpuCreateaNewAbilityReqBO reqBO) {
        block5: {
            if (reqBO.getSpuInfo().getBrandId() != null || !StringUtils.hasText((String)reqBO.getSpuInfo().getBrandName())) break block5;
            List mallBrandListAccurate = this.uccBrandExtMapper.getMallBrandListAccurate(reqBO.getSpuInfo().getBrandName());
            if (CollectionUtils.isEmpty((Collection)mallBrandListAccurate)) {
                UccBrandAddReqBO brandAddReqBO = new UccBrandAddReqBO();
                brandAddReqBO.setBrandName(reqBO.getSpuInfo().getBrandName());
                brandAddReqBO.setBrandStatus(Integer.valueOf(1));
                brandAddReqBO.setCreateOperId(reqBO.getUsername());
                UccBrandAddRspBO uccBrandAddRspBO = this.uccBrandAddBusiService.addBrand(brandAddReqBO);
                if (!"0000".equals(uccBrandAddRspBO.getRespCode())) {
                    throw new BusinessException(uccBrandAddRspBO.getRespCode(), uccBrandAddRspBO.getRespDesc());
                }
                reqBO.getSpuInfo().setBrandId(uccBrandAddRspBO.getBrandId());
                for (UccSkuCreateNewInfoBO each : reqBO.getSpuInfo().getSkuCreateInfo()) {
                    each.setBrandId(uccBrandAddRspBO.getBrandId());
                }
            } else {
                reqBO.getSpuInfo().setBrandId(((UccMallBrandDetaillListPO)mallBrandListAccurate.get(0)).getBrandId());
                for (UccSkuCreateNewInfoBO each : reqBO.getSpuInfo().getSkuCreateInfo()) {
                    each.setBrandId(((UccMallBrandDetaillListPO)mallBrandListAccurate.get(0)).getBrandId());
                }
            }
        }
    }

    private UccSpuCreateaBusiReqBO getUccSpuCreateaBusiReqBO(UccAgrSpuCreateaNewAbilityReqBO reqBO) {
        for (UccSkuCreateNewInfoBO each : reqBO.getSpuInfo().getSkuCreateInfo()) {
            each.setSkuSource(reqBO.getSpuInfo().getCommoditySource());
            if (reqBO.getOperType() == 2) {
                each.setSkuStatus(SkuStatusConstants.SKU_STATUS_TEMP);
            } else {
                each.setSkuStatus(reqBO.getSpuInfo().getCommodityStatus());
            }
            if (each.getAgreementId() == null) {
                each.setAgreementId(reqBO.getSpuInfo().getAgreementId());
            }
            if (each.getAgrType() == null) {
                each.setAgrType(reqBO.getSpuInfo().getAgrType());
            }
            if (CREATE_TYPE_NO_AGR_ITEM.equals(reqBO.getCreateType()) || each.getAgreementDetailsId() != null) continue;
            each.setAgreementDetailsId(reqBO.getSpuInfo().getAgreementDetailsId());
        }
        UccSpuCreateaBusiReqBO spuCreateaABusiReqBO = (UccSpuCreateaBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO.getSpuInfo()), UccSpuCreateaBusiReqBO.class);
        spuCreateaABusiReqBO.setOrgId(reqBO.getOrgId());
        spuCreateaABusiReqBO.setOrgIdIn(reqBO.getOrgIdIn());
        spuCreateaABusiReqBO.setOrgName(reqBO.getOrgName());
        spuCreateaABusiReqBO.setOrgPath(reqBO.getOrgPath());
        spuCreateaABusiReqBO.setUserId(reqBO.getUserId());
        spuCreateaABusiReqBO.setUsername(reqBO.getUsername());
        spuCreateaABusiReqBO.setMemIdIn(reqBO.getMemIdIn());
        spuCreateaABusiReqBO.setCellphone(reqBO.getCellphone());
        spuCreateaABusiReqBO.setWhilteRestrict(reqBO.getWhilteRestrict());
        return spuCreateaABusiReqBO;
    }

    private void val(UccAgrSpuCreateaNewAbilityReqBO reqBO) {
        String checkStr;
        if (reqBO.getOperType() != 2 && !StringUtils.isEmpty((Object)(checkStr = this.verify(reqBO)))) {
            throw new BusinessException("8888", checkStr);
        }
        if (!CREATE_TYPE_NO_AGR_ITEM.equals(reqBO.getCreateType())) {
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setAgreementDetailsId(reqBO.getSpuInfo().getAgreementDetailsId().toString());
            List poList = this.uccCommodityMapper.qryCommodity(uccCommodityPo);
            if (!CollectionUtils.isEmpty((Collection)poList)) {
                throw new BusinessException("8888", reqBO.getSpuInfo().getAgreementDetailsId() + "\u5df2\u7ecf\u5b9e\u4f8b\u5546\u54c1\u6570\u636e");
            }
        }
    }

    private void syncEs(UccSpuCreateaBusiRspBO busiRspBo) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setCommodityIds(Collections.singletonList(busiRspBo.getCommodityId()));
        syncSceneCommodityToEsReqBO.setSupplierId(busiRspBo.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
    }

    private void syncCommodityInfoToEs(UccSpuCreateaBusiReqBO reqBO, Long commodityId) {
        EsStorageSpuInfoBO esStorageSpuInfoBO = new EsStorageSpuInfoBO();
        esStorageSpuInfoBO.setCommodity_id(commodityId);
        esStorageSpuInfoBO.setCommodity_code(reqBO.getCommodityCode());
        esStorageSpuInfoBO.setCommodity_name(reqBO.getCommodityName());
        esStorageSpuInfoBO.setSpu_approval_status(null);
        esStorageSpuInfoBO.setCommodity_status(reqBO.getCommodityStatus());
        esStorageSpuInfoBO.setVendor_id(reqBO.getVendorId());
        esStorageSpuInfoBO.setVendor_name(reqBO.getVendorName());
        esStorageSpuInfoBO.setOther_source_name(reqBO.getOtherSourceName());
        esStorageSpuInfoBO.setOther_source_id(reqBO.getOtherSourceId());
        esStorageSpuInfoBO.setOther_source_code(reqBO.getOtherSourceCode());
        if (!ObjectUtils.isEmpty((Object)reqBO.getSpuExpand())) {
            esStorageSpuInfoBO.setCommodity_expand1(reqBO.getSpuExpand().getCommodityExpand1());
        }
        esStorageSpuInfoBO.setBrand_id(reqBO.getBrandId());
        esStorageSpuInfoBO.setBrand_name(reqBO.getBrandName());
        if (reqBO.getCommodityTypeId() != null) {
            esStorageSpuInfoBO.setType_id(reqBO.getCommodityTypeId());
            UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId());
            if (uccCommodityTypePo != null) {
                esStorageSpuInfoBO.setType_name(uccCommodityTypePo.getCommodityTypeName());
            }
        }
        esStorageSpuInfoBO.setSku_source(reqBO.getCommoditySource());
        esStorageSpuInfoBO.setSupplier_shop_id(reqBO.getSupplierShopId());
        esStorageSpuInfoBO.setShop_name(reqBO.getShopName());
        esStorageSpuInfoBO.setSupplier_org_id(reqBO.getOrgIdIn().toString());
        esStorageSpuInfoBO.setSupplier_org_name(reqBO.getOrgName());
        esStorageSpuInfoBO.setSupplier_org_path(reqBO.getOrgPath());
        esStorageSpuInfoBO.setCreate_oper_id(reqBO.getUserId().toString());
        esStorageSpuInfoBO.setCreate_oper_name(reqBO.getUsername());
        esStorageSpuInfoBO.setCreate_time(Long.valueOf(new Date().getTime()));
        String jsonStr = JSONObject.toJSONString((Object)esStorageSpuInfoBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        log.info("\u5546\u54c1\u6682\u5b58\u540c\u6b65ES\u6570\u636e" + jsonStr);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String esId = "cache" + esStorageSpuInfoBO.getCommodity_id().toString();
        String id = this.elasticsearchUtil.addData(this.esConfig.getIndexName(), this.esConfig.getEsType(), esId, jsonObject);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
            log.error(esStorageSpuInfoBO.getScene_id() + "|" + esStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }

    String verify(UccAgrSpuCreateaNewAbilityReqBO reqBO) {
        if (!CREATE_TYPE_NO_AGR_ITEM.equals(reqBO.getCreateType()) && reqBO.getSpuInfo().getAgreementDetailsId() == null) {
            return "\u534f\u8bae\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getSpuInfo().getCommodityCode() == null) {
            return "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getSpuInfo().getTaxCatCode())) {
            return "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getSpuInfo().getRate() == null) {
            return "\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getSpuInfo().getPackParam())) {
            return "\u5305\u88c5\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getSpuInfo().getCommodityName())) {
            return "\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getSpuInfo().getCommodityPcDetailUrl())) {
            return "\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSpuInfo().getSpuImages())) {
            return "\u5546\u54c1\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getSpuInfo().getCommodityTypeId())) {
            return "\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getSpuInfo().getAgreementId() == null) {
            return "\u534f\u8baeID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSpuInfo().getSkuCreateInfo())) {
            return "\u5355\u54c1\u4fe1\u606f\u4e0d\u80fd\u7a7a";
        }
        for (UccSkuCreateNewInfoBO createInfoBO : reqBO.getSpuInfo().getSkuCreateInfo()) {
            if (StringUtils.isEmpty((Object)createInfoBO.getSkuName())) {
                return "\u5355\u54c1\u540d\u79f0\u4e0d\u7a7a";
            }
            if (StringUtils.isEmpty((Object)createInfoBO.getSkuCode())) {
                return "\u5355\u54c1\u7f16\u7801\u4e0d\u4e3a\u7a7a";
            }
            if (createInfoBO.getMaterialId() == null) {
                return "\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (CollectionUtils.isEmpty((Collection)createInfoBO.getSkuImages())) {
                return "\u5355\u54c1\u56fe\u7247\u4e0d\u4e3a\u7a7a";
            }
            if (createInfoBO.getMeasureId() == null) {
                return "\u5355\u54c1\u8ba1\u91cf\u5355\u4f4d\u4e0d\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)createInfoBO.getBrandName())) {
                return "\u5355\u54c1\u54c1\u724c\u4e0d\u4e3a\u7a7a";
            }
            if (createInfoBO.getMoq() == null) {
                return "\u6700\u5c0f\u542f\u5b9a\u91cf\u4e0d\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)createInfoBO.getSettlementUnit())) {
                return "\u7ed3\u7b97\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)createInfoBO.getSalesUnitId())) {
                return "\u5305\u88c5\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)createInfoBO.getSalesUnitName())) {
                return "\u5305\u88c5\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (createInfoBO.getSalesUnitRate() == null) {
                return "\u5305\u88c5\u8f6c\u6362\u7387\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (createInfoBO.getSkuSource() == null) {
                createInfoBO.setSkuSource(ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION);
            }
            if (createInfoBO.getSkuStatus() == null) {
                createInfoBO.setSkuStatus(ModelRuleConstant.SKU_STATUS_DRAFT);
            }
            if (createInfoBO.getAgreementId() == null) {
                createInfoBO.setAgreementId(reqBO.getSpuInfo().getAgreementId());
            }
            if (CREATE_TYPE_NO_AGR_ITEM.equals(reqBO.getCreateType()) || createInfoBO.getAgreementDetailsId() != null) continue;
            createInfoBO.setAgreementDetailsId(reqBO.getSpuInfo().getAgreementDetailsId());
        }
        return null;
    }

    private void insertAgrWhiteList(UccAgrSpuCreateaNewAbilityReqBO reqBO, UccSpuCreateaBusiRspBO uccSpuCreateaBusiRspBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getWhilteRestrict())) {
            ArrayList<UccOrgSkuWhiteRestrictionBo> uccOrgSkuWhiteRestrictionBos = new ArrayList<UccOrgSkuWhiteRestrictionBo>();
            for (Long each : reqBO.getWhilteRestrict()) {
                UccOrgSkuWhiteRestrictionBo uccOrgSkuWhiteRestrictionPo = new UccOrgSkuWhiteRestrictionBo();
                uccOrgSkuWhiteRestrictionPo.setAgreementId(reqBO.getSpuInfo().getAgreementId());
                uccOrgSkuWhiteRestrictionPo.setSupplierShopId(uccSpuCreateaBusiRspBO.getSupplierShopId());
                uccOrgSkuWhiteRestrictionPo.setSkuSource(3);
                uccOrgSkuWhiteRestrictionPo.setCreateOperId(Convert.toStr((Object)reqBO.getUserId()));
                uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(this.sequence.nextId()));
                uccOrgSkuWhiteRestrictionPo.setOrgId(each);
                uccOrgSkuWhiteRestrictionPo.setOrgTreePath(each.toString());
                uccOrgSkuWhiteRestrictionPo.setStatus(1);
                uccOrgSkuWhiteRestrictionPo.setCommodityId(uccSpuCreateaBusiRspBO.getCommodityId());
                uccOrgSkuWhiteRestrictionBos.add(uccOrgSkuWhiteRestrictionPo);
            }
            UccOrgSkuWhiteRestrictionBusiReqBo uccOrgSkuWhiteRestrictionBusiReqBo = new UccOrgSkuWhiteRestrictionBusiReqBo();
            uccOrgSkuWhiteRestrictionBusiReqBo.setWhites(uccOrgSkuWhiteRestrictionBos);
            try {
                this.uccOrgAgrWhiteRestrictionBusiService.dealWhite(uccOrgSkuWhiteRestrictionBusiReqBo);
            }
            catch (Exception e) {
                log.error("\u534f\u8bae\u53d1\u5e03\u8303\u56f4\u65b0\u589e\u5931\u8d25", (Throwable)e);
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
    }
}

