/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.atom.impl;

import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ComBatchDealObjPO;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.atom.api.UccChangeStatusAtomService;
import com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoReqBo;
import com.tydic.osworkflow.ability.OsworkflowRuntimeProcInstHandleAbilityService;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccChangeStatusAtomServiceImpl
implements UccChangeStatusAtomService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private OsworkflowRuntimeProcInstHandleAbilityService osworkflowRuntimeProcInstHandleAbilityService;
    @Autowired
    private UmcSendRevokeTodoService umcSendRevokeTodoService;

    @Override
    public void changeCommod(AgrMessageBo reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds()) && CollectionUtils.isEmpty((Collection)reqBO.getAgreementSkuIds())) {
            throw new BusinessException("8888", "\u534f\u8bae\u6d88\u606fid\u6216\u8005\u660e\u7ec6id\u5168\u4e3a\u7a7a\uff01");
        }
        try {
            Integer count = this.uccSkuMapper.checkCountByAgreementIds(reqBO.getAgreementIds());
            if (count > 0) {
                if (UccConstants.AgrStatusChangeType.FREZE.equals(reqBO.getChangeType())) {
                    List<ComBatchDealObjPO> comBatchDealObjPOList = this.getOrderIds(reqBO);
                    this.freeze(reqBO);
                    this.stopProcInst(reqBO, comBatchDealObjPOList);
                }
                if (UccConstants.AgrStatusChangeType.THAW.equals(reqBO.getChangeType())) {
                    this.thaw(reqBO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u66f4\u65b0\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private void thaw(AgrMessageBo reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds())) {
            this.uccSkuMapper.revertSkuByAgreementIds(reqBO.getAgreementIds());
            this.uccSkuMapper.revertCommodityStatusByAgreementIds(reqBO.getAgreementIds());
        }
    }

    private void stopProcInst(AgrMessageBo reqBO, List<ComBatchDealObjPO> comBatchDealObjPOList) {
        if (!CollectionUtils.isEmpty(comBatchDealObjPOList)) {
            List orderIds = comBatchDealObjPOList.stream().map(ComBatchDealObjPO::getOrderId).distinct().collect(Collectors.toList());
            this.eacRuTaskMapper.revokeAuditTask(orderIds);
            List approveInstIds = comBatchDealObjPOList.stream().map(ComBatchDealObjPO::getApproveInstId).distinct().collect(Collectors.toList());
            for (String approveInstId : approveInstIds) {
                DeleteProcInstSingleReqBO deleteProcInstSingleReqBO = new DeleteProcInstSingleReqBO();
                deleteProcInstSingleReqBO.setProcInstId(approveInstId);
                this.osworkflowRuntimeProcInstHandleAbilityService.deleteProcInstSingle(deleteProcInstSingleReqBO);
            }
            for (ComBatchDealObjPO comBatchDealObjPO : comBatchDealObjPOList) {
                UmcSendRevokeTodoReqBo umcSendRevokeTodoReqBo = new UmcSendRevokeTodoReqBo();
                umcSendRevokeTodoReqBo.setBusiId(comBatchDealObjPO.getApproveInstId() + "-" + comBatchDealObjPO.getTaskId());
                umcSendRevokeTodoReqBo.setOperUserId(reqBO.getOperId());
                umcSendRevokeTodoReqBo.setOperUserName(reqBO.getOperName());
                this.umcSendRevokeTodoService.revokeTodo(umcSendRevokeTodoReqBo);
            }
        }
    }

    @NotNull
    private List<ComBatchDealObjPO> getOrderIds(AgrMessageBo reqBO) {
        List commodityObjPos;
        ArrayList<ComBatchDealObjPO> comBatchDealObjPOList = new ArrayList<ComBatchDealObjPO>();
        List skuObjPos = this.uccSkuMapper.qryAgrSkuAuditOrderList(reqBO.getAgreementIds());
        if (!CollectionUtils.isEmpty((Collection)skuObjPos)) {
            comBatchDealObjPOList.addAll(skuObjPos);
        }
        if (!CollectionUtils.isEmpty((Collection)(commodityObjPos = this.uccSkuMapper.qryAgrCommodityAuditOrderList(reqBO.getAgreementIds())))) {
            comBatchDealObjPOList.addAll(commodityObjPos);
        }
        return comBatchDealObjPOList;
    }

    private void freeze(AgrMessageBo reqBO) {
        this.uccSkuMapper.freezeSkuByAgreementIdsAudit(reqBO.getAgreementIds());
        this.uccSkuMapper.freezeSkuByAgreementIdsNotAudit(reqBO.getAgreementIds());
        this.uccSkuMapper.freezeCommodityByAgreementIdsAudit(reqBO.getAgreementIds());
        this.uccSkuMapper.freezeCommodityByAgreementIdsNotAudit(reqBO.getAgreementIds());
    }
}

