/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SkuChangePriceBO;
import com.tydic.commodity.base.bo.SkuPriceBo;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPriceModifyAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStateChangeSyncOoocAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceReqBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceRspBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuStateChangeBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuStateChangeSyncOoocAtomServiceReqBo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccGoodsPriceChangeLogMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccGoodsPriceChangeLogPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccOrgSkuWhiteRestrictionPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.ability.bo.UccUpdateSaleNumBo;
import com.tydic.commodity.zone.ability.bo.UccUpdateSalesVolumeBO;
import com.tydic.commodity.zone.atom.api.UccChangeStatusAtomService;
import com.tydic.commodity.zone.busi.api.UccDealAgrMessageBusiService;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealAgrMessageBusiServiceImpl
implements UccDealAgrMessageBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccDealAgrMessageBusiServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccDealAgrMessageBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired(required=true)
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccGoodsPriceChangeLogMapper uccGoodsPriceChangeLogMapper;
    @Autowired
    private UccChangeStatusAtomService uccChangeStatusAtomService;
    @Autowired
    private UccSkuPriceModifyAtomService uccSkuPriceModifyAtomService;
    @Autowired
    private UccSkuStateChangeSyncOoocAtomService uccSkuStateChangeSyncOoocAtomService;
    @Value(value="${ucc.skuState.sync.oooc.type:2}")
    private Integer syncType;

    @Override
    public RspUccBo dealMessage(AgrMessageBo reqBO) {
        List uccOrgSkuWhiteRestrictionPos;
        List agrIds;
        RspUccBo rspBO = new RspUccBo();
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6570\u636e\uff1a" + JSON.toJSONString((Object)reqBO));
        if (UccConstants.AgrStatusChangeType.THAW.equals(reqBO.getChangeType()) || UccConstants.AgrStatusChangeType.FREZE.equals(reqBO.getChangeType())) {
            this.uccChangeStatusAtomService.changeCommod(reqBO);
            this.skuStateChangeSyncOooc(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds());
        }
        if (UccConstants.AgrStatusChangeType.SCOPE.equals(reqBO.getChangeType()) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getAgrScopeSyncBOs()) && !org.apache.commons.collections.CollectionUtils.isEmpty(agrIds = reqBO.getAgrScopeSyncBOs().stream().map(a -> a.getAgreementId()).collect(Collectors.toList())) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(uccOrgSkuWhiteRestrictionPos = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(agrIds, null, Integer.valueOf(1))))) {
            Set orgPaths = uccOrgSkuWhiteRestrictionPos.stream().filter(a -> !StringUtils.isEmpty((String)a.getOrgTreePath())).map(a -> a.getOrgTreePath()).collect(Collectors.toSet());
            this.uccOrgSkuWhiteRestrictionMapper.deleteListByAgr(agrIds, null);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(orgPaths)) {
                List uccOrgSkuWhiteRestrictionPoList = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(null, (List)Lists.newArrayList(orgPaths), Integer.valueOf(1));
                HashMap white = new HashMap();
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccOrgSkuWhiteRestrictionPoList)) {
                    Map<String, List<UccOrgSkuWhiteRestrictionPo>> orgPos = uccOrgSkuWhiteRestrictionPoList.stream().filter(a -> a.getAgreementId() != null).collect(Collectors.groupingBy(a -> a.getOrgTreePath()));
                    for (Map.Entry each : orgPos.entrySet()) {
                        List agrIdList = ((List)each.getValue()).stream().filter(a -> a.getAgreementId() != null).map(a -> a.getAgreementId()).collect(Collectors.toList());
                        white.put(each.getKey(), agrIdList);
                    }
                }
                for (String key : orgPaths) {
                    if (white.containsKey(key)) {
                        this.cacheClient.set(new StringBuffer("UCC_ORG_AGR_WHITELIST_RESTRICTION").append(key).toString(), white.get(key));
                        continue;
                    }
                    this.cacheClient.delete(new StringBuffer("UCC_ORG_AGR_WHITELIST_RESTRICTION").append(key).toString());
                }
            }
        }
        if (UccConstants.AgrStatusChangeType.PRICE.equals(reqBO.getChangeType()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List skuChangePriceBOS = reqBO.getSkuChangePriceBOs();
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            ArrayList<Long> agreementIds = new ArrayList<Long>();
            ArrayList<Long> agreementDetailIds = new ArrayList<Long>();
            for (SkuChangePriceBO skuChangePriceBO : skuChangePriceBOS) {
                List uccSkuPos;
                if (skuChangePriceBO.getCommiditySkuStatus() != null) {
                    this.uccSkuMapper.modifySkuByAgreement((List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementId()}), (List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementSkuId()}), skuChangePriceBO.getCommiditySkuStatus());
                    agreementIds.add(skuChangePriceBO.getAgreementId());
                    agreementDetailIds.add(skuChangePriceBO.getAgreementSkuId());
                    continue;
                }
                Long agreementId = null;
                String agreementDetailId = null;
                if (skuChangePriceBO.getAgreementId() != null) {
                    agreementId = skuChangePriceBO.getAgreementId();
                }
                if (skuChangePriceBO.getAgreementSkuId() != null) {
                    agreementDetailId = String.valueOf(skuChangePriceBO.getAgreementSkuId());
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailId(agreementId, Long.valueOf(agreementDetailId))))) continue;
                if (skuChangePriceBO.getBuyNumber() != null) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(skuChangePriceBO.getBuyNumber().longValue()));
                    smcsdkStockNumInfoBO.setSkuId(((UccSkuPo)uccSkuPos.get(0)).getSkuId().toString());
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                ArrayList<SkuPriceBo> skuPriceBos = new ArrayList<SkuPriceBo>();
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    SkuPriceBo skuPriceBo = new SkuPriceBo();
                    skuPriceBo.setSkuId(uccSkuPo.getSkuId());
                    skuPriceBo.setSalePrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                    skuPriceBo.setAgreementPrice(Long.valueOf(skuChangePriceBO.getBuyPrice().longValue()));
                    skuPriceBos.add(skuPriceBo);
                    try {
                        UccSkuPo uccSkuPo1 = new UccSkuPo();
                        uccSkuPo1.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPo1.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        if (skuChangePriceBO.getSalePrice() != null) {
                            uccSkuPo1.setSkuPrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                        }
                        this.uccSkuMapper.updateSku(uccSkuPo1);
                        BigDecimal salePrice = skuChangePriceBO.getSalePrice();
                        this.updateLadderPrice(uccSkuPo.getSkuId(), uccSkuPo.getSupplierShopId(), salePrice);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new BusinessException("8888", "\u4fee\u6539\u4ef7\u683c\u4fe1\u606f\u5931\u8d25");
                    }
                }
                this.updateSkuPrice(skuPriceBos);
            }
            this.skuStateChangeSyncOooc(agreementIds, agreementDetailIds);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(smcsdkStockNumInfoBOS)) {
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                smcsdkOperateStockNumReqBO.setOperateType("11");
                if (((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId() == null) {
                    smcsdkOperateStockNumReqBO.setObjectId("111111");
                } else {
                    smcsdkOperateStockNumReqBO.setObjectId(((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId().toString());
                }
                smcsdkOperateStockNumReqBO.setObjectType("20");
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                    }
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u5904\u7406\u6210\u529f");
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6210\u529f");
        return rspBO;
    }

    private void skuStateChangeSyncOooc(List<Long> agreementIds, List<Long> agreementDetailIds) {
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(agreementIds) && !org.apache.commons.collections.CollectionUtils.isEmpty(agreementDetailIds)) {
            List uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(agreementIds, agreementDetailIds);
            List skuStatuslist = uccSkuPos.stream().map(uccSkuPo -> {
                UccSkuStateChangeBo uccSkuStateChangeBo = new UccSkuStateChangeBo();
                uccSkuStateChangeBo.setChangeTime(DateUtil.now());
                uccSkuStateChangeBo.setSkuId(Convert.toStr((Object)uccSkuPo.getSkuId()));
                uccSkuStateChangeBo.setStatus(Convert.toStr((Object)uccSkuPo.getSkuStatus()));
                return uccSkuStateChangeBo;
            }).collect(Collectors.toList());
            UccSkuStateChangeSyncOoocAtomServiceReqBo uccSkuStateChangeSyncAtomServiceReqBo = new UccSkuStateChangeSyncOoocAtomServiceReqBo();
            uccSkuStateChangeSyncAtomServiceReqBo.setSkuStatuslist(skuStatuslist);
            uccSkuStateChangeSyncAtomServiceReqBo.setSyncType(this.syncType);
            this.uccSkuStateChangeSyncOoocAtomService.stateSyncOooc(uccSkuStateChangeSyncAtomServiceReqBo);
        }
    }

    private void updateSkuPrice(List<SkuPriceBo> skuPriceBos) {
        UccSkuPriceModifyAtomServiceReqBo uccSkuPriceModifyAtomServiceReqBo = new UccSkuPriceModifyAtomServiceReqBo();
        uccSkuPriceModifyAtomServiceReqBo.setChangeType(UccConstants.SkuPriceChangeType.NORMAL);
        uccSkuPriceModifyAtomServiceReqBo.setSkuPriceBos(skuPriceBos);
        UccSkuPriceModifyAtomServiceRspBo uccSkuPriceModifyAtomServiceRspBo = this.uccSkuPriceModifyAtomService.skuPriceChange(uccSkuPriceModifyAtomServiceReqBo);
        if (!"0000".equals(uccSkuPriceModifyAtomServiceRspBo.getRespCode())) {
            throw new BusinessException("8888", uccSkuPriceModifyAtomServiceRspBo.getRespDesc());
        }
    }

    private void addAgrPriceChangeLog(UccSkuPo uccSkuPo, SkuChangePriceBO skuChangePriceBO) {
        try {
            UccGoodsPriceChangeLogPO insertChangeLogPO = new UccGoodsPriceChangeLogPO();
            insertChangeLogPO.setPriceChangeLogId(Long.valueOf(Sequence.getInstance().nextId()));
            insertChangeLogPO.setSkuId(uccSkuPo.getSkuId());
            insertChangeLogPO.setCommodityId(uccSkuPo.getCommodityId());
            insertChangeLogPO.setSupplierShopId(uccSkuPo.getSupplierShopId());
            insertChangeLogPO.setChangeTime(new Date());
            insertChangeLogPO.setCurrentPrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
            UccSkuPricePo select = new UccSkuPricePo();
            select.setSkuId(uccSkuPo.getSkuId());
            UccSkuPricePo oldSkuPrice = this.uccSkuPriceMapper.querySkuPrice(select);
            if (!ObjectUtil.isEmpty((Object)oldSkuPrice)) {
                insertChangeLogPO.setOldPrice(oldSkuPrice.getSalePrice());
            }
            this.uccGoodsPriceChangeLogMapper.insert(insertChangeLogPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u65b0\u589e\u534f\u8bae\u4ef7\u683c\u65e5\u5fd7\u53d8\u5316\u8bb0\u5f55\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private void updateLadderPrice(Long skuId, Long supplierShopId, BigDecimal salePrice) {
        List uccLadderPriceList = this.uccLadderPriceMapper.selectBySkuId(skuId, supplierShopId);
        for (UccLadderPricePO uccLadderPrice : uccLadderPriceList) {
            UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
            BigDecimal discount = uccLadderPrice.getDiscount();
            if (discount == null) continue;
            BigDecimal price = discount.multiply(salePrice);
            uccLadderPricePO.setPrice(Long.valueOf(price.longValue()));
            uccLadderPricePO.setId(uccLadderPrice.getId());
            this.uccLadderPriceMapper.updateByExampleSelective(uccLadderPricePO);
        }
    }

    private void dealStock(UccUpdateSalesVolumeBO uccUpdateSaleNumBo) {
        if (uccUpdateSaleNumBo == null) {
            return;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccUpdateSaleNumBo.getSaleNumBos())) {
            return;
        }
        Map<Integer, List<UccUpdateSaleNumBo>> map = uccUpdateSaleNumBo.getSaleNumBos().stream().filter(a -> a.getIncOrDec() != null).collect(Collectors.groupingBy(UccUpdateSaleNumBo::getIncOrDec));
        if (!CollectionUtils.isEmpty(map)) {
            for (Map.Entry<Integer, List<UccUpdateSaleNumBo>> each : map.entrySet()) {
                List<UccUpdateSaleNumBo> uccUpdateSaleNumBos = each.getValue();
                ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
                for (UccUpdateSaleNumBo uccUpdateSaleNumBo1 : uccUpdateSaleNumBos) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setSkuId(uccUpdateSaleNumBo1.getSkuId().toString());
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(uccUpdateSaleNumBo1.getSoldNumber().longValue()));
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                if (each.getKey() == 1) {
                    smcsdkOperateStockNumReqBO.setOperateType("40");
                } else if (each.getKey() == 0) {
                    smcsdkOperateStockNumReqBO.setOperateType("11");
                }
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if ("0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                        continue;
                    }
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }
}

