/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SkuChangePriceBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiReqBo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.ability.bo.UccAgrScopeSyncBO;
import com.tydic.commodity.zone.busi.api.UccDealAgrMessageBusiService;
import com.tydic.commodity.zone.comb.api.UccDealAgrMessageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealAgrMessageServiceImpl
implements UccDealAgrMessageService {
    private static final Logger log = LoggerFactory.getLogger(UccDealAgrMessageServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccDealAgrMessageServiceImpl.class);
    @Autowired
    private UccDealAgrMessageBusiService uccDealAgrMessageBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    private static final String allRange = "*";
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccOrgAgrWhiteRestrictionBusiService uccOrgAgrWhiteRestrictionBusiService;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @Override
    public RspUccBo dealMessage(AgrMessageBo reqBO) {
        RspUccBo rspUccBo = this.uccDealAgrMessageBusiService.dealMessage(reqBO);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getAgrScopeSyncBOs())) {
            try {
                this.insertWhiteList(reqBO);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        try {
            this.dealSkuSyncEs(reqBO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return rspUccBo;
    }

    private void dealSkuSyncEs(AgrMessageBo reqBO) {
        List uccSkuPos;
        Map<Object, Object> groupBySupplier = new HashMap();
        if ((org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementIds()) || org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementSkuIds())) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds())))) {
            groupBySupplier = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List agreementDetailIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementSkuId).collect(Collectors.toList());
            List agreementIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementId).collect(Collectors.toList());
            List uccSkuPos2 = this.uccSkuMapper.selectByAgreementDetailIds(agreementIds, agreementDetailIds);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccSkuPos2)) {
                groupBySupplier = uccSkuPos2.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            }
        }
        for (Map.Entry entry : groupBySupplier.entrySet()) {
            List skuIds = ((List)entry.getValue()).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId((Long)entry.getKey());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                LOGGER.error("\u540c\u6b65\u5546\u54c1\u72b6\u6001\u548c\u4ef7\u683c\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
    }

    private void insertWhiteList(AgrMessageBo reqBO) {
        ArrayList<UccOrgSkuWhiteRestrictionBo> uccOrgSkuWhiteRestrictionBos = new ArrayList<UccOrgSkuWhiteRestrictionBo>();
        ArrayList agrASpu = new ArrayList();
        for (UccAgrScopeSyncBO uccAgrScopeSyncBO : reqBO.getAgrScopeSyncBOs()) {
            if (allRange.equals(uccAgrScopeSyncBO.getScopeCodes())) continue;
            List list = JSONObject.parseArray((String)uccAgrScopeSyncBO.getScopeCodes(), String.class);
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setAgreementId(uccAgrScopeSyncBO.getAgreementId().toString());
            List commodityPoList = this.uccCommodityMapper.qryCommodity(uccCommodityPo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)commodityPoList)) continue;
            agrASpu.addAll(commodityPoList);
            for (String each : list) {
                UccOrgSkuWhiteRestrictionBo uccOrgSkuWhiteRestrictionPo = new UccOrgSkuWhiteRestrictionBo();
                uccOrgSkuWhiteRestrictionPo.setAgreementId(uccAgrScopeSyncBO.getAgreementId());
                uccOrgSkuWhiteRestrictionPo.setSkuSource(3);
                uccOrgSkuWhiteRestrictionPo.setCreateOperId("message sync");
                uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(this.uccBatchSequence.nextId()));
                uccOrgSkuWhiteRestrictionPo.setOrgId(Long.valueOf(each));
                uccOrgSkuWhiteRestrictionPo.setOrgTreePath(each);
                uccOrgSkuWhiteRestrictionPo.setStatus(1);
                uccOrgSkuWhiteRestrictionBos.add(uccOrgSkuWhiteRestrictionPo);
            }
        }
        if (CollectionUtils.isEmpty(uccOrgSkuWhiteRestrictionBos)) {
            return;
        }
        UccOrgSkuWhiteRestrictionBusiReqBo uccOrgSkuWhiteRestrictionBusiReqBo = new UccOrgSkuWhiteRestrictionBusiReqBo();
        uccOrgSkuWhiteRestrictionBusiReqBo.setWhites(uccOrgSkuWhiteRestrictionBos);
        try {
            this.uccOrgAgrWhiteRestrictionBusiService.dealWhite(uccOrgSkuWhiteRestrictionBusiReqBo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        if (!CollectionUtils.isEmpty(agrASpu)) {
            Map<Long, List<UccCommodityPo>> agrSpu = agrASpu.stream().collect(Collectors.groupingBy(UccCommodityPo::getSupplierShopId));
            for (Long shopId : agrSpu.keySet()) {
                List spuIds = agrSpu.get(shopId).stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(spuIds);
                syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                if (log.isDebugEnabled()) {
                    LOGGER.debug("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                }
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    LOGGER.error("\u540c\u6b65\u767d\u540d\u5355\u5931\u8d25\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                    throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                }
            }
        }
    }
}

