/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ListUtils;
import com.tydic.commodity.zone.ability.bo.UccAgrItembatchforcedofftheshelvesAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrItembatchforcedofftheshelvesAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccAgrItembatchforcedofftheshelvesBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAgrItembatchforcedofftheshelvesBusiServiceImpl
implements UccAgrItembatchforcedofftheshelvesBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAgrItembatchforcedofftheshelvesBusiServiceImpl.class);
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    @Override
    public UccAgrItembatchforcedofftheshelvesAbilityRspBO dealAgrItembatchforcedofftheshelves(UccAgrItembatchforcedofftheshelvesAbilityReqBO reqBO) {
        UccAgrItembatchforcedofftheshelvesAbilityRspBO rspBO = new UccAgrItembatchforcedofftheshelvesAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5f3a\u5236\u4e0b\u67b6\u6210\u529f");
        HashMap<Long, List<Object>> syncInfo = new HashMap<Long, List<Object>>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u4e0b\u67b6\u5355\u54c1\u4fe1\u606f");
            return rspBO;
        }
        List<Object> skus = new ArrayList();
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        for (Long supplierShopId : mapSku.keySet()) {
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List uccSkuPos = null;
            try {
                uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
                List<Long> failIds = new ArrayList();
                List<Long> downGoAudit = new ArrayList();
                ArrayList<Long> editGoAudit = new ArrayList<Long>();
                if (uccSkuPos.size() < skus.size()) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                    return rspBO;
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (uccSkuPo.getSkuStatus().equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus())) continue;
                        failIds.add(uccSkuPo.getSkuId());
                    }
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (!StringUtil.isNotEmpty((String)uccSkuPo.getApprovalStatus())) continue;
                        if (ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus()))) {
                            downGoAudit.add(uccSkuPo.getSkuId());
                        }
                        if (!ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus()))) continue;
                        editGoAudit.add(uccSkuPo.getCommodityId());
                    }
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIds = ListUtils.removeNull(failIds))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + failIds.toString() + "\u72b6\u6001\u4e0d\u4e3a\u4e0a\u67b6");
                    return rspBO;
                }
                if (reqBO.getSameLevel() == 1) {
                    ArrayList<Integer> skuStatus = new ArrayList<Integer>();
                    skuStatus.add(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
                    skuStatus.add(SkuStatusEnum.FROZEN_STATUS.getStatus());
                    List sameLevelOtrherSku = this.uccSkuMapper.queySameLevelOtrherSku(skus, supplierShopId, skuStatus, null, null);
                    if (!CollectionUtils.isEmpty((Collection)sameLevelOtrherSku)) {
                        Iterator iterator = sameLevelOtrherSku.iterator();
                        while (iterator.hasNext()) {
                            UccSkuPo same = (UccSkuPo)iterator.next();
                            if (same != null && ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.equals(Integer.valueOf(same.getApprovalStatus()))) {
                                downGoAudit.add(same.getSkuId());
                                skus.add(same.getSkuId());
                            }
                            if (same == null || !ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.equals(Integer.valueOf(same.getApprovalStatus()))) continue;
                            editGoAudit.add(same.getCommodityId());
                            skus.add(same.getSkuId());
                        }
                    }
                }
                downGoAudit = ListUtils.removeNull(downGoAudit);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(editGoAudit)) {
                    editGoAudit = new ArrayList(new HashSet(ListUtils.removeNull(editGoAudit)));
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(downGoAudit)) {
                    // empty if block
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(editGoAudit)) {
                    this.uccCommodityMapper.batchUpdateSpuApprovalStatus(editGoAudit, null, supplierShopId);
                    this.uccCommodityMapper.batchUpdateStep(editGoAudit, null, supplierShopId);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5931\u8d25" + e.getMessage());
            }
            UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
            UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
            ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
            UccSkuUpdateStatusBO bo = null;
            for (Long l : skus) {
                bo = new UccSkuUpdateStatusBO();
                bo.setSkuId(l);
                bo.setSkuStatus(SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus());
                skuUpdateStatusBOS.add(bo);
            }
            uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
            uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
            uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
            uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus("0");
            uccStatusChangeUpdateSpuAtomReqBO.setStepId("null");
            syncInfo.put(supplierShopId, skus);
            try {
                statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
                if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
                }
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
            }
            try {
                for (Long l : skus) {
                    UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                    uccSkuPutCirReqBO.setSkuId(l);
                    uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                    uccSkuPutCirReqBO.setDownType(Integer.valueOf(1));
                    uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr((Date)new Date()));
                    uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                    uccSkuPutCirReqBO.setRemark("\u5f3a\u5236\u4e0b\u67b6");
                    this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
            }
        }
        rspBO.setSyncInfo(syncInfo);
        return rspBO;
    }
}

