/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ComBatchDealObjPO;
import com.tydic.commodity.po.ComBatchDealOrderPO;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.atom.api.UccChangeStatusAtomService;
import com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoRspBo;
import com.tydic.osworkflow.ability.OsworkflowRuntimeProcInstHandleAbilityService;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleReqBO;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleRespBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccChangeStatusAtomServiceImpl
implements UccChangeStatusAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccChangeStatusAtomServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private OsworkflowRuntimeProcInstHandleAbilityService osworkflowRuntimeProcInstHandleAbilityService;
    @Autowired
    private UmcSendRevokeTodoService umcSendRevokeTodoService;

    @Override
    public void changeCommod(AgrMessageBo reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds()) && CollectionUtils.isEmpty((Collection)reqBO.getAgreementSkuIds())) {
            throw new BusinessException("8888", "\u534f\u8bae\u6d88\u606fid\u6216\u8005\u660e\u7ec6id\u5168\u4e3a\u7a7a\uff01");
        }
        try {
            Integer count = this.uccSkuMapper.checkCountByAgreementIds(reqBO.getAgreementIds());
            if (count > 0) {
                if (UccConstants.AgrStatusChangeType.FREZE.equals(reqBO.getChangeType())) {
                    List<ComBatchDealObjPO> comBatchDealObjPOList = this.getOrderIds(reqBO);
                    this.freeze(reqBO);
                    this.stopProcInst(reqBO, comBatchDealObjPOList);
                }
                if (UccConstants.AgrStatusChangeType.THAW.equals(reqBO.getChangeType())) {
                    this.thaw(reqBO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u66f4\u65b0\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private void thaw(AgrMessageBo reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds())) {
            this.uccSkuMapper.revertSkuByAgreementIds(reqBO.getAgreementIds());
            this.uccSkuMapper.revertCommodityStatusByAgreementIds(reqBO.getAgreementIds());
        }
    }

    private void stopProcInst(AgrMessageBo reqBO, List<ComBatchDealObjPO> comBatchDealObjPOList) {
        if (!CollectionUtils.isEmpty(comBatchDealObjPOList)) {
            List batchNoList;
            List orderIds = comBatchDealObjPOList.stream().map(ComBatchDealObjPO::getOrderId).distinct().collect(Collectors.toList());
            this.eacRuTaskMapper.revokeAuditTask(orderIds);
            ComBatchDealOrderPO comBatchDealOrderPO = new ComBatchDealOrderPO();
            comBatchDealOrderPO.setOrderIds(orderIds);
            List comBatchDealOrderPOList = this.comBatchDealOrderMapper.getList(comBatchDealOrderPO);
            if (!CollectionUtils.isEmpty((Collection)comBatchDealOrderPOList) && !CollectionUtils.isEmpty(batchNoList = comBatchDealOrderPOList.stream().map(ComBatchDealOrderPO::getBatchNo).distinct().collect(Collectors.toList()))) {
                this.comBatchDealRrecordMapper.deleteByBatchNos(batchNoList);
            }
            List approveInstIds = comBatchDealObjPOList.stream().map(ComBatchDealObjPO::getApproveInstId).distinct().collect(Collectors.toList());
            for (String approveInstId : approveInstIds) {
                DeleteProcInstSingleReqBO deleteProcInstSingleReqBO = new DeleteProcInstSingleReqBO();
                deleteProcInstSingleReqBO.setProcInstId(approveInstId);
                log.debug("\u534f\u8bae\u5f71\u54cd\u5546\u54c1\u7ec8\u6b62\u5ba1\u6279\u6d41\u7a0b\u5b9e\u4f8b\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)deleteProcInstSingleReqBO));
                DeleteProcInstSingleRespBO deleteProcInstSingleRespBO = this.osworkflowRuntimeProcInstHandleAbilityService.deleteProcInstSingle(deleteProcInstSingleReqBO);
                log.debug("\u534f\u8bae\u5f71\u54cd\u5546\u54c1\u7ec8\u6b62\u5ba1\u6279\u6d41\u7a0b\u5b9e\u4f8b\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)deleteProcInstSingleRespBO));
            }
            for (ComBatchDealObjPO comBatchDealObjPO : comBatchDealObjPOList) {
                UmcSendRevokeTodoReqBo umcSendRevokeTodoReqBo = new UmcSendRevokeTodoReqBo();
                umcSendRevokeTodoReqBo.setBusiId(comBatchDealObjPO.getApproveInstId() + "-" + comBatchDealObjPO.getTaskId());
                if (StringUtils.isBlank((CharSequence)reqBO.getOperId())) {
                    reqBO.setOperId("1");
                }
                umcSendRevokeTodoReqBo.setOperUserId(reqBO.getOperId());
                if (StringUtils.isBlank((CharSequence)reqBO.getOperName())) {
                    reqBO.setOperName("\u7cfb\u7edf");
                }
                umcSendRevokeTodoReqBo.setOperUserName(reqBO.getOperName());
                log.debug("\u534f\u8bae\u5f71\u54cd\u5546\u54c1\u64a4\u9500\u4ee3\u529e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)umcSendRevokeTodoReqBo));
                UmcSendRevokeTodoRspBo umcSendRevokeTodoRspBo = this.umcSendRevokeTodoService.revokeTodo(umcSendRevokeTodoReqBo);
                log.debug("\u534f\u8bae\u5f71\u54cd\u5546\u54c1\u64a4\u9500\u4ee3\u529e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)umcSendRevokeTodoRspBo));
            }
        }
    }

    @NotNull
    private List<ComBatchDealObjPO> getOrderIds(AgrMessageBo reqBO) {
        List commodityObjPos;
        ArrayList<ComBatchDealObjPO> comBatchDealObjPOList = new ArrayList<ComBatchDealObjPO>();
        List skuObjPos = this.uccSkuMapper.qryAgrSkuAuditOrderList(reqBO.getAgreementIds());
        if (!CollectionUtils.isEmpty((Collection)skuObjPos)) {
            comBatchDealObjPOList.addAll(skuObjPos);
        }
        if (!CollectionUtils.isEmpty((Collection)(commodityObjPos = this.uccSkuMapper.qryAgrCommodityAuditOrderList(reqBO.getAgreementIds())))) {
            comBatchDealObjPOList.addAll(commodityObjPos);
        }
        return comBatchDealObjPOList;
    }

    private void freeze(AgrMessageBo reqBO) {
        this.uccSkuMapper.freezeSkuByAgreementIdsAudit(reqBO.getAgreementIds());
        this.uccSkuMapper.freezeSkuByAgreementIdsNotAudit(reqBO.getAgreementIds());
        this.uccSkuMapper.freezeCommodityByAgreementIdsAudit(reqBO.getAgreementIds());
        this.uccSkuMapper.freezeCommodityByAgreementIdsNotAudit(reqBO.getAgreementIds());
    }
}

