/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.busibase.comb.api.UccSkuBatchAddRecordCombService;
import com.tydic.commodity.busibase.comb.bo.UccSkuBatchAddRecordCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuBatchAddRecordCombRspBO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.api.UccAgrSimpleSingleEditSpuAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSimpleSingleEditSpuAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSimpleSingleEditSpuAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccAgrSimpleSingleEditSpuBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrSimpleSingleEditSpuBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccAgrSimpleSingleEditSpuBusiRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrSimpleSingleEditSpuAbilityService"})
public class UccAgrSimpleSingleEditSpuAbilityServiceImpl
implements UccAgrSimpleSingleEditSpuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrSimpleSingleEditSpuAbilityServiceImpl.class);
    @Autowired
    private UccAgrSimpleSingleEditSpuBusiService uccAgrSimpleSingleEditSpuBusiService;
    @Autowired
    private UccSkuBatchAddRecordCombService uccSkuBatchAddRecordCombService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    @Autowired
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;

    @PostMapping(value={"editSpuSimple"})
    public UccAgrSimpleSingleEditSpuAbilityRspBO editSpuSimple(@RequestBody UccAgrSimpleSingleEditSpuAbilityReqBO reqBO) {
        this.val(reqBO);
        UccAgrSimpleSingleEditSpuBusiRspBO uccAgrSimpleSingleEditSpuBusiRspBO = this.uccAgrSimpleSingleEditSpuBusiService.editSpuSimple((UccAgrSimpleSingleEditSpuBusiReqBO)JUtil.js((Object)reqBO, UccAgrSimpleSingleEditSpuBusiReqBO.class));
        if (!"0000".equals(uccAgrSimpleSingleEditSpuBusiRspBO.getRespCode())) {
            throw new BaseBusinessException(uccAgrSimpleSingleEditSpuBusiRspBO.getRespCode(), uccAgrSimpleSingleEditSpuBusiRspBO.getRespDesc());
        }
        this.createStock(reqBO);
        if (UccConstants.SimpleModeOperType.SAVE.equals(reqBO.getOperType())) {
            this.syncMq(reqBO);
        }
        if (UccConstants.SimpleModeOperType.SUBMIT.equals(reqBO.getOperType())) {
            this.dealBatchSubmit(reqBO, uccAgrSimpleSingleEditSpuBusiRspBO);
        }
        UccAgrSimpleSingleEditSpuAbilityRspBO rspBO = new UccAgrSimpleSingleEditSpuAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealBatchSubmit(UccAgrSimpleSingleEditSpuAbilityReqBO reqBO, UccAgrSimpleSingleEditSpuBusiRspBO uccAgrSimpleSingleEditSpuBusiRspBO) {
        UccSkuBatchAddRecordCombReqBO uccSkuBatchAddRecordCombReqBO = new UccSkuBatchAddRecordCombReqBO();
        ArrayList<UccSkuBatchAddRecordBO> uccSkuBatchAddRecordBOS = new ArrayList<UccSkuBatchAddRecordBO>();
        UccSkuBatchAddRecordBO uccSkuBatchAddRecordBO = new UccSkuBatchAddRecordBO();
        uccSkuBatchAddRecordBO.setObjId(reqBO.getSkuId());
        uccSkuBatchAddRecordBOS.add(uccSkuBatchAddRecordBO);
        uccSkuBatchAddRecordCombReqBO.setBatchObjList(uccSkuBatchAddRecordBOS);
        uccSkuBatchAddRecordCombReqBO.setObjType(UccConstants.BatchObjType.SKU);
        if (SkuStatusConstants.SKU_STATUS_DRAFT.equals(uccAgrSimpleSingleEditSpuBusiRspBO.getSkuStatus())) {
            uccSkuBatchAddRecordCombReqBO.setDealType(UccConstants.BatchDealType.SKU_EDIT_SUBMIT_DRAFT);
        } else {
            List<Integer> downShelfStatus;
            if (SkuStatusConstants.SKU_STATUS_WAIT_SHELF.equals(uccAgrSimpleSingleEditSpuBusiRspBO.getSkuStatus())) {
                uccSkuBatchAddRecordCombReqBO.setDealType(UccConstants.BatchDealType.SKU_EDIT_SUBMIT_NOT_DRAFT_TO_PUT_ON);
            }
            if (SkuStatusConstants.SKU_STATUS_ON_SHELF.equals(uccAgrSimpleSingleEditSpuBusiRspBO.getSkuStatus())) {
                uccSkuBatchAddRecordCombReqBO.setDealType(UccConstants.BatchDealType.SKU_EDIT_SUBMIT_NOT_DRAFT_ON_SHELF);
            }
            if ((downShelfStatus = Arrays.asList(SkuStatusConstants.SKU_STATUS_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_ECCOM_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_FORCE_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_WARING_DOWN_SHELF)).contains(uccAgrSimpleSingleEditSpuBusiRspBO.getSkuStatus())) {
                uccSkuBatchAddRecordCombReqBO.setDealType(UccConstants.BatchDealType.SKU_EDIT_SUBMIT_NOT_DRAFT_DOWN_SHELF);
            }
        }
        uccSkuBatchAddRecordCombReqBO.setName(reqBO.getName());
        uccSkuBatchAddRecordCombReqBO.setUserId(reqBO.getUserId());
        uccSkuBatchAddRecordCombReqBO.setOrgId(reqBO.getOrgId());
        uccSkuBatchAddRecordCombReqBO.setOrgName(reqBO.getOrgName());
        uccSkuBatchAddRecordCombReqBO.setCompanyId(reqBO.getCompanyId());
        uccSkuBatchAddRecordCombReqBO.setCompanyName(reqBO.getCompanyName());
        uccSkuBatchAddRecordCombReqBO.setEditBatchId(uccAgrSimpleSingleEditSpuBusiRspBO.getEditBatchId());
        uccSkuBatchAddRecordCombReqBO.setSource(UccConstants.Source.AGR);
        UccSkuBatchAddRecordCombRspBO uccSkuBatchAddRecordCombRspBO = this.uccSkuBatchAddRecordCombService.addRecrod(uccSkuBatchAddRecordCombReqBO);
        if (!"0000".equals(uccSkuBatchAddRecordCombRspBO.getRespCode())) {
            throw new BaseBusinessException(uccSkuBatchAddRecordCombRspBO.getRespCode(), uccSkuBatchAddRecordCombRspBO.getRespDesc());
        }
    }

    private void syncMq(UccAgrSimpleSingleEditSpuAbilityReqBO reqBO) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setCommodityIds(Collections.singletonList(reqBO.getCommodityId()));
        syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u6781\u7b80\u5bfc\u5165\u5546\u54c1\u540c\u6b65es\u5f02\u5e38--->", (Throwable)e);
        }
    }

    private void val(UccAgrSimpleSingleEditSpuAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierShopId()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u4f9b\u5e94\u5546ID\u4e3a\u7a7a");
        }
        if (null == reqBO.getMoq()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u6700\u5c0f\u8d77\u8ba2\u91cf\u4e3a\u7a7a");
        }
        if (null == reqBO.getOnShelveWay()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u4e0a\u67b6\u65b9\u5f0f\u4e3a\u7a7a");
        }
        if (UccConstants.BatchRecordOnShelveWay.TIME_PUT_ON.equals(reqBO.getOnShelveWay()) && null == reqBO.getOnShelveTime()) {
            throw new BaseBusinessException("0001", "\u81ea\u52a8\u4e0a\u67b6-\u5b9a\u65f6\u4e0a\u67b6\u7684\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPicUrlList())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u56fe\u7247\u4e3a\u7a7a");
        }
        if (null == reqBO.getCommodityTypeId()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5546\u54c1\u7c7b\u578bID\u4e3a\u7a7a");
        }
        if (null == reqBO.getMeasureId()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u7ed3\u7b97\u5355\u4f4dID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getMeasureName())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u7ed3\u7b97\u5355\u4f4d\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == reqBO.getSalesUnitId()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5305\u88c5\u5355\u4f4dID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSalesUnitName())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5305\u88c5\u5355\u4f4d\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == reqBO.getRate()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u7a0e\u7387\u4e3a\u7a7a");
        }
        if (null == reqBO.getAgreementPrice()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u4ef7\u4e3a\u7a7a");
        }
        if (null == reqBO.getMarketPrice()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5e02\u573a\u4ef7\u4ef7\u4e3a\u7a7a");
        }
        if (null == reqBO.getSalePrice()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u9500\u552e\u4ef7\u4e3a\u7a7a");
        }
        if (null == reqBO.getSwitchOn()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u662f\u5426\u542f\u7528\u9636\u68af\u4ef7\u4e3a\u7a7a");
        }
        if (null == reqBO.getAgreementId()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u534f\u8baeID\u4e3a\u7a7a");
        }
        if (UccConstants.LadderSwitchOn.YES.equals(reqBO.getSwitchOn()) && CollectionUtils.isEmpty((Collection)reqBO.getLadderPriceBOList())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u9636\u68af\u4ef7\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
    }

    private void createStock(UccAgrSimpleSingleEditSpuAbilityReqBO reqBO) {
        long buyNumber = MoneyUtils.yuanToHaoToLong((BigDecimal)Convert.toBigDecimal((Object)reqBO.getBuyNumber()));
        SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
        smcsdkQryStockNumReqBO.setSkuIds(Collections.singletonList(reqBO.getSkuId()));
        SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
        Map skuStockNumMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
        if (null != skuStockNumMap.get(reqBO.getSkuId())) {
            buyNumber -= ((Long)skuStockNumMap.get(reqBO.getSkuId())).longValue();
        }
        SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
        smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(buyNumber));
        smcsdkStockNumInfoBO.setSkuId(Convert.toStr((Object)reqBO.getSkuId()));
        SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
        smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(Collections.singletonList(smcsdkStockNumInfoBO));
        smcsdkOperateStockNumReqBO.setOperateType("11");
        smcsdkOperateStockNumReqBO.setObjectId(Convert.toStr((Object)Sequence.getInstance().nextId()));
        smcsdkOperateStockNumReqBO.setObjectType("20");
        try {
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
            SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
            if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
            }
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
        }
    }
}

