/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.comb.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.busi.api.UccAgrExpireDealBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrDealBusiServiceRspBo;
import com.tydic.commodity.zone.comb.api.UccAgrCommodityMessageDealCombService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccAgrCommodityMessageDealCombServiceImpl
implements UccAgrCommodityMessageDealCombService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrCommodityMessageDealCombServiceImpl.class);
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccAgrExpireDealBusiService uccAgrExpireDealBusiService;

    @Override
    public RspUccBo dealMessage(AgrMessageBo reqBO) {
        this.val(reqBO);
        ArrayList<UccSkuPo> skuPos = new ArrayList<UccSkuPo>();
        switch (reqBO.getChangeType()) {
            case 1: {
                skuPos.addAll(this.dealExpire(reqBO));
                break;
            }
            case 2: {
                skuPos.addAll(this.dealEffective(reqBO));
                break;
            }
            case 3: {
                skuPos.addAll(this.dealScopeChange(reqBO));
                break;
            }
        }
        skuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId)).forEach(this::syncEs);
        RspUccBo rspBO = new RspUccBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private List<UccSkuPo> dealScopeChange(AgrMessageBo reqBO) {
        return new ArrayList<UccSkuPo>();
    }

    private List<UccSkuPo> dealEffective(AgrMessageBo reqBO) {
        return new ArrayList<UccSkuPo>();
    }

    private List<UccSkuPo> dealExpire(AgrMessageBo reqBO) {
        UccAgrDealBusiServiceRspBo uccAgrDealBusiServiceRspBo = this.uccAgrExpireDealBusiService.dealAgrExpire(reqBO);
        if ("0000".equals(uccAgrDealBusiServiceRspBo.getRespCode())) {
            throw new BusinessException("8888", "\u5904\u7406\u534f\u8bae\u5931\u6548\u5f02\u5e38" + uccAgrDealBusiServiceRspBo.getRespDesc());
        }
        return uccAgrDealBusiServiceRspBo.getUccSkuPos();
    }

    private void syncEs(Long supplierShopId, List<UccSkuPo> skuPos) {
        List skuIds = skuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
        syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        log.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u5546\u54c1\u72b6\u6001\u548c\u4ef7\u683c\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void val(AgrMessageBo reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds())) {
            throw new BusinessException("8888", "\u534f\u8baeid\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getChangeType()) {
            throw new BusinessException("8888", "\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

