/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.tydic.commodity.base.bo.LadderPriceBO;
import com.tydic.commodity.base.bo.UccSpuImportReasonAbilityBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.atom.bo.UccAgrSkuMinimalismInfoBo;
import com.tydic.commodity.busibase.comb.api.UccCodegenerationCombService;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombRspBO;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.zone.ability.api.UccAgrMinimalismCreateSkuImportAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrMinimalismCreateSkuImportAbilityReqBo;
import com.tydic.commodity.zone.ability.bo.UccAgrMinimalismCreateSkuImportAbilityRspBo;
import com.tydic.commodity.zone.ability.bo.UccAgrMinimalismSkuImportBo;
import com.tydic.commodity.zone.comb.api.UccAgrMinimalismCreateSkuImportCombRspBo;
import com.tydic.commodity.zone.comb.bo.UccAgrMinimalismCreateSkuImportCombReqBo;
import com.tydic.commodity.zone.comb.bo.UccAgrMinimalismCreateSkuImportCombService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainListService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrMainListBo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrMinimalismCreateSkuImportAbilityService"})
public class UccAgrMinimalismCreateSkuImportAbilityServiceImpl
implements UccAgrMinimalismCreateSkuImportAbilityService {
    @Autowired
    private UccAgrMinimalismCreateSkuImportCombService uccAgrMinimalismCreateSkuImportCombService;
    @Autowired
    private AgrGetAgrMainListService agrGetAgrMainListService;
    @Autowired
    private AgrGetAgrItemListService agrGetAgrItemListService;
    @Autowired
    private UccCodegenerationCombService uccCodegenerationCombService;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;
    public static final String YES_STR = "\u662f";
    public static final String NO_STR = "\u5426";
    public static final Integer YES = 1;
    public static final Integer NO = 0;

    @PostMapping(value={"minimalismImportSku"})
    public UccAgrMinimalismCreateSkuImportAbilityRspBo minimalismImportSku(@RequestBody UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo) {
        UccAgrMinimalismCreateSkuImportAbilityRspBo rspBo = new UccAgrMinimalismCreateSkuImportAbilityRspBo();
        this.val(reqBo);
        AgrMainListBo agrMainListBo = this.getAgrMain(reqBo);
        Map<String, AgrItemDetailBo> agrDetailMap = this.getAgrDetailMap(reqBo);
        Map<String, UccCommodityMeasurePo> measurePoMap = this.getMeasureMap(reqBo);
        HashMap<String, Long> brandMap = new HashMap();
        HashMap<String, Long> commodityTypeMap = new HashMap();
        if (!UccConstants.MinimalismCreateType.HAVE_DETAILS.equals(reqBo.getCreateType())) {
            brandMap = this.getBrandMap(reqBo);
            commodityTypeMap = this.getCommodityTypeMap(reqBo);
        }
        List afterTakeTypeDicPo = this.uccBaseDictionaryAtomService.queryBypCodeBackPo("AFTER_TAKE_TYPE");
        Map<String, String> afterTakeTypeDicMap = afterTakeTypeDicPo.stream().collect(Collectors.toMap(DicDictionaryPo::getTitle, DicDictionaryPo::getCode));
        List onShelveWayDicPo = this.uccBaseDictionaryAtomService.queryBypCodeBackPo("SKU_ON_SHELVE_WAY");
        Map<String, String> onShelveWayDicMap = onShelveWayDicPo.stream().collect(Collectors.toMap(DicDictionaryPo::getTitle, DicDictionaryPo::getCode));
        ArrayList<UccSpuImportReasonAbilityBO> failReasonList = new ArrayList<UccSpuImportReasonAbilityBO>();
        ArrayList<UccAgrSkuMinimalismInfoBo> agrSkuMinimalismInfoBos = new ArrayList<UccAgrSkuMinimalismInfoBo>();
        for (UccAgrMinimalismSkuImportBo uccAgrMinimalismSkuImportBo : reqBo.getAgrSkuInfo()) {
            UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo = new UccAgrSkuMinimalismInfoBo();
            StringBuilder failReason = new StringBuilder();
            failReason.append(StrUtil.format((CharSequence)"\u5217\u8868\u7b2c{}\u884c", (Object[])new Object[]{Convert.toStr((Object)uccAgrMinimalismSkuImportBo.getGluttonLineNum())}));
            boolean valResUlt = this.valSku(uccAgrMinimalismSkuImportBo, reqBo, failReason);
            valResUlt = this.createImportSku(reqBo, agrMainListBo, agrDetailMap, measurePoMap, brandMap, commodityTypeMap, afterTakeTypeDicMap, onShelveWayDicMap, uccAgrMinimalismSkuImportBo, failReason, valResUlt, uccAgrSkuMinimalismInfoBo);
            if (valResUlt) {
                agrSkuMinimalismInfoBos.add(uccAgrSkuMinimalismInfoBo);
                continue;
            }
            UccSpuImportReasonAbilityBO uccSpuImportReasonAbilityBO = new UccSpuImportReasonAbilityBO();
            uccSpuImportReasonAbilityBO.setLineNum(Convert.toInt((Object)uccAgrMinimalismSkuImportBo.getGluttonLineNum()));
            String replace = failReason.toString().substring(0, failReason.toString().length() - 1) + "\uff1b";
            uccSpuImportReasonAbilityBO.setFailReason(replace);
            failReasonList.add(uccSpuImportReasonAbilityBO);
        }
        this.dealImport(reqBo, agrSkuMinimalismInfoBos);
        rspBo.setFailReasonList(failReasonList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private Boolean createImportSku(UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo, AgrMainListBo agrMainListBo, Map<String, AgrItemDetailBo> agrDetailMap, Map<String, UccCommodityMeasurePo> measurePoMap, Map<String, Long> brandMap, Map<String, Long> commodityTypeMap, Map<String, String> afterTakeTypeDicMap, Map<String, String> onShelveWayDicMap, UccAgrMinimalismSkuImportBo uccAgrMinimalismSkuImportBo, StringBuilder stringBuilder, Boolean valResUlt, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo) {
        Integer date;
        uccAgrSkuMinimalismInfoBo.setAgreementId(agrMainListBo.getAgrId());
        uccAgrSkuMinimalismInfoBo.setCommodityCode(this.getSpuCode());
        uccAgrSkuMinimalismInfoBo.setSupplierShopId(agrMainListBo.getSupplierId());
        uccAgrSkuMinimalismInfoBo.setShopName(agrMainListBo.getSupplierName());
        uccAgrSkuMinimalismInfoBo.setVendorId(agrMainListBo.getSupplierId());
        uccAgrSkuMinimalismInfoBo.setOtherSourceId(agrMainListBo.getAgrId());
        uccAgrSkuMinimalismInfoBo.setOtherSourceCode(agrMainListBo.getAgrCode());
        uccAgrSkuMinimalismInfoBo.setOtherSourceName(agrMainListBo.getAgrName());
        uccAgrSkuMinimalismInfoBo.setOrgId(Convert.toStr((Object)agrMainListBo.getManagementOrgId()));
        uccAgrSkuMinimalismInfoBo.setOrgName(agrMainListBo.getManagementOrgName());
        uccAgrSkuMinimalismInfoBo.setSkuCode(this.getSkuCode(uccAgrSkuMinimalismInfoBo.getCommodityCode()));
        uccAgrSkuMinimalismInfoBo.setSkuName(uccAgrMinimalismSkuImportBo.getSkuName());
        try {
            BigDecimal markerPrice = new BigDecimal(uccAgrMinimalismSkuImportBo.getMarketPrice()).setScale(2, 4);
            uccAgrSkuMinimalismInfoBo.setMarketPrice(markerPrice);
        }
        catch (Exception e) {
            uccAgrSkuMinimalismInfoBo.setMarketPrice(BigDecimal.ZERO);
            stringBuilder.append("\u201c\u5e02\u573a\u4ef7\u201d\u8f93\u5165\u683c\u5f0f\u9519\u8bef").append("\u3001");
            valResUlt = false;
        }
        try {
            BigDecimal agreementPrice = new BigDecimal(uccAgrMinimalismSkuImportBo.getAgreementPrice()).setScale(2, 4);
            uccAgrSkuMinimalismInfoBo.setAgreementPrice(agreementPrice);
        }
        catch (Exception e) {
            uccAgrSkuMinimalismInfoBo.setAgreementPrice(BigDecimal.ZERO);
            stringBuilder.append("\u201c\u91c7\u8d2d\u4ef7\u201d\u8f93\u5165\u683c\u5f0f\u9519\u8bef").append("\u3001");
            valResUlt = false;
        }
        if ("0".equals(reqBo.getIsprofess())) {
            try {
                BigDecimal salePrice = new BigDecimal(uccAgrMinimalismSkuImportBo.getSalePrice()).setScale(2, 4);
                uccAgrSkuMinimalismInfoBo.setSalePrice(salePrice);
            }
            catch (Exception e) {
                uccAgrSkuMinimalismInfoBo.setSalePrice(BigDecimal.ZERO);
                stringBuilder.append("\u201c\u9500\u552e\u4ef7\u201d\u8f93\u5165\u683c\u5f0f\u9519\u8bef").append("\u3001");
                valResUlt = false;
            }
        } else {
            uccAgrSkuMinimalismInfoBo.setSalePrice(uccAgrSkuMinimalismInfoBo.getAgreementPrice());
        }
        try {
            BigDecimal moq = new BigDecimal(uccAgrMinimalismSkuImportBo.getMoq()).setScale(2, 4);
            uccAgrSkuMinimalismInfoBo.setMoq(moq);
        }
        catch (Exception e) {
            uccAgrSkuMinimalismInfoBo.setMoq(BigDecimal.ZERO);
            stringBuilder.append("\u201c\u6700\u5c0f\u8d77\u8ba2\u91cf\u201d\u8f93\u5165\u683c\u5f0f\u9519\u8bef").append("\u3001");
            valResUlt = false;
        }
        UccCommodityMeasurePo uccCommodityMeasurePo = measurePoMap.get(uccAgrMinimalismSkuImportBo.getSalesUnitName());
        if (null != uccCommodityMeasurePo) {
            uccAgrSkuMinimalismInfoBo.setSalesUnitId(uccCommodityMeasurePo.getMeasureId());
        } else {
            stringBuilder.append("\u201c\u5305\u88c5\u5355\u4f4d\u201d\u8f93\u5165\u9519\u8bef\u6216\u4e0d\u5b58\u5728\u8be5\u5305\u88c5\u5355\u4f4d").append("\u3001");
            valResUlt = false;
        }
        uccAgrSkuMinimalismInfoBo.setSalesUnitName(uccAgrMinimalismSkuImportBo.getSalesUnitName());
        try {
            BigDecimal salesUnitRate = new BigDecimal(uccAgrMinimalismSkuImportBo.getSalesUnitRate()).setScale(2, 4);
            uccAgrSkuMinimalismInfoBo.setSalesUnitRate(salesUnitRate);
        }
        catch (Exception e) {
            uccAgrSkuMinimalismInfoBo.setSalesUnitRate(BigDecimal.ZERO);
            stringBuilder.append("\u201c\u6700\u5c0f\u8d77\u8ba2\u91cf\u201d\u8f93\u5165\u683c\u5f0f\u9519\u8bef").append("\u3001");
            valResUlt = false;
        }
        uccAgrSkuMinimalismInfoBo.setSettlementUnit(uccAgrMinimalismSkuImportBo.getSalesUnitName());
        if (!CollectionUtil.isEmpty((Collection)uccAgrMinimalismSkuImportBo.getCommodityPics()) && uccAgrMinimalismSkuImportBo.getCommodityPics().size() <= 5) {
            uccAgrSkuMinimalismInfoBo.setCommodityPics(uccAgrMinimalismSkuImportBo.getCommodityPics());
        } else if (!CollectionUtil.isEmpty((Collection)uccAgrMinimalismSkuImportBo.getCommodityPics()) && uccAgrMinimalismSkuImportBo.getCommodityPics().size() > 5) {
            stringBuilder.append("\u201c\u5546\u54c1\u56fe\u7247\u201d\u9650\u5236\u4e3a5\u5f20").append("\u3001");
            valResUlt = false;
        }
        if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getRejectAllow())) {
            uccAgrSkuMinimalismInfoBo.setRejectAllow(YES_STR.equals(uccAgrMinimalismSkuImportBo.getRejectAllow()) ? YES : NO);
            date = null;
            try {
                date = Integer.valueOf(uccAgrMinimalismSkuImportBo.getRejectAllowDate());
            }
            catch (NumberFormatException e) {
                stringBuilder.append("\u201c\u652f\u6301\u9000\u8d27\u65f6\u9650\u201d\u8f93\u5165\u6709\u8bef").append("\u3001");
                valResUlt = false;
            }
            uccAgrSkuMinimalismInfoBo.setRejectAllowDate(date);
        }
        if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getExchangeAllow())) {
            uccAgrSkuMinimalismInfoBo.setRejectAllow(YES_STR.equals(uccAgrMinimalismSkuImportBo.getExchangeAllow()) ? YES : NO);
            date = null;
            try {
                date = Integer.valueOf(uccAgrMinimalismSkuImportBo.getExchangeAllowDate());
            }
            catch (NumberFormatException e) {
                stringBuilder.append("\u201c\u652f\u6301\u6362\u8d27\u65f6\u9650\u201d\u8f93\u5165\u6709\u8bef").append("\u3001");
                valResUlt = false;
            }
            uccAgrSkuMinimalismInfoBo.setRejectAllowDate(date);
        }
        if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getMaintainAllow())) {
            uccAgrSkuMinimalismInfoBo.setRejectAllow(YES_STR.equals(uccAgrMinimalismSkuImportBo.getMaintainAllow()) ? YES : NO);
            date = null;
            try {
                date = Integer.valueOf(uccAgrMinimalismSkuImportBo.getMaintainAllowDate());
            }
            catch (NumberFormatException e) {
                stringBuilder.append("\u201c\u652f\u6301\u7ef4\u4fee\u65f6\u9650\u201d\u8f93\u5165\u6709\u8bef").append("\u3001");
                valResUlt = false;
            }
            uccAgrSkuMinimalismInfoBo.setRejectAllowDate(date);
        }
        if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getReturnType())) {
            String afterTakeType = afterTakeTypeDicMap.get(uccAgrMinimalismSkuImportBo.getReturnType());
            if (StringUtils.isBlank((CharSequence)afterTakeType)) {
                stringBuilder.append("\u201c\u552e\u540e\u8fd4\u56de\u65b9\u5f0f\u201d\u53ea\u652f\u6301\u201c\u4e0a\u95e8\u53d6\u4ef6\u201d\u6216\u201c\u5ba2\u6237\u5bc4\u56de\u201d\u4e24\u79cd").append("\u3001");
                valResUlt = false;
            } else {
                uccAgrSkuMinimalismInfoBo.setReturnType(Convert.toInt((Object)afterTakeType));
            }
        }
        if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getCommodityPcDetailChar())) {
            uccAgrSkuMinimalismInfoBo.setCommodityPcDetailChar(StrUtil.format((CharSequence)"<p>{}</p>", (Object[])new Object[]{uccAgrMinimalismSkuImportBo.getCommodityPcDetailChar()}));
        }
        if (!CollectionUtil.isEmpty((Collection)uccAgrMinimalismSkuImportBo.getCommodityPcDetailPic()) && uccAgrMinimalismSkuImportBo.getCommodityPics().size() <= 20) {
            String template = "<div>{}</div>";
            StringBuilder sb = new StringBuilder();
            for (String picUrl : uccAgrMinimalismSkuImportBo.getCommodityPcDetailPic()) {
                sb.append(StrUtil.format((CharSequence)"<img src='{}'>", (Object[])new Object[]{picUrl}));
            }
            uccAgrSkuMinimalismInfoBo.setCommodityPcDetailChar(StrUtil.format((CharSequence)template, (Object[])new Object[]{sb.toString()}));
        } else if (!CollectionUtil.isEmpty((Collection)uccAgrMinimalismSkuImportBo.getCommodityPcDetailPic()) && uccAgrMinimalismSkuImportBo.getCommodityPics().size() > 20) {
            stringBuilder.append("\u201c\u5546\u54c1\u63cf\u8ff0\u56fe\u7247\u201d\u6700\u591a\u652f\u630120\u5f20").append("\u3001");
            valResUlt = false;
        }
        if ("0".equals(reqBo.getIsprofess()) && !StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getMaintainAllow())) {
            uccAgrSkuMinimalismInfoBo.setSwitchOn(YES_STR.equals(uccAgrMinimalismSkuImportBo.getSwitchOn()) ? YES : NO);
            if (YES_STR.equals(uccAgrMinimalismSkuImportBo.getSwitchOn()) && StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSaleNumRange()) && StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSalePriceRange())) {
                String[] priceSplit;
                String saleNumRange = uccAgrMinimalismSkuImportBo.getSaleNumRange();
                String salePriceRange = uccAgrMinimalismSkuImportBo.getSalePriceRange();
                String[] numSplit = saleNumRange.split(";");
                if (numSplit.length != (priceSplit = salePriceRange.split(";")).length) {
                    stringBuilder.append("\u542f\u7528\u9636\u68af\u4ef7\u65f6\u201c\u9500\u552e\u6570\u91cf\u533a\u95f4\u201d\u548c\u201c\u9500\u552e\u4ef7\u683c\u533a\u95f4\u201d\u6570\u91cf\u4e0d\u4e00\u81f4").append("\u3001");
                    valResUlt = false;
                } else {
                    ArrayList ladderPriceBOS = new ArrayList();
                    for (int i = 0; i < numSplit.length; ++i) {
                        String numRange = numSplit[i];
                        String[] range = numRange.split("-");
                        if (range.length != 2) {
                            stringBuilder.append("\u542f\u7528\u9636\u68af\u4ef7\u65f6\u201c\u9500\u552e\u6570\u91cf\u533a\u95f4\u201d\u8f93\u5165\u9519\u8bef").append("\u3001");
                            valResUlt = false;
                            break;
                        }
                        LadderPriceBO ladderPriceBO = new LadderPriceBO();
                        ladderPriceBO.setStartPrice(new BigDecimal(range[0]));
                        if (i == numSplit.length - 1) {
                            ladderPriceBO.setStopPrice(new BigDecimal("-1"));
                        } else {
                            ladderPriceBO.setStopPrice(new BigDecimal(range[1]));
                        }
                        ladderPriceBO.setPrice(new BigDecimal(priceSplit[i]));
                    }
                    uccAgrSkuMinimalismInfoBo.setLadderPriceBOS(ladderPriceBOS);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)uccAgrMinimalismSkuImportBo.getOnShelveWay())) {
            String onShelveWay = onShelveWayDicMap.get(uccAgrMinimalismSkuImportBo.getOnShelveWay());
            if (null == onShelveWay) {
                stringBuilder.append("\u201c\u4e0a\u67b6\u65b9\u5f0f\u201d\u53ea\u80fd\u4e3a\u201c\u624b\u52a8\u4e0a\u67b6\u201d\uff0c\u201c\u81ea\u52a8\u4e0a\u67b6-\u7acb\u5373\u4e0a\u67b6\u201d\uff0c\u201c\u81ea\u52a8\u4e0a\u67b6-\u5b9a\u65f6\u4e0a\u67b6\u201d\u4e09\u79cd").append("\u3001");
                valResUlt = false;
            } else {
                uccAgrSkuMinimalismInfoBo.setOnShelveWay(Convert.toInt((Object)onShelveWay));
                if ("\u81ea\u52a8\u4e0a\u67b6-\u5b9a\u65f6\u4e0a\u67b6".equals(uccAgrMinimalismSkuImportBo.getOnShelveWay()) && StringUtils.isNotBlank((CharSequence)uccAgrMinimalismSkuImportBo.getOnShelveTime())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date parse = new Date();
                    try {
                        parse = sdf.parse(uccAgrMinimalismSkuImportBo.getOnShelveTime());
                    }
                    catch (ParseException e) {
                        stringBuilder.append("\u201c\u4e0a\u67b6\u65b9\u5f0f\u201d\u4e3a\u201c\u81ea\u52a8\u4e0a\u67b6-\u5b9a\u65f6\u4e0a\u67b6\u201d\u65f6\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u6309\u7167\u201cyyyy-MM-dd HH:mm:ss\u201d\u683c\u5f0f\u586b\u5199").append("\u3001");
                        valResUlt = false;
                    }
                    uccAgrSkuMinimalismInfoBo.setOnShelveTime(parse);
                }
            }
        }
        if (UccConstants.MinimalismCreateType.HAVE_DETAILS.equals(reqBo.getCreateType())) {
            AgrItemDetailBo agrItemDetailBo = agrDetailMap.get(uccAgrMinimalismSkuImportBo.getMaterialCode());
            if (null == agrItemDetailBo) {
                stringBuilder.append("\u201c\u7269\u6599\u7f16\u7801\u201d\u8f93\u5165\u9519\u8bef").append("\u3001");
                valResUlt = false;
            } else {
                uccAgrSkuMinimalismInfoBo.setAgreementDetailsId(agrItemDetailBo.getAgrItemId());
                uccAgrSkuMinimalismInfoBo.setCommodityTypeId(agrItemDetailBo.getCommodityTypeId());
                uccAgrSkuMinimalismInfoBo.setBrandId(agrItemDetailBo.getBrandId());
                uccAgrSkuMinimalismInfoBo.setBrandName(agrItemDetailBo.getBrandName());
                uccAgrSkuMinimalismInfoBo.setTaxCatCode(agrItemDetailBo.getTaxCatalog());
                uccAgrSkuMinimalismInfoBo.setRate(agrItemDetailBo.getTaxRate());
                uccAgrSkuMinimalismInfoBo.setMeasureId(agrItemDetailBo.getMeasureId());
                uccAgrSkuMinimalismInfoBo.setMeasureName(agrItemDetailBo.getMeasureName());
                uccAgrSkuMinimalismInfoBo.setMfgsku(agrItemDetailBo.getModel());
                uccAgrSkuMinimalismInfoBo.setMaterialId(agrItemDetailBo.getMaterialId());
                uccAgrSkuMinimalismInfoBo.setMaterialCode(agrItemDetailBo.getMaterialCode());
                uccAgrSkuMinimalismInfoBo.setMaterialName(agrItemDetailBo.getMaterialName());
                uccAgrSkuMinimalismInfoBo.setBuyNumber(Convert.toStr((Object)agrItemDetailBo.getBuyNumber()));
            }
        } else {
            uccAgrSkuMinimalismInfoBo.setMeasureId(uccAgrSkuMinimalismInfoBo.getSalesUnitId());
            uccAgrSkuMinimalismInfoBo.setMeasureName(uccAgrSkuMinimalismInfoBo.getSalesUnitName());
            uccAgrSkuMinimalismInfoBo.setTaxCatCode(uccAgrMinimalismSkuImportBo.getTaxCatCode());
            if (StringUtils.isNotBlank((CharSequence)uccAgrMinimalismSkuImportBo.getCommodityTypeName())) {
                Long commodityTypeId = commodityTypeMap.get(uccAgrMinimalismSkuImportBo.getCommodityTypeName());
                if (null == commodityTypeId) {
                    stringBuilder.append("\u201c\u5546\u54c1\u7c7b\u578b\u201d\u8f93\u5165\u6709\u8bef\u6216\u4e0d\u5b58\u5728\u8be5\u5546\u54c1\u7c7b\u578b").append("\u3001");
                    valResUlt = false;
                } else {
                    uccAgrSkuMinimalismInfoBo.setCommodityTypeId(commodityTypeId);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)uccAgrMinimalismSkuImportBo.getBrandName())) {
                Long brandId = brandMap.get(uccAgrMinimalismSkuImportBo.getBrandName());
                if (null == brandId) {
                    stringBuilder.append("\u201c\u54c1\u724c\u201d\u8f93\u5165\u6709\u8bef\u6216\u4e0d\u5b58\u5728\u8be5\u54c1\u724c").append("\u3001");
                    valResUlt = false;
                } else {
                    uccAgrSkuMinimalismInfoBo.setBrandId(brandId);
                    uccAgrSkuMinimalismInfoBo.setBrandName(uccAgrMinimalismSkuImportBo.getBrandName());
                }
            }
            try {
                BigDecimal rate = new BigDecimal(uccAgrMinimalismSkuImportBo.getTaxRate()).setScale(2, 4);
                uccAgrSkuMinimalismInfoBo.setRate(rate);
            }
            catch (Exception e) {
                uccAgrSkuMinimalismInfoBo.setRate(BigDecimal.ZERO);
                stringBuilder.append("\u201c\u7a0e\u7387\u201d\u8f93\u5165\u683c\u5f0f\u9519\u8bef").append("\u3001");
                valResUlt = false;
            }
            uccAgrSkuMinimalismInfoBo.setBuyNumber(Convert.toStr((Object)uccAgrMinimalismSkuImportBo.getBuyNumber()));
        }
        return valResUlt;
    }

    private Map<String, Long> getCommodityTypeMap(UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo) {
        UccCommodityTypePo uccCommodityTypePo = new UccCommodityTypePo();
        uccCommodityTypePo.setCommodityTypeNameList(reqBo.getAgrSkuInfo().stream().map(UccAgrMinimalismSkuImportBo::getCommodityTypeName).distinct().collect(Collectors.toList()));
        List uccCommodityTypePos = this.uccCommodityTypeMapper.queryCommdTypeList(uccCommodityTypePo);
        return uccCommodityTypePos.stream().collect(Collectors.toMap(UccCommodityTypePo::getCommodityTypeName, UccCommodityTypePo::getCommodityTypeId));
    }

    private Map<String, Long> getBrandMap(UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo) {
        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
        uccBrandDealPO.setBrandNameList(reqBo.getAgrSkuInfo().stream().map(UccAgrMinimalismSkuImportBo::getBrandName).distinct().collect(Collectors.toList()));
        uccBrandDealPO.setBrandStatus(Integer.valueOf(1));
        List uccBrandDealPOS = this.uccBrandDealMapper.selectBy(uccBrandDealPO);
        return uccBrandDealPOS.stream().collect(Collectors.toMap(UccBrandDealPO::getBrandName, UccBrandDealPO::getBrandId));
    }

    private Map<String, UccCommodityMeasurePo> getMeasureMap(UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo) {
        UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
        uccCommodityMeasurePo.setMeasureNameList(reqBo.getAgrSkuInfo().stream().map(UccAgrMinimalismSkuImportBo::getSalesUnitName).distinct().collect(Collectors.toList()));
        List uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByPO(uccCommodityMeasurePo);
        if (CollectionUtil.isEmpty((Collection)uccCommodityMeasurePos)) {
            return new HashMap<String, UccCommodityMeasurePo>(0);
        }
        return uccCommodityMeasurePos.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureName, Function.identity()));
    }

    private String getSpuCode() {
        UccCodegenerationCombReqBO uccCodegenerationCombReqBO = new UccCodegenerationCombReqBO();
        uccCodegenerationCombReqBO.setCodeType("01");
        uccCodegenerationCombReqBO.setCount(Integer.valueOf(1));
        UccCodegenerationCombRspBO uccCodegenerationCombRspBO = this.uccCodegenerationCombService.dealUccCodegeneration(uccCodegenerationCombReqBO);
        List codeList = uccCodegenerationCombRspBO.getCodeList();
        return (String)codeList.get(0);
    }

    private String getSkuCode(String upCode) {
        UccCodegenerationCombReqBO uccCodegenerationCombReqBO = new UccCodegenerationCombReqBO();
        uccCodegenerationCombReqBO.setCodeType("02");
        uccCodegenerationCombReqBO.setCount(Integer.valueOf(1));
        uccCodegenerationCombReqBO.setUpperCode(upCode);
        UccCodegenerationCombRspBO uccCodegenerationCombRspBO = this.uccCodegenerationCombService.dealUccCodegeneration(uccCodegenerationCombReqBO);
        List codeList = uccCodegenerationCombRspBO.getCodeList();
        return (String)codeList.get(0);
    }

    private void dealImport(UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo, List<UccAgrSkuMinimalismInfoBo> agrSkuMinimalismInfoBos) {
        UccAgrMinimalismCreateSkuImportCombReqBo combReqBo = new UccAgrMinimalismCreateSkuImportCombReqBo();
        combReqBo.setUsername(reqBo.getUsername());
        combReqBo.setUserId(reqBo.getUserId());
        combReqBo.setName(reqBo.getName());
        combReqBo.setOrgId(reqBo.getOrgId());
        combReqBo.setOrgName(reqBo.getOrgName());
        combReqBo.setCompanyId(reqBo.getCompanyId());
        combReqBo.setCompanyName(reqBo.getCompanyName());
        combReqBo.setSkuMinimalismInfoBoList(agrSkuMinimalismInfoBos);
        UccAgrMinimalismCreateSkuImportCombRspBo uccAgrMinimalismCreateSkuImportCombRspBo = this.uccAgrMinimalismCreateSkuImportCombService.minimalismImportSku(combReqBo);
        if (!"0000".equals(uccAgrMinimalismCreateSkuImportCombRspBo.getRespCode())) {
            throw new BusinessException("8888", uccAgrMinimalismCreateSkuImportCombRspBo.getRespCode());
        }
    }

    private Map<String, AgrItemDetailBo> getAgrDetailMap(UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo) {
        if (UccConstants.MinimalismCreateType.HAVE_DETAILS.equals(reqBo.getCreateType())) {
            AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
            agrGetAgrItemListReqBO.setAgrId(reqBo.getAgreementId());
            agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
            AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
            if (!"0000".equals(agrGetAgrItemListRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u9519\u8bef");
            }
            if (CollectionUtils.isEmpty((Collection)agrGetAgrItemListRspBO.getRows())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u9519\u8bef");
            }
            List rows = agrGetAgrItemListRspBO.getRows();
            return rows.stream().collect(Collectors.toMap(AgrItemDetailBo::getMaterialCode, Function.identity()));
        }
        return new HashMap<String, AgrItemDetailBo>();
    }

    private AgrMainListBo getAgrMain(UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo) {
        AgrGetAgrMainListReqBO agrGetAgrMainListReqBO = new AgrGetAgrMainListReqBO();
        agrGetAgrMainListReqBO.setAgrId(reqBo.getAgreementId());
        agrGetAgrMainListReqBO.setAgrCode(reqBo.getAgreementCode());
        AgrGetAgrMainListRspBO agrGetAgrMainListRspBO = this.agrGetAgrMainListService.getAgrMainList(agrGetAgrMainListReqBO);
        if (!"0000".equals(agrGetAgrMainListRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)agrGetAgrMainListRspBO.getRows())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u9519\u8bef");
        }
        return (AgrMainListBo)agrGetAgrMainListRspBO.getRows().get(0);
    }

    private boolean valSku(UccAgrMinimalismSkuImportBo uccAgrMinimalismSkuImportBo, UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo, StringBuilder stringBuilder) {
        boolean valResUlt = true;
        if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getAgreementCode())) {
            stringBuilder.append("\u201c\u534f\u8bae\u7f16\u53f7\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSkuName())) {
            stringBuilder.append("\u201c\u5546\u54c1\u540d\u79f0\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getAgreementPrice())) {
            stringBuilder.append("\u201c\u91c7\u8d2d\u4ef7\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getMarketPrice())) {
            stringBuilder.append("\u201c\u5e02\u573a\u4ef7\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if ("0".equals(reqBo.getIsprofess())) {
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSalePrice())) {
                stringBuilder.append("\u201c\u9500\u552e\u4ef7\u201d\u5fc5\u586b").append("\u3001");
                valResUlt = false;
            }
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSwitchOn())) {
                stringBuilder.append("\u201c\u542f\u7528\u9636\u68af\u9500\u552e\u4ef7\u201d\u5fc5\u586b").append("\u3001");
                valResUlt = false;
            }
            if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSwitchOn()) && !Arrays.asList(YES_STR, NO_STR).contains(uccAgrMinimalismSkuImportBo.getSwitchOn())) {
                stringBuilder.append("\u201c\u542f\u7528\u9636\u68af\u9500\u552e\u4ef7\u201d\u8f93\u5165\u6709\u8bef").append("\u3001");
                valResUlt = false;
            }
            if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSwitchOn()) && YES_STR.equals(uccAgrMinimalismSkuImportBo.getSwitchOn())) {
                if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSaleNumRange())) {
                    stringBuilder.append("\u5728\u542f\u7528\u9636\u68af\u4ef7\u65f6\u201c\u9500\u552e\u6570\u91cf\u533a\u95f4\u201d\u5fc5\u586b").append("\u3001");
                    valResUlt = false;
                }
                if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSalePriceRange())) {
                    stringBuilder.append("\u5728\u542f\u7528\u9636\u68af\u4ef7\u65f6\u201c\u9500\u552e\u4ef7\u683c\u533a\u95f4\u201d\u5fc5\u586b").append("\u3001");
                    valResUlt = false;
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getMoq())) {
            stringBuilder.append("\u201c\u6700\u5c0f\u8d77\u8ba2\u91cf\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSettlementUnit())) {
            stringBuilder.append("\u201c\u7ed3\u7b97\u8ba1\u91cf\u5355\u4f4d\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSalesUnitName())) {
            stringBuilder.append("\u201c\u5305\u88c5\u5355\u4f4d\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getSalesUnitRate())) {
            stringBuilder.append("\u201c\u5305\u88c5\u8f6c\u6362\u7387\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getOnShelveWay())) {
            stringBuilder.append("\u201c\u4e0a\u67b6\u65b9\u5f0f\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getOnShelveWay()) && "\u81ea\u52a8\u4e0a\u67b6-\u5b9a\u65f6\u4e0a\u67b6".equals(uccAgrMinimalismSkuImportBo.getOnShelveWay()) && StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getOnShelveTime())) {
            stringBuilder.append("\u4e0a\u67b6\u65b9\u5f0f\u4e3a\u81ea\u52a8\u4e0a\u67b6-\u5b9a\u65f6\u4e0a\u67b6\u65f6\u201c\u81ea\u52a8\u4e0a\u67b6-\u5b9a\u65f6\u4e0a\u67b6\u65f6\u95f4\u201d\u5fc5\u586b").append("\u3001");
            valResUlt = false;
        }
        if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getRejectAllow())) {
            if (!Arrays.asList(YES_STR, NO_STR).contains(uccAgrMinimalismSkuImportBo.getRejectAllow())) {
                stringBuilder.append("\u201c\u662f\u5426\u652f\u6301\u9000\u8d27\u201d\u8f93\u5165\u9519\u8bef").append("\u3001");
                valResUlt = false;
            }
            if (YES_STR.equals(uccAgrMinimalismSkuImportBo.getRejectAllow()) && StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getRejectAllowDate())) {
                stringBuilder.append("\u652f\u6301\u9000\u8d27\u65f6\u201c\u9000\u8d27\u65f6\u9650\u201d\u5fc5\u586b").append("\u3001");
                valResUlt = false;
            }
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getReturnType())) {
                stringBuilder.append("\u652f\u6301\u9000\u8d27\u65f6\u201c\u552e\u540e\u8fd4\u56de\u65b9\u5f0f\u201d\u5fc5\u586b").append("\u3001");
                valResUlt = false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getExchangeAllow())) {
            if (!Arrays.asList(YES_STR, NO_STR).contains(uccAgrMinimalismSkuImportBo.getExchangeAllow())) {
                stringBuilder.append("\u201c\u662f\u5426\u652f\u6301\u6362\u8d27\u201d\u8f93\u5165\u9519\u8bef").append("\u3001");
                valResUlt = false;
            }
            if (YES_STR.equals(uccAgrMinimalismSkuImportBo.getExchangeAllow()) && StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getExchangeAllowDate())) {
                stringBuilder.append("\u652f\u6301\u6362\u8d27\u65f6\u201c\u6362\u8d27\u65f6\u9650\u201d\u5fc5\u586b").append("\u3001");
                valResUlt = false;
            }
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getReturnType())) {
                stringBuilder.append("\u652f\u6301\u6362\u8d27\u65f6\u201c\u552e\u540e\u8fd4\u56de\u65b9\u5f0f\u201d\u5fc5\u586b").append("\u3001");
                valResUlt = false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getMaintainAllow())) {
            if (!Arrays.asList(YES_STR, NO_STR).contains(uccAgrMinimalismSkuImportBo.getMaintainAllow())) {
                stringBuilder.append("\u201c\u662f\u5426\u652f\u6301\u7ef4\u4fee\u201d\u8f93\u5165\u9519\u8bef").append("\u3001");
                valResUlt = false;
            }
            if (YES_STR.equals(uccAgrMinimalismSkuImportBo.getMaintainAllow()) && StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getMaintainAllowDate())) {
                stringBuilder.append("\u652f\u6301\u7ef4\u4fee\u65f6\u201c\u7ef4\u4fee\u65f6\u9650\u201d\u5fc5\u586b").append("\u3001");
                valResUlt = false;
            }
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getReturnType())) {
                stringBuilder.append("\u652f\u6301\u7ef4\u4fee\u65f6\u201c\u552e\u540e\u8fd4\u56de\u65b9\u5f0f\u201d\u5fc5\u586b").append("\u3001");
                valResUlt = false;
            }
        }
        if (UccConstants.MinimalismCreateType.HAVE_DETAILS.equals(reqBo.getCreateType())) {
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getMaterialCode())) {
                stringBuilder.append("\u201c\u7269\u6599\u7f16\u7801\u201d\u4e3a\u7a7a").append("\u3001");
                valResUlt = false;
            }
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getMaterialName())) {
                stringBuilder.append("\u201c\u7269\u6599\u540d\u79f0\u201d\u4e3a\u7a7a").append("\u3001");
                valResUlt = false;
            }
        } else {
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getCommodityTypeName())) {
                stringBuilder.append("\u201c\u5546\u54c1\u7c7b\u578b\u201d\u4e3a\u7a7a").append("\u3001");
                valResUlt = false;
            }
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getBrandName())) {
                stringBuilder.append("\u201c\u54c1\u724c\u201d\u4e3a\u7a7a").append("\u3001");
                valResUlt = false;
            }
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getTaxRate())) {
                stringBuilder.append("\u201c\u7a0e\u7387\u201d\u4e3a\u7a7a").append("\u3001");
                valResUlt = false;
            }
            if (StringUtils.isBlank((CharSequence)uccAgrMinimalismSkuImportBo.getBuyNumber())) {
                stringBuilder.append("\u201c\u5e93\u5b58\u201d\u4e3a\u7a7a").append("\u3001");
                valResUlt = false;
            }
        }
        return valResUlt;
    }

    private void val(UccAgrMinimalismCreateSkuImportAbilityReqBo reqBo) {
        if (null == reqBo.getCreateType()) {
            throw new BusinessException("8888", "\u5bfc\u5165\u521b\u5efa\u6a21\u5f0f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAgreementCode())) {
            throw new BusinessException("8888", "\u5bfc\u5165\u534f\u8bae\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (null == reqBo.getAgreementId()) {
            throw new BusinessException("8888", "\u5bfc\u5165\u534f\u8baeid\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAgrSkuInfo())) {
            throw new BusinessException("8888", "\u5bfc\u5165\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a");
        }
    }
}

