/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.comb.impl;

import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.bo.UccAgrSkuMinimalismInfoBo;
import com.tydic.commodity.busibase.busi.api.UccSkuBatchAddRecordBusiService;
import com.tydic.commodity.busibase.busi.bo.UccSkuBatchAddRecordBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSkuBatchAddRecordBusiRspBO;
import com.tydic.commodity.zone.busi.api.UccAgrMinimalismCreateSkuImportBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrMinimalismCreateSkuImportBusiReqBo;
import com.tydic.commodity.zone.busi.bo.UccAgrMinimalismCreateSkuImportBusiRspBo;
import com.tydic.commodity.zone.comb.api.UccAgrMinimalismCreateSkuImportCombRspBo;
import com.tydic.commodity.zone.comb.bo.UccAgrMinimalismCreateSkuImportCombReqBo;
import com.tydic.commodity.zone.comb.bo.UccAgrMinimalismCreateSkuImportCombService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccAgrMinimalismCreateSkuImportCombServiceImpl
implements UccAgrMinimalismCreateSkuImportCombService {
    @Autowired
    private UccAgrMinimalismCreateSkuImportBusiService uccAgrMinimalismCreateSkuImportBusiService;
    @Autowired
    private UccSkuBatchAddRecordBusiService uccSkuBatchAddRecordBusiService;
    @Value(value="${minimalism.create.increment:200}")
    private Integer INCREMENT;

    @Override
    public UccAgrMinimalismCreateSkuImportCombRspBo minimalismImportSku(UccAgrMinimalismCreateSkuImportCombReqBo reqBo) {
        List<UccAgrSkuMinimalismInfoBo> skuMinimalismInfoBoList = reqBo.getSkuMinimalismInfoBoList();
        int times = skuMinimalismInfoBoList.size() % this.INCREMENT == 0 ? skuMinimalismInfoBoList.size() / this.INCREMENT : skuMinimalismInfoBoList.size() / this.INCREMENT + 1;
        int startIndex = 0;
        int endIndex = this.INCREMENT;
        for (int i = 1; i <= times; ++i) {
            List<UccAgrSkuMinimalismInfoBo> agrSkuMinimalismInfoBos = skuMinimalismInfoBoList.subList(startIndex, i == times ? skuMinimalismInfoBoList.size() : endIndex);
            UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo = this.minimalismCreateSku(agrSkuMinimalismInfoBos, reqBo);
            this.addRecord(reqBo, busiRspBo);
            startIndex += this.INCREMENT.intValue();
            endIndex += this.INCREMENT.intValue();
        }
        UccAgrMinimalismCreateSkuImportCombRspBo combRspBo = new UccAgrMinimalismCreateSkuImportCombRspBo();
        combRspBo.setRespCode("0000");
        combRspBo.setRespDesc("\u6210\u529f");
        return combRspBo;
    }

    private void addRecord(UccAgrMinimalismCreateSkuImportCombReqBo reqBo, UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo) {
        UccSkuBatchAddRecordBusiReqBO uccSkuBatchAddRecordBusiReqBO = new UccSkuBatchAddRecordBusiReqBO();
        uccSkuBatchAddRecordBusiReqBO.setObjType(UccConstants.BatchObjType.COMMODITY);
        uccSkuBatchAddRecordBusiReqBO.setDealType(UccConstants.BatchDealType.COMM_EDIT_SUBMIT);
        uccSkuBatchAddRecordBusiReqBO.setSource(UccConstants.Source.AGR);
        uccSkuBatchAddRecordBusiReqBO.setUserId(reqBo.getUserId());
        uccSkuBatchAddRecordBusiReqBO.setName(reqBo.getName());
        uccSkuBatchAddRecordBusiReqBO.setOrgId(reqBo.getOrgId());
        uccSkuBatchAddRecordBusiReqBO.setOrgName(reqBo.getOrgName());
        uccSkuBatchAddRecordBusiReqBO.setCompanyId(reqBo.getCompanyId());
        uccSkuBatchAddRecordBusiReqBO.setCompanyName(reqBo.getCompanyName());
        uccSkuBatchAddRecordBusiReqBO.setBatchObjList(busiRspBo.getCommodityIdList().stream().map(commodityId -> {
            UccSkuBatchAddRecordBO uccSkuBatchAddRecordBO = new UccSkuBatchAddRecordBO();
            uccSkuBatchAddRecordBO.setObjId(commodityId);
            return uccSkuBatchAddRecordBO;
        }).collect(Collectors.toList()));
        UccSkuBatchAddRecordBusiRspBO uccSkuBatchAddRecordBusiRspBO = this.uccSkuBatchAddRecordBusiService.addRecrod(uccSkuBatchAddRecordBusiReqBO);
        if (!"0000".equals(uccSkuBatchAddRecordBusiRspBO.getRespCode())) {
            throw new BusinessException("8888", uccSkuBatchAddRecordBusiRspBO.getRespDesc());
        }
    }

    private UccAgrMinimalismCreateSkuImportBusiRspBo minimalismCreateSku(List<UccAgrSkuMinimalismInfoBo> subList, UccAgrMinimalismCreateSkuImportCombReqBo reqBo) {
        UccAgrMinimalismCreateSkuImportBusiReqBo busiReqBo = new UccAgrMinimalismCreateSkuImportBusiReqBo();
        busiReqBo.setUsername(reqBo.getUsername());
        busiReqBo.setUserId(reqBo.getUserId());
        busiReqBo.setName(reqBo.getName());
        busiReqBo.setSkuMinimalismInfoBoList(subList);
        UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo = this.uccAgrMinimalismCreateSkuImportBusiService.minimalismImportSku(busiReqBo);
        if (!"0000".equals(busiRspBo.getRespCode())) {
            throw new BusinessException("8888", busiRspBo.getRespDesc());
        }
        return busiRspBo;
    }
}

