/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.CommodityStatusEnum;
import com.tydic.commodity.busibase.atom.api.UccOnthecommoditypoolsAbilityService;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrSpuEditTemplateImportAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSpuEditReasonAbilityBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSpuEditTemplateImportAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSpuEditTemplateImportAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccExcelCommodityBO;
import com.tydic.commodity.zone.ability.bo.UccExcelSkuBO;
import com.tydic.commodity.zone.ability.bo.UccZoneCommodityBO;
import com.tydic.commodity.zone.ability.impl.UccAgrSpuEditTemplateImportFactory;
import com.tydic.commodity.zone.busi.api.UccAgrSpuEditTemplateImportBusiService;
import com.tydic.commodity.zone.busi.api.UccZoneCommodityCreateBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrSpuEditTemplateImportBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccAgrSpuEditTemplateImportBusiRspBO;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListByAgrInfoService;
import com.tydic.dyc.umc.service.enterprise.UmcQrySupplierAccessService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Primary
@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrSpuEditTemplateImportAbilityService"})
public class UccAgrSpuEditTemplateImportAbilityServiceImpl
implements UccAgrSpuEditTemplateImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrSpuEditTemplateImportAbilityServiceImpl.class);
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private UmcQrySupplierAccessService umcQrySupplierAccessService;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private AgrGetAgrItemListByAgrInfoService agrGetAgrItemListByAgrInfoService;
    @Autowired
    private UccZoneCommodityCreateBusiService uccZoneCommodityCreateBusiService;
    @Autowired
    private UccOnthecommoditypoolsAbilityService uccOnthecommoditypoolsAbilityService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccAgrSpuEditTemplateImportBusiService uccAgrSpuEditTemplateImportBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealAgrSpuEditTemplateImport"})
    public UccAgrSpuEditTemplateImportAbilityRspBO dealAgrSpuEditTemplateImport(@RequestBody UccAgrSpuEditTemplateImportAbilityReqBO reqBO) {
        log.info("\u534f\u8bae\u5546\u54c1\u7f16\u8f91\u6279\u91cf\u5bfc\u5165\u63a5\u53e3" + reqBO.getArgMain().toString());
        if (ObjectUtils.isEmpty((Object)reqBO.getArgMain())) {
            throw new ZTBusinessException("url\u4e3a\u7a7a");
        }
        UccAgrSpuEditTemplateImportAbilityRspBO rspBO = new UccAgrSpuEditTemplateImportAbilityRspBO();
        this.validateCommodityStatus(reqBO.getArgMain());
        this.translateExcelCommodityData(reqBO.getArgMain());
        List<UccZoneCommodityBO> commodityBOS = this.dealExcelCommodityData(reqBO.getArgMain());
        List<Long> commds = this.upateCommodityData(commodityBOS);
        this.dealSku(reqBO);
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setCommodityIds(commds);
        syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getOrgIdIn());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.debug("\u5bfc\u5165\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private List<Long> upateCommodityData(List<UccZoneCommodityBO> commodityBOS) {
        UccAgrSpuEditTemplateImportBusiReqBO busiReqBO = new UccAgrSpuEditTemplateImportBusiReqBO();
        busiReqBO.setCommodityBOS(commodityBOS);
        UccAgrSpuEditTemplateImportBusiRspBO busiRspBO = this.uccAgrSpuEditTemplateImportBusiService.dealAgrSpuEditTemplateImport(busiReqBO);
        return busiRspBO.getCommdityIdList();
    }

    private void dealSku(UccAgrSpuEditTemplateImportAbilityReqBO reqBO) {
        ArrayList skuBOList = new ArrayList();
        reqBO.getArgMain().stream().forEach(e -> skuBOList.addAll(e.getSkuBOList()));
        Map<String, List<UccExcelSkuBO>> skuMap = skuBOList.stream().collect(Collectors.groupingBy(UccExcelSkuBO::getAdjustType));
        for (Map.Entry<String, List<UccExcelSkuBO>> entry : skuMap.entrySet()) {
            String key = entry.getKey();
            UccAgrSpuEditTemplateImportAbilityService abilityService = UccAgrSpuEditTemplateImportFactory.getAbilityServiceImpl(key);
            abilityService.dealAgrSpuEditTemplateImport(reqBO);
        }
    }

    private List<UccZoneCommodityBO> dealExcelCommodityData(List<UccExcelCommodityBO> commodityBOList) {
        ArrayList<UccAgrSpuEditReasonAbilityBO> failReasonList = new ArrayList<UccAgrSpuEditReasonAbilityBO>();
        Integer lineNum = null;
        ArrayList<UccZoneCommodityBO> uccZoneCommodityBOS = new ArrayList<UccZoneCommodityBO>();
        for (int i = 0; i < commodityBOList.size(); ++i) {
            UccExcelCommodityBO uccExcelCommodityBO = commodityBOList.get(i);
            UccAgrSpuEditReasonAbilityBO reasonAbilityBO = new UccAgrSpuEditReasonAbilityBO();
            StringBuilder reason = new StringBuilder();
            reason.append("\u7269\u6599\u7f16\u7801").append(uccExcelCommodityBO.getMaterialCode()).append("\u5bf9\u5e94\u7684\u5546\u54c1\u5bfc\u5165");
            Long id = uccExcelCommodityBO.getId();
            UccZoneCommodityBO uccCreateCommodityBO = (UccZoneCommodityBO)JSONObject.parseObject((String)JSON.toJSONString((Object)uccExcelCommodityBO), UccZoneCommodityBO.class);
            UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.selectCommdTypeNameExits(uccCreateCommodityBO.getCommodityTypeName());
            if (uccCommodityTypePo == null) {
                log.error("\u4fee\u6539\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1\u7c7b\u578b\u540d\u79f0\uff1a" + uccCreateCommodityBO.getCommodityTypeName() + "\u4e0d\u5b58\u5728");
                reason.append("\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u672c\u6761\u5546\u54c1\u7684\u5546\u54c1\u7c7b\u578b\u540d\u79f0\u4e0d\u5b58\u5728");
                reasonAbilityBO.setFailReason(reason.toString());
                reasonAbilityBO.setLineNum(lineNum);
                failReasonList.add(reasonAbilityBO);
                continue;
            }
            uccCreateCommodityBO.setCommodityTypeId(uccCommodityTypePo.getCommodityTypeId());
            uccZoneCommodityBOS.add(uccCreateCommodityBO);
        }
        return uccZoneCommodityBOS;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<UccAgrSpuEditReasonAbilityBO> translateExcelCommodityData(List<UccExcelCommodityBO> commodityBOList) {
        ArrayList<UccAgrSpuEditReasonAbilityBO> failReasonList = new ArrayList<UccAgrSpuEditReasonAbilityBO>();
        Integer lineNum = null;
        int i = 0;
        while (true) {
            block16: {
                UccExcelCommodityBO uccExcelCommodityBO;
                block15: {
                    block13: {
                        StringBuilder reason;
                        UccAgrSpuEditReasonAbilityBO reasonAbilityBO;
                        block14: {
                            if (i >= commodityBOList.size()) {
                                return failReasonList;
                            }
                            uccExcelCommodityBO = commodityBOList.get(i);
                            reasonAbilityBO = new UccAgrSpuEditReasonAbilityBO();
                            reason = new StringBuilder();
                            reason.append("\u7269\u6599\u7f16\u7801").append(uccExcelCommodityBO.getMaterialCode()).append("\u5bf9\u5e94\u7684\u5546\u54c1\u5bfc\u5165");
                            if (!"\u81ea\u52a8\u4e0a\u67b6".equals(uccExcelCommodityBO.getOnShelveWayDesc())) break block13;
                            if (StringUtils.isEmpty((Object)uccExcelCommodityBO.getAutoShelveWayDesc())) break block14;
                            if ("\u7acb\u5373\u4e0a\u67b6".equals(uccExcelCommodityBO.getAutoShelveWayDesc())) {
                                uccExcelCommodityBO.setOnShelveWay(Integer.valueOf(1));
                            }
                            if ("\u5b9a\u65f6\u4e0a\u67b6".equals(uccExcelCommodityBO.getAutoShelveWayDesc())) {
                                uccExcelCommodityBO.setOnShelveWay(Integer.valueOf(2));
                                uccExcelCommodityBO.setAutoShelveWayTime(uccExcelCommodityBO.getAutoShelveWayTime());
                            }
                            break block15;
                        }
                        log.error("\u5bfc\u5165\u672c\u6761\u6570\u636e\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff0c\u4e0a\u67b6\u65b9\u5f0f\u4fe1\u606f\u9519\u8bef\uff1a");
                        reason.append("\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u672c\u6761\u6570\u636e\u4e0a\u67b6\u65b9\u5f0f\u4fe1\u606f\u9519\u8bef");
                        lineNum = 3 + i;
                        reasonAbilityBO.setFailReason(reason.toString());
                        reasonAbilityBO.setLineNum(lineNum);
                        failReasonList.add(reasonAbilityBO);
                        break block16;
                    }
                    uccExcelCommodityBO.setOnShelveWay(Integer.valueOf(0));
                }
                if ("\u662f".equals(uccExcelCommodityBO.getRejectAllow())) {
                    uccExcelCommodityBO.setRejectAllow("1");
                } else if ("\u5426".equals(uccExcelCommodityBO.getRejectAllow())) {
                    uccExcelCommodityBO.setRejectAllow("0");
                }
                if ("\u662f".equals(uccExcelCommodityBO.getExchangeAllow())) {
                    uccExcelCommodityBO.setExchangeAllow("1");
                } else if ("\u5426".equals(uccExcelCommodityBO.getExchangeAllow())) {
                    uccExcelCommodityBO.setExchangeAllow("0");
                }
                if ("\u662f".equals(uccExcelCommodityBO.getMaintainAllow())) {
                    uccExcelCommodityBO.setMaintainAllow("1");
                } else if ("\u5426".equals(uccExcelCommodityBO.getMaintainAllow())) {
                    uccExcelCommodityBO.setMaintainAllow("0");
                }
            }
            ++i;
        }
    }

    private void validateCommodityStatus(List<UccExcelCommodityBO> commodityBOList) {
        if (ObjectUtils.isEmpty(commodityBOList)) {
            throw new ZTBusinessException("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
        }
        List<Integer> commodityStatus = Arrays.asList(CommodityStatusEnum.DRAFT_STATUS.getStatus(), CommodityStatusEnum.PRE_UP_STATUS.getStatus(), CommodityStatusEnum.UP_STATUS.getStatus(), CommodityStatusEnum.DOWN_STATUS.getStatus());
        for (UccExcelCommodityBO each : commodityBOList) {
            if (ObjectUtil.isEmpty((Object)each.getCommodityId())) {
                throw new ZTBusinessException("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            }
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setCommodityId(each.getCommodityId());
            List uccCommodityPos = this.uccCommodityMapper.qryCommodity(uccCommodityPo);
            if (ObjectUtil.isEmpty((Object)uccCommodityPos)) {
                throw new ZTBusinessException("\u5546\u54c1\u7f16\u7801\u6709\u8bef");
            }
            if (commodityStatus.contains(((UccCommodityPo)uccCommodityPos.get(0)).getCommodityStatus())) continue;
            throw new ZTBusinessException("\u5546\u54c1\u7f16\u7801\u4e3a:" + each.getCommodityId() + "\u72b6\u6001\u4e0d\u6ee1\u8db3\u6279\u91cf\u7f16\u8f91\u6761\u4ef6:[" + ((UccCommodityPo)uccCommodityPos.get(0)).getCommodityStatus() + "]");
        }
    }
}

