/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.google.common.collect.Maps;
import com.tydic.uec.busi.UecEvaluateUpdateBusiService;
import com.tydic.uec.busi.bo.UecEvaluateUpdateBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateUpdateBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaLabelBO;
import com.tydic.uec.common.bo.eva.EvaListQryInfo;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.EvaBaseExtMapper;
import com.tydic.uec.dao.EvaLabelMapper;
import com.tydic.uec.dao.EvaMapper;
import com.tydic.uec.dao.po.EvaBaseExtPO;
import com.tydic.uec.dao.po.EvaLabelPO;
import com.tydic.uec.dao.po.EvaPO;
import com.tydic.uec.utils.RedisUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecEvaluateUpdateBusiServiceImpl
implements UecEvaluateUpdateBusiService {
    private final EvaMapper evaMapper;
    private final EvaBaseExtMapper evaBaseExtMapper;
    private final EvaLabelMapper evaLabelMapper;
    private final RedisUtil redisUtil;

    @Autowired
    public UecEvaluateUpdateBusiServiceImpl(EvaBaseExtMapper evaBaseExtMapper, EvaMapper evaMapper, EvaLabelMapper evaLabelMapper, RedisUtil redisUtil) {
        this.evaMapper = evaMapper;
        this.evaBaseExtMapper = evaBaseExtMapper;
        this.evaLabelMapper = evaLabelMapper;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecEvaluateUpdateBusiRspBO updateEvaluateInfo(UecEvaluateUpdateBusiReqBO reqBO) {
        int count;
        UecEvaluateUpdateBusiRspBO rspBO = new UecEvaluateUpdateBusiRspBO();
        EvaPO evaPO = this.evaMapper.getModelById(reqBO.getEvaId());
        if (evaPO == null) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8bc4\u4ef7\u4fee\u6539\u5931\u8d25\uff0c\u8bc4\u4ef7\u4e0d\u5b58\u5728[evaId=" + reqBO.getEvaId() + "]");
            return rspBO;
        }
        if (StringUtils.isNotBlank((String)reqBO.getEvaContent())) {
            EvaBaseExtPO baseExtPO = new EvaBaseExtPO();
            baseExtPO.setEvaId(reqBO.getEvaId());
            baseExtPO.setEvaContent(reqBO.getEvaContent());
            count = this.evaBaseExtMapper.updateById(baseExtPO);
            if (count != 1) {
                rspBO.setRespCode("2222");
                rspBO.setRespDesc("\u4fee\u6539\u8bc4\u4ef7\u5931\u8d25\uff0c\u8be5\u8bc4\u4ef7\u5185\u5bb9\u4e0d\u5b58\u5728");
                return rspBO;
            }
        }
        if (!UecCommonConstant.YES_FLAG.equals(reqBO.getUpdateType())) {
            EvaPO updateEvaPO = new EvaPO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateEvaPO);
            count = this.evaMapper.updateById(updateEvaPO);
            if (count != 1) {
                rspBO.setRespCode("2222");
                rspBO.setRespDesc("\u4fee\u6539\u8bc4\u4ef7\u5931\u8d25\uff0c\u8be5\u8bc4\u4ef7\u4e0d\u5b58\u5728");
                return rspBO;
            }
        }
        this.handleRedisProcess(reqBO, evaPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u8bc4\u4ef7\u6210\u529f");
        return rspBO;
    }

    private void handleRedisProcess(UecEvaluateUpdateBusiReqBO reqBO, EvaPO evaPO) {
        String evaId = reqBO.getEvaId().toString();
        if (reqBO.getEvaState() == null && this.redisUtil.get("uec_eva_detail_" + evaPO.getSysCode() + evaPO.getBusiSn()) != null) {
            this.redisUtil.del("uec_eva_detail_" + evaPO.getSysCode() + evaPO.getBusiSn(), "uec_eva_detail_" + evaPO.getSysCode() + "_busiSn#" + evaPO.getBusiSn());
        }
        if (UecCommonConstant.StateEnum.YES.value.equals(reqBO.getEvaState())) {
            String memKey = "uec_eva_list_" + evaPO.getSysCode() + "_memId#" + evaPO.getMemId();
            String objKey = "uec_eva_list_" + evaPO.getSysCode() + "_objType#" + evaPO.getObjType() + "_objId#" + evaPO.getObjId();
            Long objKeySize = this.redisUtil.zGetSize(objKey);
            if (objKeySize != null && objKeySize > 0L) {
                this.redisUtil.del(memKey, objKey);
            }
            return;
        }
        Object hashValue = this.redisUtil.hashGet("uec_eva_list_", evaId);
        if (hashValue == null) {
            return;
        }
        if (reqBO.getEvaState() != null && !UecCommonConstant.StateEnum.YES.value.equals(reqBO.getEvaState())) {
            this.redisUtil.hashDel("uec_eva_list_", evaId);
            String objSuffix = evaPO.getSysCode() + "_objType#" + evaPO.getObjType() + "_objId#" + evaPO.getObjId();
            this.redisUtil.hashDel("eva_total_count", objSuffix);
            this.redisUtil.hashDel("eva_total_count", objSuffix + "_like");
            String labelCountKey = objSuffix + "_label";
            EvaLabelPO paramPO = new EvaLabelPO();
            paramPO.setEvaId(reqBO.getEvaId());
            List<EvaLabelPO> labelList = this.evaLabelMapper.getList(paramPO);
            if (!CollectionUtils.isEmpty(labelList)) {
                HashMap saveMap = Maps.newHashMapWithExpectedSize((int)labelList.size());
                for (EvaLabelPO label : labelList) {
                    Object labelValue = this.redisUtil.hashGet(labelCountKey, label.getLabelCode());
                    if (labelValue == null) continue;
                    EvaLabelBO labelCount = (EvaLabelBO)labelValue;
                    labelCount.setEvaCount(Integer.valueOf(labelCount.getEvaCount() - 1));
                    saveMap.put(label.getLabelCode(), labelCount);
                }
                this.redisUtil.hashMapSet(labelCountKey, saveMap, UecRedisConstant.getExpireMinutes(60, 30));
            }
            return;
        }
        this.updateHashValue(hashValue, reqBO, evaPO.getMemName());
    }

    private void updateHashValue(Object hashValue, UecEvaluateUpdateBusiReqBO reqBO, String memName) {
        EvaListQryInfo evaInfo = (EvaListQryInfo)hashValue;
        if (StringUtils.isNotBlank((String)reqBO.getEvaContent())) {
            evaInfo.setEvaContent(reqBO.getEvaContent());
        }
        if (reqBO.getIsAnonymous() != null) {
            if (StringUtils.isNotBlank((String)evaInfo.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(reqBO.getIsAnonymous())) {
                evaInfo.setMemName(evaInfo.getMemName().substring(0, 1) + "***" + evaInfo.getMemName().substring(evaInfo.getMemName().length() - 1));
            } else {
                evaInfo.setMemName(memName);
            }
            evaInfo.setIsAnonymous(reqBO.getIsAnonymous());
        }
        if (reqBO.getIsContentHide() != null) {
            if (UecCommonConstant.YES_FLAG.equals(reqBO.getIsContentHide())) {
                evaInfo.setEvaContent("\u7528\u6237\u5df2\u9690\u85cf\u8be5\u8bc4\u4ef7\u5185\u5bb9");
            } else {
                EvaBaseExtPO evaBase = this.evaBaseExtMapper.getModelById(reqBO.getEvaId());
                if (evaBase != null) {
                    evaInfo.setEvaContent(evaBase.getEvaContent());
                }
            }
            evaInfo.setIsContentHide(reqBO.getIsContentHide());
        }
        if (reqBO.getIsReply() != null) {
            evaInfo.setIsReply(reqBO.getIsReply());
        }
        if (reqBO.getIsThumbUp() != null) {
            evaInfo.setIsThumbUp(reqBO.getIsThumbUp());
        }
        if (reqBO.getIsThumbDown() != null) {
            evaInfo.setIsThumbDown(reqBO.getIsThumbDown());
        }
        if (reqBO.getIsForward() != null) {
            evaInfo.setIsForward(reqBO.getIsForward());
        }
        this.redisUtil.hashSet("uec_eva_list_", reqBO.getEvaId().toString(), evaInfo, UecRedisConstant.getExpireMinutes(20, 30));
    }
}

