/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.impl;

import com.tydic.uec.ability.UecTemplateOperateAbilityService;
import com.tydic.uec.ability.bo.UecTemplateOperateAbilityReqBO;
import com.tydic.uec.ability.bo.UecTemplateOperateAbilityRspBO;
import com.tydic.uec.busi.UecTemplateOperateBusiService;
import com.tydic.uec.busi.bo.UecTemplateOperateBusiReqBO;
import com.tydic.uec.busi.bo.UecTemplateOperateBusiRspBO;
import com.tydic.uec.common.bo.mod.ConfBaseFieldBO;
import com.tydic.uec.common.bo.mod.ConfItemLevelBO;
import com.tydic.uec.common.bo.mod.ConfStarItemBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UEC_GROUP_DEV/1.0.0/com.tydic.uec.ability.UecTemplateOperateAbilityService"})
public class UecTemplateOperateAbilityServiceImpl
implements UecTemplateOperateAbilityService {
    private final UecTemplateOperateBusiService templateOperateBusiService;

    public UecTemplateOperateAbilityServiceImpl(UecTemplateOperateBusiService templateOperateBusiService) {
        this.templateOperateBusiService = templateOperateBusiService;
    }

    @PostMapping(value={"templateInfoOperate"})
    public UecTemplateOperateAbilityRspBO templateInfoOperate(@RequestBody UecTemplateOperateAbilityReqBO reqBO) {
        this.validArgs(reqBO);
        UecTemplateOperateBusiReqBO busiReqBO = new UecTemplateOperateBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        UecTemplateOperateBusiRspBO busiRspBO = this.templateOperateBusiService.dealTemplateOperate(busiReqBO);
        UecTemplateOperateAbilityRspBO rspBO = new UecTemplateOperateAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void validArgs(UecTemplateOperateAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u53c2\u6570\u4e3a\u7a7a");
        }
        if (UecCommonConstant.OperateType.INSERT.equals(reqBO.getOperateType())) {
            reqBO.getTemplateInfo().setState(UecCommonConstant.StateEnum.YES.value);
            if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getCreateOperId()) && reqBO.getMemIdExt() != null) {
                reqBO.getTemplateInfo().setCreateOperId(reqBO.getMemIdExt().toString());
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getSysCode())) {
                throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u7cfb\u7edf\u7f16\u7801[templateInfo.sysCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getModCode())) {
                throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u6a21\u677f\u7f16\u7801[templateInfo.modCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getTypeCode())) {
                throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u7c7b\u578b\u7f16\u7801[templateInfo.typeCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (UecCommonConstant.OperateType.UPDATE.equals(reqBO.getOperateType())) {
            reqBO.getTemplateInfo().setState(UecCommonConstant.StateEnum.YES.value);
            if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getUpdateOperId()) && reqBO.getMemIdExt() != null) {
                reqBO.getTemplateInfo().setUpdateOperId(reqBO.getMemIdExt().toString());
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getModId())) {
                throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u6a21\u677fID[templateInfo.modId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getModCode())) {
                throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u6a21\u677f\u7f16\u7801[templateInfo.modCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getTypeCode())) {
                throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u7c7b\u578b\u7f16\u7801[templateInfo.typeCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            if (UecCommonConstant.OperateType.DELETE.equals(reqBO.getOperateType())) {
                if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getUpdateOperId()) && reqBO.getMemIdExt() != null) {
                    reqBO.getTemplateInfo().setUpdateOperId(reqBO.getMemIdExt().toString());
                }
                if (StringUtils.isBlank((CharSequence)reqBO.getTemplateInfo().getModId())) {
                    throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u6a21\u677fID[templateInfo.modId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (reqBO.getTemplateInfo().getState() == null) {
                    throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u6a21\u677fID[templateInfo.state]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                return;
            }
            throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u7c7b\u578b[operateType]\u4e0d\u652f\u6301");
        }
        if (reqBO.getTemplateInfo().getReviewLen() == null) {
            reqBO.getTemplateInfo().setReviewLen(Integer.valueOf(0));
        } else {
            reqBO.getTemplateInfo().setReviewLen(Integer.valueOf(reqBO.getTemplateInfo().getReviewLen() * UecCommonConstant.DAY_TO_SECONDS));
        }
        if (reqBO.getTemplateInfo().getPostLen() == null) {
            reqBO.getTemplateInfo().setPostLen(Integer.valueOf(0));
        } else {
            reqBO.getTemplateInfo().setPostLen(Integer.valueOf(reqBO.getTemplateInfo().getPostLen() * UecCommonConstant.DAY_TO_SECONDS));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getBaseFieldList())) {
            this.validFieldArgs(reqBO.getBaseFieldList());
        }
    }

    private void validFieldArgs(List<ConfBaseFieldBO> baseFieldList) {
        for (ConfBaseFieldBO baseField : baseFieldList) {
            if (StringUtils.isBlank((CharSequence)baseField.getFieldCode())) {
                throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u8bc4\u4ef7\u57fa\u672c\u5c5e\u6027\u7f16\u7801[baseFieldList.fieldCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)baseField.getFieldName())) {
                throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u8bc4\u4ef7\u57fa\u672c\u5c5e\u6027\u540d\u79f0[baseFieldList.fieldName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)baseField.getStarItemList())) continue;
            for (ConfStarItemBO starItem : baseField.getStarItemList()) {
                if (StringUtils.isBlank((CharSequence)starItem.getItemCode())) {
                    throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u8bc4\u661f\u9879\u7f16\u7801[baseFieldList.starItemList.itemCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)starItem.getItemName())) {
                    throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u8bc4\u661f\u9879\u540d\u79f0[baseFieldList.starItemList.fieldName]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (CollectionUtils.isEmpty((Collection)starItem.getItemLevelList())) {
                    throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u661f\u7ea7\u660e\u7ec6[baseFieldList.starItemList.itemLevelList]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (ConfItemLevelBO itemLevel : starItem.getItemLevelList()) {
                    if (!StringUtils.isBlank((CharSequence)itemLevel.getLevelValue())) continue;
                    throw new BusinessException("4444", "\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u661f\u7ea7\u503c[baseFieldList.starItemList.itemLevelList.levelValue]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
    }
}

