/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.utils;

import com.tydic.uec.exception.BusinessException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Value(value="${custom.redis.qryFromDB:false}")
    private boolean qryFromDB;
    private final RedisTemplate<String, Object> redisTemplate;

    @Autowired
    public RedisUtil(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Boolean expire(String key, long time) {
        if (time > 0L) {
            this.redisTemplate.expire((Object)key, time, TimeUnit.MINUTES);
            return true;
        }
        return false;
    }

    public Long getExpire(String key) {
        return this.qryFromDB ? null : this.redisTemplate.getExpire((Object)key, TimeUnit.MINUTES);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete(Arrays.asList(key));
            }
        }
        return true;
    }

    public Object get(String key) {
        return this.qryFromDB || key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public Boolean set(String key, Object value, long time) {
        if (time > 0L) {
            this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.MINUTES);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, value);
        }
        return true;
    }

    public Long add(String key, long delta) {
        if (delta < 0L) {
            throw new BusinessException("2222", "\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Long sub(String key, long delta) {
        if (delta < 0L) {
            throw new BusinessException("2222", "\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hashGet(String key, String itemKey) {
        return this.qryFromDB ? null : this.redisTemplate.opsForHash().get((Object)key, (Object)itemKey);
    }

    public List<Object> hashMultiGet(String key, Collection<Object> itemKeys) {
        return this.qryFromDB ? null : this.redisTemplate.opsForHash().multiGet((Object)key, itemKeys);
    }

    public Map<Object, Object> hashMapGet(String key) {
        return this.qryFromDB ? null : this.redisTemplate.opsForHash().entries((Object)key);
    }

    public Boolean hashMapSet(String key, Map<String, Object> map, long time) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
        if (time > 0L) {
            this.expire(key, time);
        }
        return true;
    }

    public Boolean hashSet(String key, String itemKey, Object value, long time) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)itemKey, value);
        if (time > 0L) {
            this.expire(key, time);
        }
        return true;
    }

    public Long hashDel(String key, Object ... itemKey) {
        return this.redisTemplate.opsForHash().delete((Object)key, itemKey);
    }

    public Boolean hasKeyExist(String key, String itemKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)itemKey);
    }

    public Double hashAdd(String key, String itemKey, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)itemKey, by);
    }

    public Long hashSize(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public Set<Object> sGet(String key) {
        return this.qryFromDB ? null : this.redisTemplate.opsForSet().members((Object)key);
    }

    public Boolean sHasKey(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public Long sSet(String key, long time, Object ... values) {
        Long count = this.redisTemplate.opsForSet().add((Object)key, values);
        if (time > 0L) {
            this.expire(key, time);
        }
        return count;
    }

    public Long sGetSize(String key) {
        return this.qryFromDB ? null : this.redisTemplate.opsForSet().size((Object)key);
    }

    public Long sRemove(String key, Object ... values) {
        return this.redisTemplate.opsForSet().remove((Object)key, values);
    }

    public Set<Object> zGet(String key, long start, long end, boolean reverse) {
        if (this.qryFromDB) {
            return null;
        }
        return reverse ? this.redisTemplate.opsForZSet().reverseRange((Object)key, start, end) : this.redisTemplate.opsForZSet().range((Object)key, start, end);
    }

    public Set<Object> zRangeByScore(String key, double min, double max, long offset, long count, boolean reverse) {
        if (this.qryFromDB) {
            return null;
        }
        return reverse ? this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max, offset, count) : this.redisTemplate.opsForZSet().rangeByScore((Object)key, min, max, offset, count);
    }

    public Boolean zAdd(String key, Object value, double score, long time) {
        Boolean success = this.redisTemplate.opsForZSet().add((Object)key, value, score);
        if (time > 0L) {
            this.expire(key, time);
        }
        return success;
    }

    public Long zAddTuple(String key, Set<ZSetOperations.TypedTuple<Object>> tuples, long time) {
        Long count = this.redisTemplate.opsForZSet().add((Object)key, tuples);
        if (time > 0L) {
            this.expire(key, time);
        }
        return count;
    }

    public Long zGetSize(String key) {
        return this.qryFromDB ? null : this.redisTemplate.opsForZSet().zCard((Object)key);
    }

    public Long zGetSize(String key, double min, double max) {
        return this.qryFromDB ? null : this.redisTemplate.opsForZSet().count((Object)key, min, max);
    }

    public Long zRemove(String key, Object ... values) {
        return this.redisTemplate.opsForZSet().remove((Object)key, values);
    }

    public Long zRemoveRange(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().removeRange((Object)key, start, end);
    }

    public List<Object> lGet(String key, long start, long end) {
        return this.qryFromDB ? null : this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public Long lGetListSize(String key) {
        return this.qryFromDB ? null : this.redisTemplate.opsForList().size((Object)key);
    }

    public Object lGetIndex(String key, long index) {
        return this.qryFromDB ? null : this.redisTemplate.opsForList().index((Object)key, index);
    }

    public Boolean lSet(String key, Object value) {
        this.redisTemplate.opsForList().rightPush((Object)key, value);
        return true;
    }

    public Boolean lSet(String key, Object value, long time) {
        this.redisTemplate.opsForList().rightPush((Object)key, value);
        if (time > 0L) {
            this.expire(key, time);
        }
        return true;
    }

    public Boolean lSet(String key, List<Object> value, long time) {
        this.redisTemplate.opsForList().rightPushAll((Object)key, value);
        if (time > 0L) {
            this.expire(key, time);
        }
        return true;
    }

    public Boolean lUpdateIndex(String key, long index, Object value) {
        this.redisTemplate.opsForList().set((Object)key, index, value);
        return true;
    }

    public Long lRemove(String key, long count, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, count, value);
    }
}

