/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.ulc.utils.template;

import com.alibaba.fastjson.JSON;
import com.tydic.logistics.ulc.utils.template.RestTemplateUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;

public class RestTemplates {
    public static final String CONTENT_TYPE_KEY = "Content-Type";
    public static final String APPLICATION_JSON = "application/json";

    public static <T> T postWithJson(String url, Object requestBody, Class<T> responseType) {
        HashMap<String, String> map = new HashMap<String, String>(32);
        map.put(CONTENT_TYPE_KEY, APPLICATION_JSON);
        ResponseEntity<T> post = RestTemplateUtil.post(url, map, requestBody, responseType, new Object[0]);
        return (T)post.getBody();
    }

    public static <T> T post(String url, Object requestBody, Class<T> responseType) {
        Assert.notNull((Object)url, (String)"url can not be null");
        Assert.notNull((Object)requestBody, (String)"requestBody can not be null");
        Assert.notNull(responseType, (String)"responseType can not be null");
        url = url + "?" + RestTemplates.convertObjToStr(requestBody);
        ResponseEntity<T> post = RestTemplateUtil.post(url, responseType);
        if (post != null) {
            return (T)post.getBody();
        }
        return null;
    }

    public static <T> T get(String url, Object requestBody, Class<T> responseType) {
        Assert.notNull((Object)url, (String)"url can not be null");
        Assert.notNull((Object)requestBody, (String)"requestBody can not be null");
        Assert.notNull(responseType, (String)"responseType can not be null");
        url = url + "?" + RestTemplates.convertObjToStr(requestBody);
        ResponseEntity<T> post = RestTemplateUtil.post(url, responseType);
        if (post != null) {
            return (T)post.getBody();
        }
        return null;
    }

    public static String convertObjToStr(Object requestBody) {
        String jsonString = JSON.toJSONString((Object)requestBody);
        Map map = (Map)JSON.parseObject((String)jsonString, Map.class);
        StringBuilder sbu = new StringBuilder("");
        for (String key : map.keySet()) {
            sbu.append("&").append(key).append("=").append((String)map.get(key));
        }
        return sbu.toString().substring(1);
    }
}

