/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.signcontract.IUmcSignContractModel;
import com.tydic.dyc.umc.model.signcontract.SignContractDo;
import com.tydic.dyc.umc.model.signcontract.sup.SignContractYearRule;
import com.tydic.dyc.umc.model.signcontract.sup.SignSalesCategory;
import com.tydic.dyc.umc.model.signcontractapply.IUmcSignContractApplyModel;
import com.tydic.dyc.umc.model.signcontractapply.UmcSignContractApplyDo;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractLog;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignSalesCategoryApply;
import com.tydic.dyc.umc.service.domainservice.UmcCompleteSignContractService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcCompleteSignContractReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcCompleteSignContractRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.domainservice.UmcCompleteSignContractService"})
public class UmcCompleteSignContractServiceImpl
implements UmcCompleteSignContractService {
    @Autowired
    private IUmcSignContractApplyModel iUmcSignContractApplyModel;
    @Autowired
    private IUmcSignContractModel iUmcSignContractModel;

    @PostMapping(value={"completeSignContract"})
    public UmcCompleteSignContractRspBo completeSignContract(@RequestBody UmcCompleteSignContractReqBo reqBo) {
        this.validateAdd(reqBo);
        UmcSignContractApplyDo signContractApplyInfo = this.iUmcSignContractApplyModel.getSignContractApplyInfo(UmcRu.js(reqBo, UmcSignContractApplyDo.class));
        if (signContractApplyInfo == null) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u8be5\u7533\u8bf7\u5355\u4fe1\u606f");
        }
        signContractApplyInfo.setUpdateOperId(reqBo.getUserId());
        signContractApplyInfo.setUpdateTime(new Date());
        signContractApplyInfo.setUpdateOperName(reqBo.getUserName());
        signContractApplyInfo.setStatus(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.COMPLITE);
        this.iUmcSignContractApplyModel.updateSignContractApply(signContractApplyInfo);
        ArrayList<SignSalesCategoryApply> needDeleteCategorys = new ArrayList<SignSalesCategoryApply>();
        ArrayList<SignSalesCategoryApply> noNeedDeleteCategorys = new ArrayList<SignSalesCategoryApply>();
        if (!CollectionUtils.isEmpty(signContractApplyInfo.getSignSalesCategoryApplies())) {
            for (SignSalesCategoryApply categoryApplyBo : signContractApplyInfo.getSignSalesCategoryApplies()) {
                if (categoryApplyBo.getChngType() != null && "2".equals(categoryApplyBo.getChngType())) {
                    SignSalesCategoryApply needDeleteCategory = new SignSalesCategoryApply();
                    needDeleteCategory.setSalesCategoryId(categoryApplyBo.getSalesCategoryId());
                    needDeleteCategory.setDelFlag("1");
                    needDeleteCategorys.add(needDeleteCategory);
                    continue;
                }
                noNeedDeleteCategorys.add(categoryApplyBo);
            }
        }
        if (!CollectionUtils.isEmpty(needDeleteCategorys)) {
            UmcSignContractApplyDo categoryDeleteDo = new UmcSignContractApplyDo();
            categoryDeleteDo.setSignSalesCategoryApplies(needDeleteCategorys);
            this.iUmcSignContractApplyModel.updateSignSalesCategoryApplies(categoryDeleteDo);
            signContractApplyInfo.setSignSalesCategoryApplies(noNeedDeleteCategorys);
        }
        SignContractLog logReqPo = new SignContractLog();
        logReqPo.setApplyId(signContractApplyInfo.getApplyId());
        logReqPo.setCreateOperId(reqBo.getUserId());
        logReqPo.setCreateOperName(reqBo.getUserName());
        logReqPo.setCreateTime(new Date());
        logReqPo.setDelFlag("0");
        logReqPo.setTenantId(reqBo.getTenantId());
        logReqPo.setOperType(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.COMPLITE + "");
        logReqPo.setOperTypeStr("\u5df2\u5b8c\u6210");
        logReqPo.setSignContractId(signContractApplyInfo.getSignContractId());
        UmcSignContractApplyDo logDo = new UmcSignContractApplyDo();
        logDo.setSignContractLogs(Collections.singletonList(logReqPo));
        this.iUmcSignContractApplyModel.addSignContractLogs(logDo);
        SignContractDo contractDo = UmcRu.js((Object)signContractApplyInfo, SignContractDo.class);
        contractDo.setSignStatus(signContractApplyInfo.getStatus());
        this.iUmcSignContractModel.updateSignContract(contractDo);
        this.iUmcSignContractModel.updateSignContractDeleteApplyId(contractDo);
        SignContractDo categoryDeleteDo = new SignContractDo();
        categoryDeleteDo.setSignContractId(signContractApplyInfo.getSignContractId());
        this.iUmcSignContractModel.deleteSignSalesCategorie(categoryDeleteDo);
        if (!CollectionUtils.isEmpty(signContractApplyInfo.getSignSalesCategoryApplies())) {
            List<SignSalesCategory> categories = UmcRu.jsl(signContractApplyInfo.getSignSalesCategoryApplies(), SignSalesCategory.class);
            SignContractDo categoryDo = new SignContractDo();
            categoryDo.setSignSalesCategories(categories);
            this.iUmcSignContractModel.addSignSalesCategories(categoryDo);
        }
        if (!CollectionUtils.isEmpty(signContractApplyInfo.getSignContractYearRuleApplies())) {
            List<SignContractYearRule> yearRules = UmcRu.jsl(signContractApplyInfo.getSignContractYearRuleApplies(), SignContractYearRule.class);
            SignContractDo yearRuleDo = new SignContractDo();
            yearRuleDo.setSignContractYearRules(yearRules);
            this.iUmcSignContractModel.addSignContractYearRules(yearRuleDo);
        }
        UmcCompleteSignContractRspBo rspBo = new UmcCompleteSignContractRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateAdd(UmcCompleteSignContractReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getApplyId()) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u7533\u8bf7\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

