/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgTagRelQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseInvoice;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoUpdateService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoUpdateService"})
public class UmcEnterpriseInfoUpdateServiceImpl
implements UmcEnterpriseInfoUpdateService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"updateEnterpriseInfo"})
    public UmcEnterpriseInfoUpdateRspBo updateEnterpriseInfo(@RequestBody UmcEnterpriseInfoUpdateReqBo reqBo) {
        this.validateParams(reqBo);
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBo.getOrgId());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (null == orgInfo) {
            throw new BaseBusinessException("201013", "\u4f01\u4e1a\u4fe1\u606f\u4fee\u6539\u5f02\u5e38\uff1a\u65e0\u6b64\u673a\u6784\u4fe1\u606f");
        }
        UmcEnterpriseInfoUpdateRspBo rspBo = UmcRu.success(UmcEnterpriseInfoUpdateRspBo.class);
        UmcOrgInfo setOrg = UmcRu.js(reqBo.getOrgInfoBo(), UmcOrgInfo.class);
        UmcOrgInfo whereOrg = new UmcOrgInfo();
        whereOrg.setOrgId(reqBo.getOrgInfoBo().getOrgId());
        this.iUmcEnterpriseInfoModel.updateOrgInfo(setOrg, whereOrg);
        if (CollectionUtils.isEmpty((Collection)reqBo.getOrgInfoBo().getOrgTagRelBoList())) {
            UmcOrgTagRel orgTagRelSet = new UmcOrgTagRel();
            orgTagRelSet.setDelFlag("1");
            UmcOrgTagRel orgTagRelWhere = new UmcOrgTagRel();
            orgTagRelWhere.setOrgId(reqBo.getOrgId());
            this.iUmcEnterpriseInfoModel.updateOrgTagIdRel(orgTagRelSet, orgTagRelWhere);
        } else {
            ArrayList<UmcOrgTagRel> addOrgTagRelList = new ArrayList<UmcOrgTagRel>();
            Iterator<Serializable> delOrgTagRelList = new ArrayList();
            List<UmcOrgTagRel> reqOrgTagRelList = UmcRu.jsl(reqBo.getOrgInfoBo().getOrgTagRelBoList(), UmcOrgTagRel.class);
            UmcOrgTagRelQryBo orgTagRelQryBo = new UmcOrgTagRelQryBo();
            orgTagRelQryBo.setOrgId(reqBo.getOrgId());
            List<UmcOrgTagRel> oldOrgTagRelList = this.iUmcEnterpriseInfoModel.getOrgTagRelList(orgTagRelQryBo);
            if (!CollectionUtils.isEmpty(oldOrgTagRelList)) {
                addOrgTagRelList.addAll(reqOrgTagRelList);
            } else {
                ArrayList<UmcOrgTagRel> sameOldOrgTagIdRelList = new ArrayList<UmcOrgTagRel>();
                ArrayList<UmcOrgTagRel> sameReqOrgTagIdRelList = new ArrayList<UmcOrgTagRel>();
                for (UmcOrgTagRel oldOrgTagRel : oldOrgTagRelList) {
                    for (UmcOrgTagRel reqOrgTagRel : reqOrgTagRelList) {
                        if (!oldOrgTagRel.getTagId().equals(reqOrgTagRel.getTagId())) continue;
                        sameOldOrgTagIdRelList.add(oldOrgTagRel);
                        sameReqOrgTagIdRelList.add(reqOrgTagRel);
                    }
                }
                delOrgTagRelList.addAll(oldOrgTagRelList);
                delOrgTagRelList.removeAll(sameOldOrgTagIdRelList);
                addOrgTagRelList.addAll(reqOrgTagRelList);
                addOrgTagRelList.removeAll(sameReqOrgTagIdRelList);
            }
            this.updateOrgTagRel((List<UmcOrgTagRel>)addOrgTagRelList, (List<UmcOrgTagRel>)((Object)delOrgTagRelList), orgInfo);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseInvoiceBoList())) {
            List<UmcEnterpriseInvoice> enterpriseInvoiceList = UmcRu.jsl(reqBo.getEnterpriseInvoiceBoList(), UmcEnterpriseInvoice.class);
            for (UmcEnterpriseInvoice enterpriseInvoice : enterpriseInvoiceList) {
                if (null != enterpriseInvoice.getInvoiceId()) {
                    UmcEnterpriseInvoice whereInvoice = new UmcEnterpriseInvoice();
                    whereInvoice.setInvoiceId(enterpriseInvoice.getInvoiceId());
                    this.iUmcEnterpriseInfoModel.updateEnterpriseInvoice(enterpriseInvoice, whereInvoice);
                    continue;
                }
                enterpriseInvoice.setInvoiceId(IdUtil.nextId());
                this.iUmcEnterpriseInfoModel.createEnterpriseInvoice(enterpriseInvoice);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseBankBoList())) {
            List<UmcEnterpriseBank> enterpriseBankList = UmcRu.jsl(reqBo.getEnterpriseBankBoList(), UmcEnterpriseBank.class);
            for (UmcEnterpriseBank enterpriseBank : enterpriseBankList) {
                if (null != enterpriseBank.getBankId()) {
                    UmcEnterpriseBank whereBank = new UmcEnterpriseBank();
                    whereBank.setBankId(enterpriseBank.getBankId());
                    this.iUmcEnterpriseInfoModel.updateEnterpriseBank(enterpriseBank, whereBank);
                    continue;
                }
                enterpriseBank.setBankId(IdUtil.nextId());
                this.iUmcEnterpriseInfoModel.createEnterpriseBank(enterpriseBank);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseContactBoList())) {
            List<UmcEnterpriseContact> enterpriseContactList = UmcRu.jsl(reqBo.getEnterpriseContactBoList(), UmcEnterpriseContact.class);
            for (UmcEnterpriseContact enterpriseContact : enterpriseContactList) {
                if (null != enterpriseContact.getContactId()) {
                    UmcEnterpriseContact whereContact = new UmcEnterpriseContact();
                    whereContact.setContactId(enterpriseContact.getContactId());
                    this.iUmcEnterpriseInfoModel.updateEnterpriseContact(enterpriseContact, whereContact);
                    continue;
                }
                enterpriseContact.setContactId(IdUtil.nextId());
                this.iUmcEnterpriseInfoModel.createEnterpriseContact(enterpriseContact);
            }
        }
        UmcEnterpriseInfoDo setInfo = UmcRu.js(reqBo, UmcEnterpriseInfoDo.class);
        UmcEnterpriseInfoDo whereInfo = new UmcEnterpriseInfoDo();
        whereInfo.setOrgId(reqBo.getOrgId());
        this.iUmcEnterpriseInfoModel.updateEnterpriseInfo(setInfo, whereInfo);
        return rspBo;
    }

    private void updateOrgTagRel(List<UmcOrgTagRel> add, List<UmcOrgTagRel> del, UmcOrgInfo orgInfo) {
        for (UmcOrgTagRel addOrgTagRel : add) {
            addOrgTagRel.setOrgId(orgInfo.getOrgId());
            addOrgTagRel.setTenantId(orgInfo.getTenantId());
            addOrgTagRel.setTagStatus("02");
            addOrgTagRel.setCreateTime(new Date());
            addOrgTagRel.setUpdateTime(new Date());
            this.iUmcEnterpriseInfoModel.createOrgTagIdRel(addOrgTagRel);
        }
        for (UmcOrgTagRel delOrgTagRel : del) {
            delOrgTagRel.setDelFlag("1");
            delOrgTagRel.setUpdateTime(new Date());
            UmcOrgTagRel orgTagRelWhere = new UmcOrgTagRel();
            orgTagRelWhere.setOrgId(delOrgTagRel.getOrgId());
            orgTagRelWhere.setTagId(delOrgTagRel.getTagId());
            this.iUmcEnterpriseInfoModel.updateOrgTagIdRel(delOrgTagRel, orgTagRelWhere);
        }
    }

    private void validateParams(UmcEnterpriseInfoUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrgInfoBo())) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2[enterpriseOrgBo]\u4e3a\u7a7a\uff01");
        }
    }
}

