/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.user.UmcUserInfoChangePositionService;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoChangePositionReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoChangePositionRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.user.UmcUserInfoChangePositionService"})
public class UmcUserInfoChangePositionServiceImpl
implements UmcUserInfoChangePositionService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;

    @PostMapping(value={"changePositionUserInfo"})
    public UmcUserInfoChangePositionRspBo changePositionUserInfo(@RequestBody UmcUserInfoChangePositionReqBo reqBo) {
        this.validReqParam(reqBo);
        UmcUserInfoChangePositionRspBo rspBo = UmcRu.success(UmcUserInfoChangePositionRspBo.class);
        UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
        userInfoQryBo.setUserId(reqBo.getUserId());
        userInfoQryBo.setDelFlag("00");
        UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getUserInfo(userInfoQryBo);
        if (null == userInfoDo) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        UmcUserInfoDo umcUserInfoDo = this.buildUserInfo(reqBo, userInfoDo);
        this.iUmcUserInfoModel.createUserInfo(umcUserInfoDo);
        UmcUserInfoDo userInfoDoSet = new UmcUserInfoDo();
        userInfoDoSet.setStopStatus("00");
        userInfoDoSet.setIsMain("02");
        UmcUserInfoDo userInfoDoWhere = new UmcUserInfoDo();
        userInfoDoWhere.setUserId(reqBo.getUserId());
        this.iUmcUserInfoModel.updateUserInfo(userInfoDoSet, userInfoDoWhere);
        rspBo.setUserInfoBo(UmcRu.js(umcUserInfoDo, UmcUserInfoBo.class));
        return rspBo;
    }

    private UmcUserInfoDo buildUserInfo(UmcUserInfoChangePositionReqBo reqBo, UmcUserInfoDo userInfoDo) {
        UmcUserInfoDo umcUserInfoDo = UmcRu.js(userInfoDo, UmcUserInfoDo.class);
        umcUserInfoDo.setUserId(reqBo.getNewUserId());
        umcUserInfoDo.setCustInfo(null);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            List<UmcUserTagRel> userTagRelList = UmcRu.jsl(reqBo.getUserRoleRelBoList(), UmcUserTagRel.class);
            umcUserInfoDo.setUserTagRelList(userTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserRoleRelBoList())) {
            List<UmcUserRoleRel> userRoleRelList = UmcRu.jsl(reqBo.getUserRoleRelBoList(), UmcUserRoleRel.class);
            umcUserInfoDo.setUserRoleRelList(userRoleRelList);
        }
        return umcUserInfoDo;
    }

    private void validReqParam(UmcUserInfoChangePositionReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewOrgId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[NewOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserRoleRelBoList())) {
            for (UmcUserRoleRelBo bo : reqBo.getUserRoleRelBoList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            for (UmcUserRoleRelBo bo : reqBo.getUserTagRelList()) {
                if (bo.getTagId() != null) continue;
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[TagId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

