/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserTagRelQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.user.UmcUserInfoUpdateService;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoUpdateReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoUpdateRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.user.UmcUserInfoUpdateService"})
public class UmcUserInfoUpdateServiceImpl
implements UmcUserInfoUpdateService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;

    @PostMapping(value={"updateUserInfo"})
    public UmcUserInfoUpdateRspBo updateUserInfo(@RequestBody UmcUserInfoUpdateReqBo reqBo) {
        this.validReqParam(reqBo);
        UmcUserInfoUpdateRspBo rspBo = UmcRu.success(UmcUserInfoUpdateRspBo.class);
        UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
        userInfoQryBo.setUserId(reqBo.getUserId());
        UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getUserInfo(userInfoQryBo);
        if (null == userInfoDo) {
            throw new BaseBusinessException("203002", "\u7528\u6237\u4fee\u6539\u5f02\u5e38 \u672a\u67e5\u8be2\u5230\u6b64\u7528\u6237\u4fe1\u606f");
        }
        if (null != reqBo.getUserId()) {
            UmcUserInfoDo userSet = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcUserInfoDo.class));
            UmcUserInfoDo userWhere = new UmcUserInfoDo();
            userWhere.setUserId(reqBo.getUserId());
            this.iUmcUserInfoModel.updateUserInfo(userSet, userWhere);
        }
        if ("1".equals(reqBo.getIsChangeUserTag())) {
            if (CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelBoList())) {
                UmcUserTagRel userTagRelSet = new UmcUserTagRel();
                userTagRelSet.setDelFlag("1");
                UmcUserTagRel userTagRelWhere = new UmcUserTagRel();
                userTagRelWhere.setUserId(reqBo.getUserId());
                this.iUmcUserInfoModel.updateUserTagRel(userTagRelSet, userTagRelWhere);
            } else {
                ArrayList<UmcUserTagRel> addUserTagRelList = new ArrayList<UmcUserTagRel>();
                ArrayList<UmcUserTagRel> delUserTagRelList = new ArrayList<UmcUserTagRel>();
                List<UmcUserTagRel> reqUserTagRelList = UmcRu.jsl(reqBo.getUserTagRelBoList(), UmcUserTagRel.class);
                UmcUserTagRelQryBo orgTagRelQryBo = new UmcUserTagRelQryBo();
                orgTagRelQryBo.setUserId(reqBo.getUserId());
                List<UmcUserTagRel> oldUserTagRelList = this.iUmcUserInfoModel.getUserTagRel(orgTagRelQryBo);
                if (CollectionUtils.isEmpty(oldUserTagRelList)) {
                    addUserTagRelList.addAll(reqUserTagRelList);
                } else {
                    ArrayList<UmcUserTagRel> sameOldUserTagIdRelList = new ArrayList<UmcUserTagRel>();
                    ArrayList<UmcUserTagRel> sameReqUserTagIdRelList = new ArrayList<UmcUserTagRel>();
                    for (UmcUserTagRel oldUserTagRel : oldUserTagRelList) {
                        for (UmcUserTagRel reqUserTagRel : reqUserTagRelList) {
                            if (!oldUserTagRel.getTagId().equals(reqUserTagRel.getTagId())) continue;
                            sameOldUserTagIdRelList.add(oldUserTagRel);
                            sameReqUserTagIdRelList.add(reqUserTagRel);
                        }
                    }
                    delUserTagRelList.addAll(oldUserTagRelList);
                    delUserTagRelList.removeAll(sameOldUserTagIdRelList);
                    addUserTagRelList.addAll(reqUserTagRelList);
                    addUserTagRelList.removeAll(sameReqUserTagIdRelList);
                }
                this.updateUserTagRel(addUserTagRelList, delUserTagRelList, userInfoDo);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getCustInfoBo())) {
            UmcCustInfo custSet = StrUtil.noNullStringAttr(UmcRu.js(reqBo.getCustInfoBo(), UmcCustInfo.class));
            UmcCustInfo custWhere = new UmcCustInfo();
            custWhere.setCustId(userInfoDo.getCustId());
            this.iUmcUserInfoModel.updateCustInfo(custSet, custWhere);
        }
        return rspBo;
    }

    private void updateUserTagRel(List<UmcUserTagRel> add, List<UmcUserTagRel> del, UmcUserInfoDo userInfoDo) {
        if (!CollectionUtils.isEmpty(add)) {
            for (UmcUserTagRel addUserTagRel : add) {
                addUserTagRel.setRelId(IdUtil.nextId());
                addUserTagRel.setUserId(userInfoDo.getUserId());
                addUserTagRel.setTenantId(userInfoDo.getTenantId());
                addUserTagRel.setIsDefalt("0");
                addUserTagRel.setDelFlag("0");
                addUserTagRel.setUpdateTime(new Date());
                StrUtil.noNullStringAttr(addUserTagRel);
                this.iUmcUserInfoModel.addUserTagRel(addUserTagRel);
            }
        }
        if (!CollectionUtils.isEmpty(del)) {
            for (UmcUserTagRel addUserTagRel : add) {
                UmcUserTagRel userTagRelSet = new UmcUserTagRel();
                userTagRelSet.setDelFlag("1");
                UmcUserTagRel userTagRelWhere = new UmcUserTagRel();
                userTagRelWhere.setRelId(addUserTagRel.getRelId());
                this.iUmcUserInfoModel.updateUserTagRel(userTagRelSet, userTagRelWhere);
            }
        }
    }

    private void validReqParam(UmcUserInfoUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u7528\u6237\u4fe1\u606f\u4fee\u6539 \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("200001", "\u7528\u6237\u4fe1\u606f\u4fee\u6539 \u5165\u53c2[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

