/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterpriseapply;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseBankQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterpriseapply.IUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.model.enterpriseapply.UmcEnterpriseInfoApplyDo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseBankApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseContactApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseInfoApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcOrgInfoApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseBankApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseContactApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcOrgInfoApply;
import com.tydic.dyc.umc.service.enterpriseapply.UmcSupplierInformationChangeService;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcSupplierInformationChangeReqBO;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcSupplierInformationChangeRspBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterpriseapply.UmcSupplierInformationChangeService"})
public class UmcSupplierInformationChangeServiceImpl
implements UmcSupplierInformationChangeService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupplierInformationChangeServiceImpl.class);
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcEnterpriseInfoApplyModel iUmcEnterpriseInfoApplyModel;
    private static final String SUBMIT = "2";
    private static final String SAVE = "1";

    @PostMapping(value={"changeInformation"})
    public UmcSupplierInformationChangeRspBO changeInformation(@RequestBody UmcSupplierInformationChangeReqBO reqBO) {
        if (reqBO.getOrgIdWeb() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long applyId = 0L;
        try {
            applyId = this.insertEnterprise(reqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException("200100", e.getMessage());
        }
        reqBO.setApplyId(Long.valueOf(applyId));
        this.insertContact(reqBO);
        this.updateOrg(reqBO);
        this.insertBank(reqBO);
        UmcSupplierInformationChangeRspBO rspBo = new UmcSupplierInformationChangeRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setApplyId(reqBO.getApplyId());
        return rspBo;
    }

    private void updateOrg(UmcSupplierInformationChangeReqBO reqBO) {
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        UmcOrgInfoApply insertOrgInfo = new UmcOrgInfoApply();
        orgInfoQryBo.setOrgId(reqBO.getOrgIdWeb());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (orgInfo == null) {
            throw new BaseBusinessException("200100", "\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcOrgInfoApplyQryBo orgInfoApplyQryBo = new UmcOrgInfoApplyQryBo();
        orgInfoApplyQryBo.setOrgId(reqBO.getOrgIdWeb());
        orgInfoApplyQryBo.setApplyId(reqBO.getApplyId());
        UmcOrgInfoApply orgInfoApply = this.iUmcEnterpriseInfoApplyModel.getOrgInfoApply(orgInfoApplyQryBo);
        if (orgInfoApply == null) {
            insertOrgInfo = UmcRu.js(orgInfo, UmcOrgInfoApply.class);
            insertOrgInfo.setApplyId(reqBO.getApplyId());
        }
        insertOrgInfo.setOrgName(reqBO.getSupplierName());
        insertOrgInfo.setOrgAlias(reqBO.getSupplierShortName());
        if (orgInfoApply != null) {
            UmcOrgInfoApply where = new UmcOrgInfoApply();
            insertOrgInfo.setUpdateOperId(reqBO.getUserId());
            insertOrgInfo.setUpdateTime(new Date());
            insertOrgInfo.setUpdateOperName(reqBO.getRegAccountIn());
            where.setOrgId(reqBO.getOrgIdWeb());
            this.iUmcEnterpriseInfoApplyModel.updateOrgInfoApply(insertOrgInfo, where);
        } else {
            insertOrgInfo.setCreateOperId(reqBO.getUserId());
            insertOrgInfo.setCreateTime(new Date());
            insertOrgInfo.setCreateOperName(reqBO.getRegAccountIn());
            this.iUmcEnterpriseInfoApplyModel.createOrgInfoApply(insertOrgInfo);
        }
    }

    private void insertContact(UmcSupplierInformationChangeReqBO reqBO) {
        UmcEnterpriseContactApplyQryBo contactApplyQryBo = new UmcEnterpriseContactApplyQryBo();
        contactApplyQryBo.setOrgId(reqBO.getOrgIdWeb());
        contactApplyQryBo.setApplyId(reqBO.getApplyId());
        UmcEnterpriseContactApply enterpriseContactApply = this.iUmcEnterpriseInfoApplyModel.getEnterpriseContactApply(contactApplyQryBo);
        UmcEnterpriseContactQryBo contactQryBo = new UmcEnterpriseContactQryBo();
        contactQryBo.setOrgId(reqBO.getOrgIdWeb());
        UmcEnterpriseContact enterpriseContact = this.iUmcEnterpriseInfoModel.getEnterpriseContact(contactQryBo);
        UmcEnterpriseContactApply insertBo = new UmcEnterpriseContactApply();
        if (enterpriseContactApply == null && enterpriseContact != null) {
            BeanUtils.copyProperties((Object)enterpriseContact, (Object)insertBo);
        }
        insertBo.setTenantId(reqBO.getTenantIdIn());
        insertBo.setOrgId(reqBO.getOrgIdWeb());
        insertBo.setApplyId(reqBO.getApplyId());
        insertBo.setContactId(enterpriseContact.getContactId());
        insertBo.setContactName(reqBO.getConsignerName());
        insertBo.setCardNum(reqBO.getConsignerIdcardNum());
        insertBo.setCardPicPeople(JSONObject.toJSONString((Object)reqBO.getConsignerCardPro()));
        if (enterpriseContactApply != null) {
            UmcEnterpriseContactApply where = new UmcEnterpriseContactApply();
            insertBo.setUpdateOperId(reqBO.getUserId());
            insertBo.setUpdateOperName(reqBO.getRegAccountIn());
            insertBo.setUpdateTime(new Date());
            where.setApplyId(enterpriseContactApply.getApplyId());
            this.iUmcEnterpriseInfoApplyModel.updateEnterpriseContactApply(insertBo, where);
        } else {
            insertBo.setCreateOperId(reqBO.getUserId());
            insertBo.setCreateOperName(reqBO.getRegAccountIn());
            insertBo.setCreateTime(new Date());
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseContactApply(insertBo);
        }
    }

    public Long insertEnterprise(UmcSupplierInformationChangeReqBO reqBO) throws ParseException {
        Long applyId;
        UmcEnterpriseInfoApplyQryBo enterpriseInfoPO = new UmcEnterpriseInfoApplyQryBo();
        enterpriseInfoPO.setOrgId(reqBO.getOrgIdWeb());
        enterpriseInfoPO.setApplyType(String.valueOf(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_UPDATE));
        UmcEnterpriseInfoApplyDo eninfoChngPO = this.iUmcEnterpriseInfoApplyModel.getEnterpriseInfoApply(enterpriseInfoPO);
        UmcEnterpriseInfoApplyDo infoChngPO = new UmcEnterpriseInfoApplyDo();
        BeanUtils.copyProperties((Object)reqBO, (Object)infoChngPO);
        infoChngPO.setOrgId(reqBO.getOrgIdWeb());
        infoChngPO.setApplyType(String.valueOf(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_UPDATE));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (SAVE.equals(reqBO.getOperType())) {
            infoChngPO.setApplyStatus("3");
        } else if (SUBMIT.equals(reqBO.getOperType())) {
            infoChngPO.setApplyStatus("0");
        }
        infoChngPO.setTenantId(reqBO.getTenantIdIn());
        infoChngPO.setIsMerchant("0");
        infoChngPO.setOrgName(reqBO.getSupplierName());
        infoChngPO.setExtField7(reqBO.getSupplierType());
        infoChngPO.setOrgNature(reqBO.getEnterpriseNature());
        infoChngPO.setCreditNo(reqBO.getOrgCertificateCode());
        infoChngPO.setExtField2(simpleDateFormat.format(reqBO.getEffDate()));
        infoChngPO.setExtField3(simpleDateFormat.format(reqBO.getExpDate()));
        infoChngPO.setProvince(reqBO.getProvinceName());
        infoChngPO.setBusinessLicense(JSONObject.toJSONString((Object)reqBO.getBusinessLicense()));
        infoChngPO.setLegalCertificateType(reqBO.getLegalPersonIdcardType());
        infoChngPO.setExtField4(reqBO.getLegalPersonIdcardNum());
        infoChngPO.setLegalCertificateFront(JSONObject.toJSONString((Object)reqBO.getLegalPersonCardPro()));
        infoChngPO.setOrgEnName(reqBO.getSupplierEnName());
        infoChngPO.setOrgShortName(reqBO.getSupplierShortName());
        infoChngPO.setExtField1(JSONObject.toJSONString((Object)reqBO.getCapaPicture()));
        if (null == eninfoChngPO) {
            infoChngPO.setCreateOperId(reqBO.getUserId());
            infoChngPO.setCreateOperName(reqBO.getRegAccountIn());
            infoChngPO.setCreateTime(new Date());
            infoChngPO.setApplyId(IdUtil.nextId());
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseInfoApply(infoChngPO);
            applyId = infoChngPO.getApplyId();
        } else {
            infoChngPO.setUpdateOperId(reqBO.getUserId());
            infoChngPO.setUpdateOperName(reqBO.getRegAccountIn());
            infoChngPO.setUpdateTime(new Date());
            UmcEnterpriseInfoApplyDo where = new UmcEnterpriseInfoApplyDo();
            where.setApplyId(eninfoChngPO.getApplyId());
            this.iUmcEnterpriseInfoApplyModel.updateEnterpriseInfoApply(infoChngPO, where);
            applyId = eninfoChngPO.getApplyId();
        }
        return applyId;
    }

    public void insertBank(UmcSupplierInformationChangeReqBO reqBO) {
        UmcEnterpriseBankApplyQryBo bankInfoChngPO = new UmcEnterpriseBankApplyQryBo();
        bankInfoChngPO.setOrgId(reqBO.getOrgIdWeb());
        bankInfoChngPO.setApplyId(reqBO.getApplyId());
        UmcEnterpriseBankApply enterpriseBankInfoChngPO = this.iUmcEnterpriseInfoApplyModel.getEnterpriseBankApply(bankInfoChngPO);
        UmcEnterpriseBankQryBo bankInfoPO = new UmcEnterpriseBankQryBo();
        bankInfoPO.setOrgId(reqBO.getOrgIdWeb());
        UmcEnterpriseBank enterpriseBankInfoPO = this.iUmcEnterpriseInfoModel.getEnterpriseBank(bankInfoPO);
        UmcEnterpriseBankApply infoPO = new UmcEnterpriseBankApply();
        infoPO.setBankAccount(reqBO.getBankAccount());
        infoPO.setBankName(reqBO.getBankName());
        infoPO.setBankAccountName(reqBO.getBankAccountName());
        infoPO.setBankLinkNo(reqBO.getBankLinkNo());
        infoPO.setBankAddr(reqBO.getBankAddr());
        infoPO.setApplyId(reqBO.getApplyId());
        infoPO.setOrgId(reqBO.getOrgIdWeb());
        infoPO.setTenantId(reqBO.getTenantIdIn());
        if (enterpriseBankInfoPO != null) {
            infoPO.setBankId(enterpriseBankInfoPO.getBankId());
        } else {
            infoPO.setBankId(IdUtil.nextId());
        }
        if (null != enterpriseBankInfoChngPO) {
            infoPO.setUpdateOperId(reqBO.getUserId());
            infoPO.setUpdateTime(new Date());
            infoPO.setUpdateOperName(reqBO.getRegAccountIn());
            UmcEnterpriseBankApply where = new UmcEnterpriseBankApply();
            where.setApplyId(reqBO.getApplyId());
            this.iUmcEnterpriseInfoApplyModel.updateEnterpriseBankApply(infoPO, where);
        } else {
            infoPO.setCreateOperId(reqBO.getUserId());
            infoPO.setCreateOperName(reqBO.getRegAccountIn());
            infoPO.setCreateTime(new Date());
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseBankApply(infoPO);
        }
    }
}

