/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoItemQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.service.todo.UmcSendTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendTodoService"})
public class UmcSendTodoServiceImpl
implements UmcSendTodoService {
    @Autowired
    private IUmcTodoModel iUmcTodoModel;

    @PostMapping(value={"sendTodo"})
    public UmcSendTodoRspBo sendTodo(@RequestBody UmcSendTodoReqBo reqBO) {
        this.valdateParam(reqBO);
        UmcSendTodoRspBo rsp = UmcRu.success(UmcSendTodoRspBo.class);
        ArrayList<UmcTodoDo> umcTodoDoList = new ArrayList<UmcTodoDo>();
        for (UmcTodoBo bo : reqBO.getTodoList()) {
            UmcTodoItemQryBo umcTodoItemQryBo = new UmcTodoItemQryBo();
            umcTodoItemQryBo.setTodoItemCode(bo.getTodoItemCode());
            umcTodoItemQryBo.setTodoModuleCode(bo.getTodoModuleCode());
            List<UmcTodoItem> umcTodoItemList = this.iUmcTodoModel.selectTodoItemList(umcTodoItemQryBo);
            if (CollectionUtils.isEmpty(umcTodoItemList)) {
                throw new BaseBusinessException("101021", "\u4ee3\u529e\u9879\u8868\u4e3a\u7a7a\uff01");
            }
            if (umcTodoItemList.size() != 1) {
                throw new BaseBusinessException("101021", "\u4ee3\u529e\u9879\u5b58\u5728\u591a\u6761\u6570\u636e\uff01");
            }
            UmcTodoDo umcTodoDo = new UmcTodoDo();
            BeanUtils.copyProperties((Object)bo, (Object)umcTodoDo);
            umcTodoDo.setTodoItemCode(umcTodoItemList.get(0).getTodoItemCode());
            if (!StringUtils.hasText((String)bo.getTodoName())) {
                umcTodoDo.setTodoName(umcTodoItemList.get(0).getTodoItemName() + bo.getBusiId());
            }
            umcTodoDo.setTodoItemName(umcTodoItemList.get(0).getTodoItemName());
            if (StringUtils.hasText((String)bo.getTodoUrl())) {
                umcTodoDo.setTodoUrl(bo.getTodoUrl() + bo.getUrlSuffix());
            } else {
                umcTodoDo.setTodoUrl(umcTodoItemList.get(0).getTodoUrl() + bo.getUrlSuffix());
            }
            umcTodoDo.setTodoModuleCode(umcTodoItemList.get(0).getTodoModuleCode());
            umcTodoDo.setTodoModuleName(umcTodoItemList.get(0).getTodoModuleName());
            umcTodoDo.setTodoId(IdUtil.nextId());
            umcTodoDo.setCreateTime(new Date());
            umcTodoDoList.add(umcTodoDo);
            bo.setTodoId(umcTodoDo.getTodoId());
        }
        int isInsert = this.iUmcTodoModel.createTodo(umcTodoDoList);
        if (isInsert != umcTodoDoList.size()) {
            throw new BaseBusinessException("101021", "\u63d2\u5165\u4ee3\u529e\u4fe1\u606f\u8868\u5931\u8d25\uff01");
        }
        rsp.setTodoList(reqBO.getTodoList());
        return rsp;
    }

    private void valdateParam(UmcSendTodoReqBo reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getTodoList())) {
            throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcTodoBo bo : reqBO.getTodoList()) {
            if (!StringUtils.hasText((String)bo.getBusiId())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.busiId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getTodoItemCode())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.todoItemCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getUrlSuffix())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.urlSuffix\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getCreateOperId())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.createOperId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getCreateOperName())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.createOperName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getCandidateOperId())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.candidateOperId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.hasText((String)bo.getCandidateOperName())) continue;
            throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.candidateOperName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

