/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.qrybo.UmcMemberQryListPageQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcMemberQryListPageRspBo;
import com.tydic.dyc.umc.service.user.UmcMemberQryListPageService;
import com.tydic.dyc.umc.service.user.bo.UmcMemberBO;
import com.tydic.dyc.umc.service.user.bo.UmcMemberQryListPageAbilityReqBO;
import com.tydic.dyc.umc.service.user.bo.UmcMemberQryListPageAbilityRspBO;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.user.UmcMemberQryListPageService"})
public class UmcMemberQryListPageServiceImpl
implements UmcMemberQryListPageService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"qryMemberListPage"})
    public UmcMemberQryListPageAbilityRspBO qryMemberListPage(@RequestBody UmcMemberQryListPageAbilityReqBO reqBO) {
        UmcMemberQryListPageRspBo rspBo;
        UmcMemberQryListPageAbilityRspBO rspBO = new UmcMemberQryListPageAbilityRspBO();
        UmcMemberQryListPageQryBo qryBo = this.toQryBo(reqBO);
        if (null != reqBO.getOrgIdWeb()) {
            qryBo.setOrgTreePath(reqBO.getOrgIdWeb() + "-");
        }
        if (!"0000".equals((rspBo = this.iUmcUserInfoModel.qryMemberListPage(StrUtil.noNullStringAttr(qryBo))).getRespCode())) {
            throw new BaseBusinessException("200100", rspBo.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            return UmcRu.js((Object)rspBo, UmcMemberQryListPageAbilityRspBO.class);
        }
        rspBO = UmcRu.js((Object)rspBo, UmcMemberQryListPageAbilityRspBO.class);
        Map<String, String> sexMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap("UMC_PLUS", "MEM_SEX");
        Map<String, String> stopStatusMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap("UMC_PLUS", "MEM_STOP_STATUS");
        Map<String, String> umcTradeCapacityMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap("UMC_PLUS", "ORG_TRADE_CAPACITY");
        Map<String, String> tradeUserTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap("UMC_PLUS", "DROP_DOWN_TRADE_USER_TYPE");
        Map<String, String> orderUserTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap("UMC_PLUS", "USER_TYPE");
        Map<String, String> orgClassMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap("UMC_PLUS", "UMC_ORG_CLASS");
        HashSet<Long> orgSet = new HashSet<Long>();
        HashMap orgBusiRspBOMap = new HashMap();
        for (Object itemBO : rspBO.getRows()) {
            if (itemBO.getOrgId() != null) {
                orgSet.add(itemBO.getOrgId());
            }
            if (itemBO.getSex() != null) {
                itemBO.setSexStr(sexMap.get(itemBO.getSex().toString()));
            }
            if (!"1".equals(itemBO.getOrgStatus())) {
                itemBO.setStopStatus("00");
            }
            itemBO.setStopStatusStr(stopStatusMap.get(itemBO.getStopStatus()));
            if (!StringUtils.isBlank((CharSequence)itemBO.getTradeCapacity())) {
                String[] tradeCapacitys = itemBO.getTradeCapacity().split(",");
                StringBuilder tradeCapacityStr = new StringBuilder();
                for (String itemStr : tradeCapacitys) {
                    tradeCapacityStr.append(umcTradeCapacityMap.get(itemStr)).append("+");
                }
                if (tradeCapacityStr.length() > 0) {
                    tradeCapacityStr.deleteCharAt(tradeCapacityStr.length() - 1);
                }
                itemBO.setTradeCapacityStr(tradeCapacityStr.toString());
            }
            if (!StringUtils.isBlank((CharSequence)itemBO.getTradeUserType())) {
                itemBO.setTradeUserTypeStr(tradeUserTypeMap.get(itemBO.getTradeUserType()));
            }
            itemBO.setUserTypeStr(orderUserTypeMap.get(itemBO.getUserType()));
            itemBO.setOrgClassStr(orgClassMap.get(itemBO.getOrgClass()));
        }
        if (orgSet.size() > 0) {
            ArrayList<Long> orgIdList = new ArrayList<Long>();
            for (Long orgId1 : orgSet) {
                orgIdList.add(orgId1);
            }
            Map<Long, String> orgFullNameByOrgIds = this.iUmcEnterpriseInfoModel.getOrgFullNameByOrgIds(orgIdList);
            if (orgFullNameByOrgIds != null) {
                for (UmcMemberBO busiRspBO : rspBO.getRows()) {
                    if (busiRspBO.getOrgId() == null || orgFullNameByOrgIds.get(busiRspBO.getOrgId()) == null) continue;
                    busiRspBO.setOrgFullName(orgFullNameByOrgIds.get(busiRspBO.getOrgId()));
                }
            }
        }
        return rspBO;
    }

    private UmcMemberQryListPageQryBo toQryBo(UmcMemberQryListPageAbilityReqBO reqBO) {
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSupFlag())) {
            reqBO.setTradeUserType(null);
            reqBO.setTradeUserTypeVague(null);
        }
        UmcMemberQryListPageQryBo qryBO = UmcRu.js(reqBO, UmcMemberQryListPageQryBo.class);
        Long orgId = null;
        orgId = reqBO.getOrgIdWeb() != null ? reqBO.getOrgIdWeb() : reqBO.getOrgId();
        if (reqBO.getOrgIdWeb() != null) {
            ArrayList<Long> mgOrgIdsExs = new ArrayList<Long>();
            mgOrgIdsExs.add(reqBO.getOrgIdWeb());
            qryBO.setMgOrgIdsIn(mgOrgIdsExs);
        }
        if ("01".equals(reqBO.getQueryType())) {
            qryBO.setSelfAndNextOrg(reqBO.getMgOrgIdsIn());
            qryBO.setOrgId(null);
            qryBO.setOrgTreePath(null);
        } else if ("02".equals(reqBO.getQueryType())) {
            qryBO.setSelfAndNextOrg(null);
            qryBO.setOrgId(orgId);
            qryBO.setOrgTreePath(null);
        } else if ("03".equals(reqBO.getQueryType())) {
            qryBO.setSelfAndNextOrg(null);
            qryBO.setOrgId(null);
        } else if (StringUtils.isBlank((CharSequence)reqBO.getQueryType())) {
            qryBO.setSelfAndNextOrg(null);
            qryBO.setOrgId(orgId);
            qryBO.setOrgTreePath(null);
        }
        if (reqBO.getMainCompanyId() != null) {
            qryBO.setMainCompanyId(reqBO.getMainCompanyId());
            qryBO.setSelfAndNextOrg(null);
            qryBO.setOrgId(null);
            qryBO.setOrgTreePath(null);
        }
        return qryBO;
    }
}

