/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryRspBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.enterprise.UmcEnterpriseOrgQueryService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseOrgQueryReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseOrgQueryRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcEnterpriseOrgQueryService"})
public class UmcEnterpriseOrgQueryServiceImpl
implements UmcEnterpriseOrgQueryService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    private static final String PRO = "0";
    private static final String PRO_STR = "\u8fd0\u8425";
    private static final String NOT_PRO = "1";
    private static final String NOT_PRO_STR = "\u975e\u8fd0\u8425";

    @PostMapping(value={"queryEnterpriseOrgTree"})
    public UmcEnterpriseOrgQueryRspBO queryEnterpriseOrgTree(@RequestBody UmcEnterpriseOrgQueryReqBO reqBo) {
        UmcEnterpriseOrgQueryRspBO rspBo = UmcRu.success(UmcEnterpriseOrgQueryRspBO.class);
        UmcEnterpriseOrgQryBo enterpriseOrgQryBo = new UmcEnterpriseOrgQryBo();
        enterpriseOrgQryBo.setOrgId(reqBo.getOrgIdWeb());
        enterpriseOrgQryBo.setParentId(reqBo.getParentIdWeb());
        enterpriseOrgQryBo.setOrgName(reqBo.getOrgNameWeb());
        if (null == reqBo.getPageNo() || null == reqBo.getPageSize()) {
            enterpriseOrgQryBo.setPageNo(-1);
            enterpriseOrgQryBo.setPageSize(-1);
        } else {
            enterpriseOrgQryBo.setPageNo(reqBo.getPageNo());
            enterpriseOrgQryBo.setPageSize(reqBo.getPageSize());
        }
        UmcEnterpriseOrgQryRspBo enterpriseInfoDoBasePageRspBo = this.iUmcEnterpriseInfoModel.getEnterpriseOrgListPage(enterpriseOrgQryBo);
        ArrayList<UmcEnterpriseInfoBo> rows = new ArrayList<UmcEnterpriseInfoBo>(enterpriseInfoDoBasePageRspBo.getRows().size());
        if (!CollectionUtils.isEmpty((Collection)enterpriseInfoDoBasePageRspBo.getRows())) {
            SysDicDictionaryDo dicDictionaryDo = new SysDicDictionaryDo();
            dicDictionaryDo.setPCode("ORG_TYPE");
            List<SysDicDictionaryDo> sysDicDictionaryDos = this.iUmcSysDicDictionaryModel.queryBypCodeBackPo(dicDictionaryDo);
            for (UmcEnterpriseInfoDo enterpriseInfoDo : enterpriseInfoDoBasePageRspBo.getRows()) {
                UmcEnterpriseInfoBo enterpriseOrgTreeBo = UmcRu.js(enterpriseInfoDo.getOrgInfo(), UmcEnterpriseInfoBo.class);
                UmcOrgInfo orgInfo = enterpriseInfoDo.getOrgInfo();
                List<UmcOrgTagRel> orgTagRelList = orgInfo.getOrgTagRelList();
                if (!CollectionUtils.isEmpty(orgTagRelList)) {
                    Map<String, UmcOrgTagRel> umcOrgTagRelMap = orgTagRelList.stream().collect(Collectors.toMap(UmcOrgTagRel::getTagId, o -> o));
                    if (umcOrgTagRelMap.containsKey(PRO)) {
                        enterpriseOrgTreeBo.setIsPro(PRO);
                        enterpriseOrgTreeBo.setIsProStr(PRO_STR);
                    } else {
                        enterpriseOrgTreeBo.setIsPro(NOT_PRO);
                        enterpriseOrgTreeBo.setIsProStr(NOT_PRO_STR);
                    }
                }
                UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
                orgInfoQryBo.setParentId(enterpriseOrgTreeBo.getOrgId());
                Integer checkResult = this.iUmcEnterpriseInfoModel.getCheckOrgInfo(orgInfoQryBo);
                if (checkResult > 0) {
                    enterpriseOrgTreeBo.setIsParent(NOT_PRO);
                } else {
                    enterpriseOrgTreeBo.setIsParent(PRO);
                }
                rows.add(enterpriseOrgTreeBo);
            }
        }
        rspBo.setRows(rows);
        rspBo.setPageNo(Integer.valueOf(enterpriseInfoDoBasePageRspBo.getPageNo()));
        rspBo.setTotal(Integer.valueOf(enterpriseInfoDoBasePageRspBo.getTotal()));
        rspBo.setRecordsTotal(Integer.valueOf(enterpriseInfoDoBasePageRspBo.getRecordsTotal()));
        return rspBo;
    }
}

