/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.domainservice.UmcUserInfoAddService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserInfoAddReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserInfoAddRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.domainservice.UmcUserInfoAddService"})
public class UmcUserInfoAddServiceImpl
implements UmcUserInfoAddService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    @Value(value="${SYSTEM_ORG:1,305775845729763327,}")
    private String systemOrg;

    @PostMapping(value={"createUserInfo"})
    public UmcUserInfoAddRspBo createUserInfo(@RequestBody UmcUserInfoAddReqBo reqBo) {
        if (this.systemOrg.contains(reqBo.getOrgIdWeb() + ",")) {
            throw new BaseBusinessException("201007", "\u7528\u6237\u65b0\u589e\u5f02\u5e38\uff1a\u7cfb\u7edf\u673a\u6784\u4e0b\u4e0d\u5141\u8bb8\u521b\u5efa\u7528\u6237");
        }
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBo.getOrgIdWeb());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (ObjectUtil.isEmpty((Object)orgInfo)) {
            throw new BaseBusinessException("201007", "\u7528\u6237\u65b0\u589e\u5f02\u5e38\uff1a\u8bf7\u6c42\u767b\u5f55\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!"02".equals(orgInfo.getOrgStatus())) {
            throw new BaseBusinessException("201007", "\u7528\u6237\u65b0\u589e\u5f02\u5e38\uff1a\u8be5\u673a\u6784\u975e\u6709\u6548\u673a\u6784");
        }
        UmcUserInfoAddRspBo rspBo = UmcRu.success(UmcUserInfoAddRspBo.class);
        Long custId = IdUtil.nextId();
        Long userId = IdUtil.nextId();
        if (null == reqBo.getCustId()) {
            if (ObjectUtil.isEmpty((Object)reqBo.getCustInfoBo())) {
                throw new BaseBusinessException("201007", "\u7528\u6237\u65b0\u589e\u5f02\u5e38\uff1a[custInfoBo]\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            UmcCustInfo custInfo = this.buildCustInfo(reqBo, orgInfo);
            custInfo.setCustId(custId);
            this.iUmcUserInfoModel.createCustInfo(custInfo);
        }
        UmcUserInfoDo userInfoDo = this.buildUserInfo(reqBo, custId, userId);
        this.iUmcUserInfoModel.createUserInfo(userInfoDo);
        return rspBo;
    }

    private UmcCustInfo buildCustInfo(UmcUserInfoAddReqBo reqBo, UmcOrgInfo orgInfo) {
        UmcCustInfo custInfo = UmcRu.js(reqBo.getCustInfoBo(), UmcCustInfo.class);
        custInfo.setCompanyId(orgInfo.getCompanyId());
        if (StringUtils.isEmpty((Object)custInfo.getPasswd())) {
            custInfo.setPasswd(this.defaultPasswd());
        }
        return custInfo;
    }

    private UmcUserInfoDo buildUserInfo(UmcUserInfoAddReqBo reqBo, Long custId, Long userId) {
        UmcUserInfoDo userInfoDo = UmcRu.js(reqBo, UmcUserInfoDo.class);
        if (null == userInfoDo.getCustId()) {
            userInfoDo.setCustId(custId);
        }
        userInfoDo.setUserId(userId);
        List<UmcUserTagRel> userTagRelList = UmcRu.jsl(reqBo.getUserTagRelBoList(), UmcUserTagRel.class);
        ArrayList<UmcUserRoleRel> userRoleRelList = new ArrayList<UmcUserRoleRel>();
        for (UmcUserTagRel userTagRel : userTagRelList) {
            userTagRel.setRelId(IdUtil.nextId());
            userTagRel.setUserId(userId);
            Map<String, String> defaultRoleMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap("UMC", userTagRel.getTagId());
            if (CollectionUtils.isEmpty(defaultRoleMap)) continue;
            for (Map.Entry<String, String> defaultRole : defaultRoleMap.entrySet()) {
                UmcUserRoleRel userRoleRel = new UmcUserRoleRel();
                userRoleRel.setRelId(IdUtil.nextId());
                userRoleRel.setUserId(userId);
                userRoleRel.setRoleId(Long.valueOf(defaultRole.getKey()));
                userRoleRel.setRoleName(defaultRole.getValue());
                userRoleRel.setTagId(userTagRel.getTagId());
                userRoleRelList.add(userRoleRel);
            }
        }
        userInfoDo.setUserTagRelList(userTagRelList);
        userInfoDo.setUserRoleRelList(userRoleRelList);
        return userInfoDo;
    }

    private String defaultPasswd() {
        SysDicDictionaryDo dicDictionaryDo = new SysDicDictionaryDo();
        dicDictionaryDo.setPCode("DEFAULT_PWD");
        SysDicDictionaryDo dicDictionary = this.iUmcSysDicDictionaryModel.getDictionaryByDo(dicDictionaryDo);
        if (null == dicDictionary) {
            throw new BaseBusinessException("201007", "\u7528\u6237\u65b0\u589e\u5f02\u5e38\uff1a\u9ed8\u8ba4\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)dicDictionary.getCode())) {
            throw new BaseBusinessException("201007", "\u7528\u6237\u65b0\u589e\u5f02\u5e38\uff1a\u9ed8\u8ba4\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        return dicDictionary.getCode();
    }
}

