/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoiceaddress;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.invoiceaddress.IUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.UmcInvoiceAddressDo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressQryBo;
import com.tydic.dyc.umc.service.invoiceaddress.UmcInvoiceAddressAddService;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressAddReqBo;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressAddRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.invoiceaddress.UmcInvoiceAddressAddService"})
public class UmcInvoiceAddressAddServiceImpl
implements UmcInvoiceAddressAddService {
    @Autowired
    private IUmcInvoiceAddressModel iUmcInvoiceAddressModel;
    private final String msgHead = "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2";

    @PostMapping(value={"addInvoiceAddress"})
    public UmcInvoiceAddressAddRspBo addInvoiceAddress(@RequestBody UmcInvoiceAddressAddReqBo reqBo) {
        this.validateParams(reqBo);
        UmcInvoiceAddressAddRspBo rspBo = UmcRu.success(UmcInvoiceAddressAddRspBo.class);
        if (null != reqBo.getAccountId()) {
            this.checkAccount(reqBo.getAccountId());
        }
        this.checkOrg(reqBo.getOrgIdWeb());
        this.checkSameAddr(reqBo);
        UmcInvoiceAddressDo invoiceAddressDo = UmcRu.js(reqBo, UmcInvoiceAddressDo.class);
        List<UmcInvoiceAddressDo> invoiceAddressDoList = null != reqBo.getAccountId() ? this.qryAddrByAccountId(reqBo.getAccountId()) : this.qryAddrByOrgId(reqBo.getOrgIdWeb());
        if (CollectionUtils.isEmpty(invoiceAddressDoList)) {
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        } else if (reqBo.getMainFlag().equals(UmcCommConstant.InvAddrMainFlag.YES)) {
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
            this.cancleMainFlagAddr(invoiceAddressDoList);
        } else {
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
        }
        invoiceAddressDo.setCreateOperId(reqBo.getMemIdExt());
        invoiceAddressDo.setCreateTime(new Date());
        invoiceAddressDo.setInvoiceAddrId(IdUtil.nextId());
        invoiceAddressDo.setCompanyName(reqBo.getCompanyNameWeb());
        invoiceAddressDo.setOrgId(reqBo.getOrgIdWeb());
        invoiceAddressDo.setAddrStatus("01");
        invoiceAddressDo.setDelFlag("00");
        invoiceAddressDo.setName(reqBo.getContactNameWeb());
        invoiceAddressDo.setCreateOperName(reqBo.getName());
        invoiceAddressDo.setCreateTime(new Date());
        this.iUmcInvoiceAddressModel.createInvoiceAddress(invoiceAddressDo);
        return rspBo;
    }

    private void checkSameAddr(UmcInvoiceAddressAddReqBo reqBo) {
        UmcInvoiceAddressQryBo qryBo = UmcRu.js(reqBo, UmcInvoiceAddressQryBo.class);
        qryBo.setDelFlag("00");
        qryBo.setCompanyName(reqBo.getCompanyNameWeb());
        qryBo.setOrgId(reqBo.getOrgIdWeb());
        qryBo.setName(reqBo.getContactNameWeb());
        qryBo.setCreateOperId(reqBo.getMemIdExt());
        int checkValue = this.iUmcInvoiceAddressModel.getInvoiceAddressCheck(qryBo);
        if (checkValue > 0) {
            throw new BaseBusinessException("201003", "\u5df2\u6709\u76f8\u540c\u7684\u5730\u5740\u4fe1\u606f");
        }
    }

    private List<UmcInvoiceAddressDo> qryAddrByAccountId(Long accountId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("00");
        return this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
    }

    private List<UmcInvoiceAddressDo> qryAddrByOrgId(Long orgId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setOrgId(orgId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("00");
        return this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
    }

    private void cancleMainFlagAddr(List<UmcInvoiceAddressDo> invoiceAddressDoList) {
        UmcInvoiceAddressDo invoiceAddressDo = new UmcInvoiceAddressDo();
        invoiceAddressDo.setInvoiceAddrIdList(invoiceAddressDoList.stream().map(UmcInvoiceAddressDo::getInvoiceAddrId).collect(Collectors.toList()));
        invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
        this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo);
    }

    private void checkAccount(Long accountId) {
    }

    private void checkOrg(Long orgId) {
    }

    private void validateParams(UmcInvoiceAddressAddReqBo reqBo) {
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getContactNameWeb())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8054\u7cfb\u4eba[contactNameWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getAddrDesc())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8be6\u7ec6\u5730\u5740[addrDesc]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getAreaName())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2\u6240\u5728\u5730\u533a\u540d\u79f0[areaName]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTel())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2\u624b\u673a\u53f7\u7801[areaName]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u5730\u5740[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.InvAddrMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.InvAddrMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u5730\u5740[mainFlag]\u53c2\u6570\u53ea\u80fd\u4e3a0\u62161");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getAreaCode())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2\u6240\u5728\u5730\u533a\u7f16\u7801[areaCode]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMemIdExt()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2\u4f1a\u5458ID[memIdExt]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

