/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.signcontractapply;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.signcontract.IUmcSignContractModel;
import com.tydic.dyc.umc.model.signcontract.SignContractDo;
import com.tydic.dyc.umc.model.signcontractapply.IUmcSignContractApplyModel;
import com.tydic.dyc.umc.model.signcontractapply.UmcSignContractApplyDo;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractLog;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractYearRuleApply;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignSalesCategoryApply;
import com.tydic.dyc.umc.service.signcontractapply.UmcCreateSignContractTransferService;
import com.tydic.dyc.umc.service.signcontractapply.bo.UmcCreateSignContractTransferReqBo;
import com.tydic.dyc.umc.service.signcontractapply.bo.UmcCreateSignContractTransferRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.signcontractapply.UmcCreateSignContractTransferService"})
public class UmcCreateSignContractTransferServiceImpl
implements UmcCreateSignContractTransferService {
    private static final Logger log = LoggerFactory.getLogger(UmcCreateSignContractTransferServiceImpl.class);
    @Autowired
    private IUmcSignContractApplyModel iUmcSignContractApplyModel;
    @Autowired
    private IUmcSignContractModel iUmcSignContractModel;

    @PostMapping(value={"createSignContractTransfer"})
    public UmcCreateSignContractTransferRspBo createSignContractTransfer(@RequestBody UmcCreateSignContractTransferReqBo reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u7b7e\u7ea6\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcSignContractApplyDo reqDo = UmcRu.js(reqBo, UmcSignContractApplyDo.class);
        if (reqDo.getApplyId() == null) {
            reqDo.setApplyId(IdUtil.nextId());
        }
        reqDo.setTenantId(reqBo.getTenantId());
        reqDo.setOrgId(reqBo.getOrgId());
        reqDo.setOrgName(reqBo.getOrgName());
        reqDo.setApplyType("2");
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSignSalesCategoryApplyBos())) {
            List<SignSalesCategoryApply> salesCategoryApplies = UmcRu.jsl(reqBo.getSignSalesCategoryApplyBos(), SignSalesCategoryApply.class);
            for (SignSalesCategoryApply bo : salesCategoryApplies) {
                bo.setTenantId(reqBo.getTenantId());
            }
            reqDo.setSignSalesCategoryApplies(salesCategoryApplies);
        }
        SignContractLog logReqPo = new SignContractLog();
        logReqPo.setApplyId(reqBo.getApplyId());
        logReqPo.setCreateOperId(reqBo.getUserId());
        logReqPo.setCreateOperName(reqBo.getUserName());
        logReqPo.setCreateTime(new Date());
        logReqPo.setDelFlag("0");
        logReqPo.setTenantId(reqBo.getTenantId());
        logReqPo.setOperType(reqBo.getStatus().toString());
        if (reqBo.getStatus() != null) {
            if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.Draft)) {
                logReqPo.setOperTypeStr("\u4fdd\u5b58");
            } else if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.APPLYING)) {
                logReqPo.setOperTypeStr("\u63d0\u4ea4");
            } else if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.CONFIRM)) {
                logReqPo.setOperTypeStr("\u529e\u7406");
            } else if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.COMPLITE)) {
                logReqPo.setOperTypeStr("\u786e\u8ba4");
            } else if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.FEFUSE)) {
                logReqPo.setOperTypeStr("\u62d2\u7edd");
            }
        }
        logReqPo.setSignContractId(reqBo.getSignContractId());
        reqDo.setSignContractLogs(Arrays.asList(logReqPo));
        UmcSignContractApplyDo signContractApply = this.iUmcSignContractApplyModel.createSignContractApply(reqDo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSignContractYearRuleApplyBos())) {
            List<SignContractYearRuleApply> ruleApplies = UmcRu.jsl(reqBo.getSignContractYearRuleApplyBos(), SignContractYearRuleApply.class);
            UmcSignContractApplyDo ruleApplyDo = new UmcSignContractApplyDo();
            ruleApplyDo.setSignContractYearRuleApplies(ruleApplies);
            this.iUmcSignContractApplyModel.addSignContractYearRuleApplies(ruleApplyDo);
        }
        SignContractDo changeDo = new SignContractDo();
        changeDo.setSignContractId(reqDo.getSignContractId());
        changeDo.setApplyId(reqDo.getApplyId());
        this.iUmcSignContractModel.updateSignContract(changeDo);
        UmcCreateSignContractTransferRspBo rspBo = new UmcCreateSignContractTransferRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

