/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.domainservice;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.umcgoodscollection.IUmcGoodsCollectionModel;
import com.tydic.dyc.umc.model.umcgoodscollection.UmcGoodsCollectionDo;
import com.tydic.dyc.umc.model.umcgoodscollection.qrybo.UmcGoodsCollectionQryBo;
import com.tydic.dyc.umc.service.domainservice.UmcAddGoodsCollectionsService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcAddGoodsCollectionsReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcAddGoodsCollectionsRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.domainservice.UmcAddGoodsCollectionsService"})
public class UmcAddGoodsCollectionsServiceImpl
implements UmcAddGoodsCollectionsService {
    private static final Logger log = LoggerFactory.getLogger(UmcAddGoodsCollectionsServiceImpl.class);
    @Autowired
    private IUmcGoodsCollectionModel iUmcGoodsCollectionModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"addGoodsCollections"})
    public UmcAddGoodsCollectionsRspBo addGoodsCollections(@RequestBody UmcAddGoodsCollectionsReqBo umcAddGoodsCollectionsReqBo) {
        this.validateAdd(umcAddGoodsCollectionsReqBo);
        UmcGoodsCollectionQryBo umcGoodsCollectionQryBo = new UmcGoodsCollectionQryBo();
        umcGoodsCollectionQryBo.setUserId(umcAddGoodsCollectionsReqBo.getUserId());
        umcGoodsCollectionQryBo.setSkuId(umcAddGoodsCollectionsReqBo.getSkuId());
        umcGoodsCollectionQryBo.setShopCode(umcAddGoodsCollectionsReqBo.getShopCode());
        BasePageRspBo<UmcGoodsCollectionDo> goodsCollectionsPageList = this.iUmcGoodsCollectionModel.getGoodsCollectionsPageList(umcGoodsCollectionQryBo);
        if (goodsCollectionsPageList != null && !CollectionUtils.isEmpty((Collection)goodsCollectionsPageList.getRows())) {
            throw new BaseBusinessException("200100", "\u8be5\u5546\u54c1\u5df2\u7ecf\u6536\u85cf");
        }
        Map<String, String> serviceFeeNodeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap("UMC_PLUS", "COLLECTION_SHOP_MAX");
        int collectionLimit = 0;
        if (serviceFeeNodeMap != null && serviceFeeNodeMap.containsKey("COLLECTION_SHOP_MAX")) {
            String limit = serviceFeeNodeMap.get("COLLECTION_SHOP_MAX");
            try {
                collectionLimit = Integer.parseInt(limit);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                log.error("\u5546\u54c1\u6536\u85cf\u4e0a\u9650\u8f6c\u6362\u9519\u8bef");
            }
        }
        if (collectionLimit > 0) {
            UmcGoodsCollectionQryBo reqBo = new UmcGoodsCollectionQryBo();
            reqBo.setPageSize(-1);
            reqBo.setUserId(umcAddGoodsCollectionsReqBo.getUserId());
            BasePageRspBo<UmcGoodsCollectionDo> goodsCollectionsPageList1 = this.iUmcGoodsCollectionModel.getGoodsCollectionsPageList(reqBo);
            if (goodsCollectionsPageList1 != null && !CollectionUtils.isEmpty((Collection)goodsCollectionsPageList1.getRows()) && goodsCollectionsPageList1.getRows().size() > collectionLimit) {
                throw new BaseBusinessException("200001", "\u8be5\u4f1a\u5458\u5df2\u6536\u85cf" + collectionLimit + "\u4ef6\u5546\u54c1,\u8fbe\u5230\u6536\u85cf\u5546\u54c1\u4e0a\u9650");
            }
        }
        UmcGoodsCollectionDo js = StrUtil.noNullStringAttr(UmcRu.js(umcAddGoodsCollectionsReqBo, UmcGoodsCollectionDo.class));
        js.setDelFlag("0");
        js.setTenantId(umcAddGoodsCollectionsReqBo.getTenantId());
        js.setJoinTime(new Date());
        js.setCreateOperId(umcAddGoodsCollectionsReqBo.getUserId());
        js.setCreateOperName(umcAddGoodsCollectionsReqBo.getUserName());
        js.setCreateTime(new Date());
        return UmcRu.js((Object)this.iUmcGoodsCollectionModel.addGoodsCollections(js), UmcAddGoodsCollectionsRspBo.class);
    }

    private void validateAdd(UmcAddGoodsCollectionsReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null || reqBo.getUserId() == 0L) {
            throw new BaseBusinessException("200001", "\u4f1a\u5458\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (reqBo.getSkuId() == null || reqBo.getSkuId() == 0L) {
            throw new BaseBusinessException("200001", "\u8be5\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopCode())) {
            throw new BaseBusinessException("200001", "\u8be5\u5546\u54c1\u6240\u5728\u5546\u5e97\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((Object)reqBo.getSkuImgUrl())) {
            throw new BaseBusinessException("200001", "\u8be5\u5546\u54c1\u56fe\u7247\u6709\u8bef");
        }
        if (StringUtils.isEmpty((Object)reqBo.getSkuSource())) {
            throw new BaseBusinessException("200001", "\u8be5\u5546\u54c1\u6765\u6e90\u6709\u8bef");
        }
        if (StringUtils.isEmpty((Object)reqBo.getSupplierName())) {
            throw new BaseBusinessException("200001", "\u8be5\u5546\u54c1\u65e0\u4f9b\u5e94\u5546\uff0c\u8bf7\u786e\u8ba4");
        }
        if (StringUtils.isEmpty((Object)reqBo.getSupplierShopId())) {
            throw new BaseBusinessException("200001", "\u8be5\u5546\u54c1\u4f9b\u5e94\u5e97\u94fa\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4");
        }
    }
}

