/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.model.todo.impl;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcQryWaitDoneConfigListQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoDoneQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoItemQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoCount;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.model.todo.sub.UmcWaitDoneConfig;
import com.tydic.dyc.umc.repository.UmcTodoRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcTodoModelImpl
implements IUmcTodoModel {
    @Autowired
    private UmcTodoRepository umcTodoRepository;

    @Override
    public List<UmcTodoCount> selectTodoCount(UmcTodoQryBo umcTodoQryBo) {
        return this.umcTodoRepository.selectTodoCount(umcTodoQryBo);
    }

    @Override
    public BasePageRspBo<UmcTodoItem> selectTodoItemListPage(UmcTodoItemQryBo umcTodoItemQryBo) {
        return this.umcTodoRepository.selectTodoItemListPage(umcTodoItemQryBo);
    }

    @Override
    public List<UmcTodoItem> selectTodoItemList(UmcTodoItemQryBo umcTodoItemQryBo) {
        return this.umcTodoRepository.selectTodoItemList(umcTodoItemQryBo);
    }

    @Override
    public BasePageRspBo<UmcTodoDo> selectTodoListPage(UmcTodoQryBo umcTodoQryBo) {
        return this.umcTodoRepository.selectTodoListPage(umcTodoQryBo);
    }

    @Override
    public List<UmcTodoDo> selectTodoList(UmcTodoQryBo umcTodoQryBo) {
        return this.umcTodoRepository.selectTodoList(umcTodoQryBo);
    }

    @Override
    public BasePageRspBo<UmcTodoDone> selectDoneListPage(UmcTodoDoneQryBo umcTodoDoneQryBo) {
        return this.umcTodoRepository.selectDoneListPage(umcTodoDoneQryBo);
    }

    @Override
    public int createTodo(List<UmcTodoDo> umcTodoDos) {
        return this.umcTodoRepository.createTodo(umcTodoDos);
    }

    @Override
    public int createDone(List<UmcTodoDone> umcTodoDones) {
        return this.umcTodoRepository.createDone(umcTodoDones);
    }

    @Override
    public int deleteTodo(UmcTodoDo umcTodoDo) {
        return this.umcTodoRepository.deleteTodo(umcTodoDo);
    }

    @Override
    public List<UmcTodoItem> selectWaitDoneList(UmcTodoItem js) {
        return this.umcTodoRepository.selectWaitDoneList(js);
    }

    @Override
    public void dealWaitDoneSet(UmcTodoItem reqItem) {
        this.umcTodoRepository.ealWaitDoneSet(reqItem);
    }

    @Override
    public void deleteWaiteDoneItem(UmcTodoItem deleteItem) {
        this.umcTodoRepository.deleteWaiteDoneItem(deleteItem);
    }

    @Override
    public List<UmcWaitDoneConfig> qryWaitDoneList(UmcQryWaitDoneConfigListQryBo noNullStringAttr) {
        return this.umcTodoRepository.qryWaitDoneList(noNullStringAttr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendHaveDone(UmcTodoDone umcTodoDone) {
        if (null == umcTodoDone.getTodoId() && StringUtils.isBlank((CharSequence)umcTodoDone.getBusiId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5f85\u529eid\uff0c\u4e1a\u52a1id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)umcTodoDone.getOperId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5904\u7406\u4ebaid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)umcTodoDone.getOperName())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5904\u7406\u4eba\u540d\u79f0\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        UmcTodoQryBo umcTodoQryBo = new UmcTodoQryBo();
        umcTodoQryBo.setTodoId(umcTodoDone.getTodoId());
        umcTodoQryBo.setBusiId(umcTodoDone.getBusiId());
        umcTodoQryBo.setTodoItemCode(umcTodoDone.getTodoItemCode());
        List<UmcTodoDo> umcTodoPOS = this.selectTodoList(umcTodoQryBo);
        if (CollectionUtils.isEmpty(umcTodoPOS)) throw new BaseBusinessException("101020", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5f85\u529e\u4fe1\u606f\u4e0d\u5b58\u5728");
        UmcTodoDo deleteUmcTodoPO = new UmcTodoDo();
        deleteUmcTodoPO.setTodoId(umcTodoDone.getTodoId());
        deleteUmcTodoPO.setBusiId(umcTodoDone.getBusiId());
        deleteUmcTodoPO.setTodoItemCode(umcTodoDone.getTodoItemCode());
        int deleteResult = this.deleteTodo(deleteUmcTodoPO);
        if (deleteResult != umcTodoPOS.size()) throw new BaseBusinessException("101020", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5220\u9664\u5f85\u529e\u4fe1\u606f\u5931\u8d25");
        ArrayList<UmcTodoDone> list = new ArrayList<UmcTodoDone>();
        for (UmcTodoDo umcTodoInfo : umcTodoPOS) {
            UmcTodoDone insertUmcTodoDonePO = new UmcTodoDone();
            BeanUtils.copyProperties((Object)umcTodoInfo, (Object)insertUmcTodoDonePO);
            insertUmcTodoDonePO.setOperId(umcTodoDone.getOperId());
            insertUmcTodoDonePO.setOperName(umcTodoDone.getOperName());
            insertUmcTodoDonePO.setOperTime(new Date());
            insertUmcTodoDonePO.setTodoState(1);
            if (!umcTodoDone.getOperId().equals(umcTodoInfo.getCandidateOperId())) {
                insertUmcTodoDonePO.setTodoState(UmcCommConstant.TodoState.OTHER_DONE);
            }
            list.add(insertUmcTodoDonePO);
        }
        int insertBatchResult = this.createDone(list);
        if (insertBatchResult == umcTodoPOS.size()) return;
        throw new BaseBusinessException("101020", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u751f\u6210\u5df2\u529e\u4fe1\u606f\u5931\u8d25");
    }
}

