/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseExtMap;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseInvoice;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoAddService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoAddReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoAddRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoAddService"})
public class UmcEnterpriseInfoAddServiceImpl
implements UmcEnterpriseInfoAddService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"createEnterpriseInfo"})
    public UmcEnterpriseInfoAddRspBo createEnterpriseInfo(@RequestBody UmcEnterpriseInfoAddReqBo reqBo) {
        this.validateParams(reqBo);
        UmcEnterpriseInfoAddRspBo rspBo = UmcRu.success(UmcEnterpriseInfoAddRspBo.class);
        UmcOrgInfo orgInfo = this.buileOrgInfo(reqBo);
        orgInfo = this.iUmcEnterpriseInfoModel.createOrgInfo(orgInfo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseInvoiceBoList())) {
            List<UmcEnterpriseInvoice> enterpriseInvoiceList = UmcRu.jsl(reqBo.getEnterpriseInvoiceBoList(), UmcEnterpriseInvoice.class);
            for (UmcEnterpriseInvoice enterpriseInvoice : enterpriseInvoiceList) {
                enterpriseInvoice.setOrgId(orgInfo.getOrgId());
                enterpriseInvoice.setDelFlag("0");
                enterpriseInvoice.setCreateTime(new Date());
                enterpriseInvoice.setUpdateTime(enterpriseInvoice.getCreateTime());
                if (null != enterpriseInvoice.getInvoiceId()) continue;
                enterpriseInvoice.setInvoiceId(IdUtil.nextId());
            }
            this.iUmcEnterpriseInfoModel.createEnterpriseInvoice(StrUtil.noNullStringAttr(enterpriseInvoiceList));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseBankBoList())) {
            List<UmcEnterpriseBank> enterpriseBankList = UmcRu.jsl(reqBo.getEnterpriseBankBoList(), UmcEnterpriseBank.class);
            for (UmcEnterpriseBank enterpriseBank : enterpriseBankList) {
                enterpriseBank.setOrgId(orgInfo.getOrgId());
                enterpriseBank.setDelFlag("0");
                enterpriseBank.setCreateTime(new Date());
                enterpriseBank.setUpdateTime(enterpriseBank.getCreateTime());
                if (null == enterpriseBank.getBankId()) {
                    enterpriseBank.setBankId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseBank);
            }
            this.iUmcEnterpriseInfoModel.createEnterpriseBank(enterpriseBankList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseContactBoList())) {
            List<UmcEnterpriseContact> enterpriseContactList = UmcRu.jsl(reqBo.getEnterpriseContactBoList(), UmcEnterpriseContact.class);
            for (UmcEnterpriseContact enterpriseContact : enterpriseContactList) {
                enterpriseContact.setOrgId(orgInfo.getOrgId());
                enterpriseContact.setDelFlag("0");
                enterpriseContact.setCreateTime(new Date());
                enterpriseContact.setUpdateTime(enterpriseContact.getCreateTime());
                if (null == enterpriseContact.getContactId()) {
                    enterpriseContact.setContactId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseContact);
            }
            this.iUmcEnterpriseInfoModel.createEnterpriseContact(enterpriseContactList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseExt())) {
            List<UmcEnterpriseExtMap> enterpriseExtMapList = UmcRu.jsl(reqBo.getEnterpriseExt(), UmcEnterpriseExtMap.class);
            for (UmcEnterpriseExtMap enterpriseExtMap : enterpriseExtMapList) {
                if (null == enterpriseExtMap.getExtId()) {
                    enterpriseExtMap.setExtId(IdUtil.nextId());
                }
                enterpriseExtMap.setTenantId(orgInfo.getTenantId());
                enterpriseExtMap.setOrgId(orgInfo.getOrgId());
                Date date = new Date();
                enterpriseExtMap.setCreateTime(date);
                enterpriseExtMap.setUpdateTime(date);
                enterpriseExtMap.setDelFlag("0");
                StrUtil.noNullStringAttr(enterpriseExtMap);
            }
            this.iUmcEnterpriseInfoModel.createEnterpriseExtMap(enterpriseExtMapList);
        }
        UmcEnterpriseInfoDo umcEnterpriseInfoDo = UmcRu.js(reqBo, UmcEnterpriseInfoDo.class);
        umcEnterpriseInfoDo.setOrgId(orgInfo.getOrgId());
        umcEnterpriseInfoDo.setCreateTime(new Date());
        umcEnterpriseInfoDo.setUpdateTime(umcEnterpriseInfoDo.getCreateTime());
        StrUtil.noNullStringAttr(umcEnterpriseInfoDo);
        this.iUmcEnterpriseInfoModel.createEnterpriseInfo(StrUtil.noNullStringAttr(umcEnterpriseInfoDo));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UmcOrgInfo buileOrgInfo(UmcEnterpriseInfoAddReqBo reqBo) {
        UmcOrgInfo umcEnterpriseOrg = UmcRu.js(reqBo.getOrgInfoBo(), UmcOrgInfo.class);
        if (null == umcEnterpriseOrg.getOrgId()) {
            umcEnterpriseOrg.setOrgId(IdUtil.nextId());
        }
        umcEnterpriseOrg.setOrgStatus("1");
        umcEnterpriseOrg.setCreateTime(new Date());
        umcEnterpriseOrg.setUpdateTime(umcEnterpriseOrg.getCreateTime());
        umcEnterpriseOrg.setDelFlag("0");
        if (!CollectionUtils.isEmpty(umcEnterpriseOrg.getOrgTagRelList())) {
            for (UmcOrgTagRel orgTagRel : umcEnterpriseOrg.getOrgTagRelList()) {
                if (null == orgTagRel.getRelId()) {
                    orgTagRel.setRelId(IdUtil.nextId());
                }
                orgTagRel.setDelFlag("0");
            }
        }
        return umcEnterpriseOrg;
    }

    private void validateParams(UmcEnterpriseInfoAddReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u521b\u5efa \u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrgInfoBo())) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u521b\u5efa \u5165\u53c2[enterpriseOrgBo]\u4e3a\u7a7a\uff01");
        }
    }
}

