/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.supplieraccess;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseBankQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcSupplierInformation;
import com.tydic.dyc.umc.model.enterpriseapply.IUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.model.enterpriseapply.UmcEnterpriseInfoApplyDo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseBankApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseContactApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseInfoApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcOrgInfoApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseBankApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseContactApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcOrgInfoApply;
import com.tydic.dyc.umc.service.supplieraccess.api.UmcSupplierInfoAccessSubmitService;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcSupplierDataBo;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcSupplierInfoAccessSubmitReqBo;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcSupplierInfoAccessSubmitRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.supplieraccess.api.UmcSupplierInfoAccessSubmitService"})
public class UmcSupplierInfoAccessSubmitServiceImpl
implements UmcSupplierInfoAccessSubmitService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcEnterpriseInfoApplyModel iUmcEnterpriseInfoApplyModel;
    private static final String SUBMIT = "2";
    private static final String SAVE = "1";

    @PostMapping(value={"submitSupplierInformationAccess"})
    public UmcSupplierInfoAccessSubmitRspBo submitSupplierInformationAccess(@RequestBody UmcSupplierInfoAccessSubmitReqBo reqBO) {
        UmcEnterpriseInfoApplyDo umcEnterpriseInfoApplyDo;
        if (reqBO.getOrgIdWeb() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long applyId = 0L;
        try {
            umcEnterpriseInfoApplyDo = this.insertEnterprise(reqBO);
            applyId = umcEnterpriseInfoApplyDo.getApplyId();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException("200100", e.getMessage());
        }
        reqBO.setApplyId(Long.valueOf(applyId));
        this.insertContact(reqBO);
        this.updateOrg(reqBO);
        this.insertBank(reqBO);
        this.insertInformation(reqBO);
        UmcSupplierInfoAccessSubmitRspBo rspBo = new UmcSupplierInfoAccessSubmitRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setApplyId(reqBO.getApplyId());
        rspBo.setApplyStatus(umcEnterpriseInfoApplyDo.getApplyStatus());
        return rspBo;
    }

    private void insertInformation(UmcSupplierInfoAccessSubmitReqBo reqBO) {
        int i;
        UmcSupplierInformation qryInfoBo = new UmcSupplierInformation();
        qryInfoBo.setSupplierId(reqBO.getOrgIdWeb());
        List<UmcSupplierInformation> supInformationList = this.iUmcEnterpriseInfoModel.getSupInformationList(qryInfoBo);
        UmcSupplierInformation deletePO = new UmcSupplierInformation();
        deletePO.setSupplierId(reqBO.getOrgIdWeb());
        if (!CollectionUtils.isEmpty(supInformationList) && (i = this.iUmcEnterpriseInfoModel.deleteSupInformationById(deletePO)) < 1) {
            throw new BaseBusinessException("200100", "\u5220\u9664\u4f9b\u5e94\u5546\u4fe1\u606f\u8868\u5931\u8d25");
        }
        ArrayList<UmcSupplierInformation> list = new ArrayList<UmcSupplierInformation>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSupplierDataBOS())) {
            for (UmcSupplierDataBo umcSupplierDataBO : reqBO.getSupplierDataBOS()) {
                UmcSupplierInformation umcSupplierInformationPO = new UmcSupplierInformation();
                BeanUtils.copyProperties((Object)umcSupplierDataBO, (Object)umcSupplierInformationPO);
                if (!CollectionUtils.isEmpty((Collection)umcSupplierDataBO.getFieldFile())) {
                    umcSupplierInformationPO.setFieldFile(JSONObject.toJSONString((Object)umcSupplierDataBO.getFieldFile()));
                }
                umcSupplierInformationPO.setInfoId(IdUtil.nextId());
                umcSupplierInformationPO.setSupplierId(reqBO.getOrgIdWeb());
                list.add(umcSupplierInformationPO);
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.iUmcEnterpriseInfoModel.createSupInformationList(list);
        }
    }

    private void updateOrg(UmcSupplierInfoAccessSubmitReqBo reqBO) {
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        UmcOrgInfoApply insertOrgInfo = new UmcOrgInfoApply();
        orgInfoQryBo.setOrgId(reqBO.getOrgIdWeb());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (orgInfo == null) {
            throw new BaseBusinessException("200100", "\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcOrgInfoApplyQryBo orgInfoApplyQryBo = new UmcOrgInfoApplyQryBo();
        orgInfoApplyQryBo.setOrgId(reqBO.getOrgIdWeb());
        orgInfoApplyQryBo.setApplyId(reqBO.getApplyId());
        UmcOrgInfoApply orgInfoApply = this.iUmcEnterpriseInfoApplyModel.getOrgInfoApply(orgInfoApplyQryBo);
        if (orgInfoApply == null) {
            insertOrgInfo = UmcRu.js(orgInfo, UmcOrgInfoApply.class);
            insertOrgInfo.setApplyId(reqBO.getApplyId());
            insertOrgInfo.setOrgId(reqBO.getOrgIdWeb());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSupplierDataBOS())) {
            for (UmcSupplierDataBo umcSupplierDataBO : reqBO.getSupplierDataBOS()) {
                if ("gysmc".equals(umcSupplierDataBO.getFieldCode())) {
                    insertOrgInfo.setOrgName(umcSupplierDataBO.getFieldValue());
                }
                if (!"gysjc".equals(umcSupplierDataBO.getFieldCode())) continue;
                insertOrgInfo.setOrgAlias(umcSupplierDataBO.getFieldValue());
            }
        }
        if (orgInfoApply != null) {
            UmcOrgInfoApply where = new UmcOrgInfoApply();
            insertOrgInfo.setUpdateOperId(reqBO.getUserId());
            insertOrgInfo.setUpdateTime(new Date());
            insertOrgInfo.setUpdateOperName(reqBO.getRegAccountIn());
            where.setOrgId(reqBO.getOrgIdWeb());
            this.iUmcEnterpriseInfoApplyModel.updateOrgInfoApply(insertOrgInfo, where);
        } else {
            insertOrgInfo.setCreateOperId(reqBO.getUserId());
            insertOrgInfo.setCreateTime(new Date());
            insertOrgInfo.setCreateOperName(reqBO.getRegAccountIn());
            UmcOrgInfoApply umcOrgInfoApply = this.iUmcEnterpriseInfoApplyModel.createOrgInfoApply(insertOrgInfo);
        }
    }

    private void insertContact(UmcSupplierInfoAccessSubmitReqBo reqBO) {
        UmcEnterpriseContactApplyQryBo contactApplyQryBo = new UmcEnterpriseContactApplyQryBo();
        contactApplyQryBo.setOrgId(reqBO.getOrgIdWeb());
        contactApplyQryBo.setApplyId(reqBO.getApplyId());
        UmcEnterpriseContactApply enterpriseContactApply = this.iUmcEnterpriseInfoApplyModel.getEnterpriseContactApply(contactApplyQryBo);
        UmcEnterpriseContactQryBo contactQryBo = new UmcEnterpriseContactQryBo();
        contactQryBo.setOrgId(reqBO.getOrgIdWeb());
        UmcEnterpriseContact enterpriseContact = this.iUmcEnterpriseInfoModel.getEnterpriseContact(contactQryBo);
        UmcEnterpriseContactApply insertBo = new UmcEnterpriseContactApply();
        if (enterpriseContactApply == null && enterpriseContact != null) {
            BeanUtils.copyProperties((Object)enterpriseContact, (Object)insertBo);
        }
        insertBo.setTenantId(reqBO.getTenantIdIn());
        insertBo.setOrgId(reqBO.getOrgIdWeb());
        insertBo.setApplyId(reqBO.getApplyId());
        insertBo.setContactId(enterpriseContact.getContactId());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSupplierDataBOS())) {
            for (UmcSupplierDataBo umcSupplierDataBO : reqBO.getSupplierDataBOS()) {
                if ("lxr".equals(umcSupplierDataBO.getFieldCode())) {
                    insertBo.setContactName(umcSupplierDataBO.getFieldValue());
                }
                if ("sjhm".equals(umcSupplierDataBO.getFieldCode())) {
                    insertBo.setPhoneNumber(umcSupplierDataBO.getFieldValue());
                }
                if ("gddh".equals(umcSupplierDataBO.getFieldCode())) {
                    insertBo.setTel(umcSupplierDataBO.getFieldValue());
                }
                if ("yx".equals(umcSupplierDataBO.getFieldCode())) {
                    insertBo.setEmail(umcSupplierDataBO.getFieldValue());
                }
                if ("zjhm".equals(umcSupplierDataBO.getFieldCode())) {
                    insertBo.setCardNum(umcSupplierDataBO.getFieldValue());
                }
                if ("bsqrsfz".equals(umcSupplierDataBO.getFieldCode())) {
                    if (!CollectionUtils.isEmpty((Collection)umcSupplierDataBO.getFieldFile())) {
                        insertBo.setCardPicPeople(JSONObject.toJSONString((Object)umcSupplierDataBO.getFieldFile()));
                    } else {
                        insertBo.setCardPicPeople(umcSupplierDataBO.getFieldValue());
                    }
                }
                if (!"bsqrsfzb".equals(umcSupplierDataBO.getFieldCode())) continue;
                if (!CollectionUtils.isEmpty((Collection)umcSupplierDataBO.getFieldFile())) {
                    insertBo.setCardPicNational(JSONObject.toJSONString((Object)umcSupplierDataBO.getFieldFile()));
                    continue;
                }
                insertBo.setCardPicNational(umcSupplierDataBO.getFieldValue());
            }
        }
        if (enterpriseContactApply != null) {
            UmcEnterpriseContactApply where = new UmcEnterpriseContactApply();
            insertBo.setUpdateOperId(reqBO.getUserId());
            insertBo.setUpdateOperName(reqBO.getRegAccountIn());
            insertBo.setUpdateTime(new Date());
            where.setApplyId(enterpriseContactApply.getApplyId());
            this.iUmcEnterpriseInfoApplyModel.updateEnterpriseContactApply(insertBo, where);
        } else {
            insertBo.setCreateOperId(reqBO.getUserId());
            insertBo.setCreateOperName(reqBO.getRegAccountIn());
            insertBo.setCreateTime(new Date());
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseContactApply(insertBo);
        }
    }

    public UmcEnterpriseInfoApplyDo insertEnterprise(UmcSupplierInfoAccessSubmitReqBo reqBO) throws ParseException {
        UmcEnterpriseInfoApplyQryBo enterpriseInfoPO = new UmcEnterpriseInfoApplyQryBo();
        enterpriseInfoPO.setOrgId(reqBO.getOrgIdWeb());
        enterpriseInfoPO.setApplyType(String.valueOf(UmcCommConstant.OBJ_BUSI_TYPE.SUPPLIER_ACCESS));
        UmcEnterpriseInfoApplyDo eninfoChngPO = this.iUmcEnterpriseInfoApplyModel.getEnterpriseInfoApply(enterpriseInfoPO);
        UmcEnterpriseInfoApplyDo infoChngPO = new UmcEnterpriseInfoApplyDo();
        infoChngPO.setOrgId(reqBO.getOrgIdWeb());
        infoChngPO.setApplyType(String.valueOf(UmcCommConstant.OBJ_BUSI_TYPE.SUPPLIER_ACCESS));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (SAVE.equals(reqBO.getOperType())) {
            infoChngPO.setApplyStatus("3");
        } else if (SUBMIT.equals(reqBO.getOperType())) {
            infoChngPO.setApplyStatus("0");
            infoChngPO.setSupplierAccessTime(simpleDateFormat.format(new Date()));
            infoChngPO.setCreateTime(new Date());
            infoChngPO.setSupplierManageId(reqBO.getUserId().toString());
        }
        infoChngPO.setTenantId(reqBO.getTenantIdIn());
        infoChngPO.setIsMerchant("0");
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSupplierDataBOS())) {
            for (UmcSupplierDataBo umcSupplierDataBO : reqBO.getSupplierDataBOS()) {
                if ("gysmc".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setOrgName(umcSupplierDataBO.getFieldValue());
                }
                if ("gyslx".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setSupplierType(umcSupplierDataBO.getFieldValue());
                }
                if ("gslx".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setOrgNature(umcSupplierDataBO.getFieldValue());
                }
                if ("tyshxydm".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setCreditNo(umcSupplierDataBO.getFieldValue());
                }
                if ("zczj".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setCapital(umcSupplierDataBO.getFieldValue());
                }
                if ("clrq".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setEffDate(umcSupplierDataBO.getFieldValue());
                }
                if ("yyqx".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setExpDate(umcSupplierDataBO.getFieldValue());
                }
                if ("zcdz".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setProvince(umcSupplierDataBO.getFieldValue());
                }
                if ("xxdz".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setAddress(umcSupplierDataBO.getFieldValue());
                }
                if ("jyfw".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setBusinessScope(umcSupplierDataBO.getFieldValue());
                }
                if ("yyzz".equals(umcSupplierDataBO.getFieldCode())) {
                    if (!CollectionUtils.isEmpty((Collection)umcSupplierDataBO.getFieldFile())) {
                        infoChngPO.setBusinessLicense(JSONObject.toJSONString((Object)umcSupplierDataBO.getFieldFile()));
                    } else {
                        infoChngPO.setBusinessLicense(umcSupplierDataBO.getFieldValue());
                    }
                }
                if ("fddbr".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setLegalPerson(umcSupplierDataBO.getFieldValue());
                }
                if ("zjlx".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setLegalCertificateType(umcSupplierDataBO.getFieldValue());
                }
                if ("zjhm".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setLegalCertificateNum(umcSupplierDataBO.getFieldValue());
                }
                if ("fddbrzj".equals(umcSupplierDataBO.getFieldCode()) && !CollectionUtils.isEmpty((Collection)umcSupplierDataBO.getFieldFile())) {
                    infoChngPO.setLegalCertificateFront(JSONObject.toJSONString((Object)umcSupplierDataBO.getFieldFile()));
                }
                if ("fddbrzjb".equals(umcSupplierDataBO.getFieldCode()) && !CollectionUtils.isEmpty((Collection)umcSupplierDataBO.getFieldFile())) {
                    infoChngPO.setLegalCertificateBack(JSONObject.toJSONString((Object)umcSupplierDataBO.getFieldFile()));
                }
                if ("gysywmc".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setOrgEnName(umcSupplierDataBO.getFieldValue());
                }
                if ("gysjc".equals(umcSupplierDataBO.getFieldCode())) {
                    infoChngPO.setOrgShortName(umcSupplierDataBO.getFieldValue());
                }
                if (!"qysqwtssmj".equals(umcSupplierDataBO.getFieldCode())) continue;
                if (!CollectionUtils.isEmpty((Collection)umcSupplierDataBO.getFieldFile())) {
                    infoChngPO.setCapaPicture(JSONObject.toJSONString((Object)umcSupplierDataBO.getFieldFile()));
                    continue;
                }
                infoChngPO.setCapaPicture(umcSupplierDataBO.getFieldValue());
            }
        }
        if (null == eninfoChngPO) {
            infoChngPO.setCreateOperId(reqBO.getUserId());
            infoChngPO.setCreateOperName(reqBO.getRegAccountIn());
            infoChngPO.setApplyId(IdUtil.nextId());
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseInfoApply(infoChngPO);
            Long applyId = infoChngPO.getApplyId();
        } else {
            infoChngPO.setUpdateOperId(reqBO.getUserId());
            infoChngPO.setUpdateOperName(reqBO.getRegAccountIn());
            infoChngPO.setUpdateTime(new Date());
            UmcEnterpriseInfoApplyDo where = new UmcEnterpriseInfoApplyDo();
            where.setApplyId(eninfoChngPO.getApplyId());
            this.iUmcEnterpriseInfoApplyModel.updateEnterpriseInfoApply(infoChngPO, where);
            Long applyId = eninfoChngPO.getApplyId();
        }
        return eninfoChngPO;
    }

    public void insertBank(UmcSupplierInfoAccessSubmitReqBo reqBO) {
        UmcEnterpriseBankApplyQryBo bankInfoChngPO = new UmcEnterpriseBankApplyQryBo();
        bankInfoChngPO.setOrgId(reqBO.getOrgIdWeb());
        bankInfoChngPO.setApplyId(reqBO.getApplyId());
        UmcEnterpriseBankApply enterpriseBankInfoChngPO = this.iUmcEnterpriseInfoApplyModel.getEnterpriseBankApply(bankInfoChngPO);
        UmcEnterpriseBankQryBo bankInfoPO = new UmcEnterpriseBankQryBo();
        bankInfoPO.setOrgId(reqBO.getOrgIdWeb());
        UmcEnterpriseBank enterpriseBankInfoPO = this.iUmcEnterpriseInfoModel.getEnterpriseBank(bankInfoPO);
        UmcEnterpriseBankApply infoPO = new UmcEnterpriseBankApply();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSupplierDataBOS())) {
            List umcSupplierDataBOS = reqBO.getSupplierDataBOS();
            for (UmcSupplierDataBo umcSupplierDataBO : umcSupplierDataBOS) {
                if ("khyhzh".equals(umcSupplierDataBO.getFieldCode())) {
                    infoPO.setBankAccount(umcSupplierDataBO.getFieldValue());
                }
                if ("khyh".equals(umcSupplierDataBO.getFieldCode())) {
                    infoPO.setBankName(umcSupplierDataBO.getFieldValue());
                }
                if ("khmc".equals(umcSupplierDataBO.getFieldCode())) {
                    infoPO.setBankAccountName(umcSupplierDataBO.getFieldValue());
                }
                if ("khhlhh".equals(umcSupplierDataBO.getFieldCode())) {
                    infoPO.setBankLinkNo(umcSupplierDataBO.getFieldValue());
                }
                if (!"khhdz".equals(umcSupplierDataBO.getFieldCode())) continue;
                infoPO.setBankAddr(umcSupplierDataBO.getFieldValue());
            }
        }
        infoPO.setApplyId(reqBO.getApplyId());
        infoPO.setOrgId(reqBO.getOrgIdWeb());
        infoPO.setTenantId(reqBO.getTenantIdIn());
        if (enterpriseBankInfoPO != null) {
            infoPO.setBankId(enterpriseBankInfoPO.getBankId());
        } else {
            infoPO.setBankId(IdUtil.nextId());
        }
        if (null != enterpriseBankInfoChngPO) {
            infoPO.setUpdateOperId(reqBO.getUserId());
            infoPO.setUpdateTime(new Date());
            infoPO.setUpdateOperName(reqBO.getRegAccountIn());
            UmcEnterpriseBankApply where = new UmcEnterpriseBankApply();
            where.setApplyId(reqBO.getApplyId());
            this.iUmcEnterpriseInfoApplyModel.updateEnterpriseBankApply(infoPO, where);
        } else {
            infoPO.setCreateOperId(reqBO.getUserId());
            infoPO.setCreateOperName(reqBO.getRegAccountIn());
            infoPO.setCreateTime(new Date());
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseBankApply(infoPO);
        }
    }
}

