/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.user.UmcUserInfoChangePositionService;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoChangePositionReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoChangePositionRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.user.UmcUserInfoChangePositionService"})
public class UmcUserInfoChangePositionServiceImpl
implements UmcUserInfoChangePositionService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"changePositionUserInfo"})
    public UmcUserInfoChangePositionRspBo changePositionUserInfo(@RequestBody UmcUserInfoChangePositionReqBo reqBo) {
        this.validReqParam(reqBo);
        UmcUserInfoChangePositionRspBo rspBo = UmcRu.success(UmcUserInfoChangePositionRspBo.class);
        UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
        userInfoQryBo.setUserId(reqBo.getUserId());
        userInfoQryBo.setDelFlag("0");
        UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getUserInfo(userInfoQryBo);
        if (null == userInfoDo) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBo.getNewOrgId());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (null == orgInfo) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        UmcUserInfoDo umcUserInfoDo = this.buildUserInfo(reqBo, userInfoDo);
        umcUserInfoDo.setOrgTreePath(orgInfo.getOrgTreePath());
        this.iUmcUserInfoModel.createUserInfo(umcUserInfoDo);
        UmcUserInfoDo userInfoDoSet = new UmcUserInfoDo();
        userInfoDoSet.setStopStatus("00");
        userInfoDoSet.setIsMain("0");
        userInfoDoSet.setDelFlag("1");
        UmcUserInfoDo userInfoDoWhere = new UmcUserInfoDo();
        userInfoDoWhere.setUserId(reqBo.getUserId());
        this.iUmcUserInfoModel.updateUserInfo(userInfoDoSet, userInfoDoWhere);
        rspBo.setUserInfoBo(UmcRu.js(umcUserInfoDo, UmcUserInfoBo.class));
        return rspBo;
    }

    private UmcUserInfoDo buildUserInfo(UmcUserInfoChangePositionReqBo reqBo, UmcUserInfoDo userInfoDo) {
        UmcUserInfoDo umcUserInfoDo = UmcRu.js(userInfoDo, UmcUserInfoDo.class);
        umcUserInfoDo.setUserId(reqBo.getNewUserId());
        umcUserInfoDo.setOrgId(reqBo.getNewOrgId());
        umcUserInfoDo.setCustInfo(null);
        if (!CollectionUtils.isEmpty(userInfoDo.getUserTagRelList())) {
            for (UmcUserTagRel userTagRel : userInfoDo.getUserTagRelList()) {
                userTagRel.setRelId(IdUtil.nextId());
                userTagRel.setUserId(reqBo.getNewUserId());
            }
            umcUserInfoDo.setUserTagRelList(userInfoDo.getUserTagRelList());
        }
        if (!CollectionUtils.isEmpty(userInfoDo.getUserRoleRelList())) {
            for (UmcUserRoleRel userRoleRel : userInfoDo.getUserRoleRelList()) {
                userRoleRel.setRelId(IdUtil.nextId());
                userRoleRel.setUserId(reqBo.getNewUserId());
            }
            umcUserInfoDo.setUserRoleRelList(userInfoDo.getUserRoleRelList());
        }
        return umcUserInfoDo;
    }

    private void validReqParam(UmcUserInfoChangePositionReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewOrgId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[NewOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

